# -*- coding: utf-8 -*-
"""Nvidia Crawler.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/1BiO8-5XFSdY5H_wpxBr9PFIOb-thRHPx
"""

import requests
from bs4 import BeautifulSoup
import re
import nest_asyncio
import asyncio
import aiohttp
import asyncio
from bs4 import BeautifulSoup
import re

nest_asyncio.apply()

# Set to track visited links
visited_links = set()
count = 0

# Asynchronous helper function
async def fetch(session, url):
    try:
        async with session.get(url) as response:
            if response.status == 200:
                return await response.text()
    except Exception as e:
        print(f"Error while crawling {url}: {e}")
    return None

async def helper_simple_crawler(url, count, session, level):
    if count > level or url in visited_links:
        return

    visited_links.add(url)
    print(f"Crawling: {url}")
    count += 1

    html = await fetch(session, url)
    if html:
        soup = BeautifulSoup(html, 'html.parser')

        # Get and clean the text
        text = soup.get_text()
        text = re.sub(r'\s+', ' ', text)

        # Write the cleaned text to the file
        with open("sc_sb.txt", "a") as file:
            file.write(text + "\n\n")

        # Extract all valid links and crawl them recursively
        links = [link.get('href') for link in soup.find_all('a', href=True) if link.get('href') and 'https://' in link.get('href')]

        # Crawl links concurrently
        tasks = [helper_simple_crawler(link, count, session, level) for link in links]
        await asyncio.gather(*tasks)


async def main(start_url, level):
    async with aiohttp.ClientSession() as session:
        await helper_simple_crawler(start_url, 0, session, level)


start_url = input("Input the url you want to crawl: ")
level = input("How many level do you want to crawl? (recommand 1 or 2).")

# start_url = "https://sc.sb"
asyncio.run(main(start_url, int(level)))



# print(len(links))

# from google.colab import drive
# drive.mount('/content/drive')

# !cp -r /content/sc_sb.txt /content/drive/MyDrive/RAG