#  This repository is to collect GCN, GAT(graph attention) related resources.



# Github Repositories: 


## Implement:
1. [tkipf/gcn](https://github.com/tkipf/gcn), Implementation of Graph Convolutional Networks in TensorFlow, 
![](https://img.shields.io/github/stars/tkipf/gcn.svg)


2. [tkipf/keras-gcn](https://github.com/tkipf/keras-gcn), Keras implementation of Graph Convolutional Networks, 
![](https://img.shields.io/github/stars/tkipf/keras-gcn.svg)


3. [OCEChain/GCN](https://github.com/OCEChain/GCN), Graph Convolutional Networks, 
![](https://img.shields.io/github/stars/OCEChain/GCN.svg)

4. [PetarV-/GAT](https://github.com/PetarV-/GAT), Graph Attention Networks (https://arxiv.org/abs/1710.10903), 
![](https://img.shields.io/github/stars/PetarV-/GAT.svg)


5. [Diego999/pyGAT](https://github.com/Diego999/pyGAT), Pytorch implementation of the Graph Attention Network model by Veličković et. al (2017, https://arxiv.org/abs/1710.10903), 
![](https://img.shields.io/github/stars/Diego999/pyGAT.svg)


6. [mp2893/gram](https://github.com/mp2893/gram), Graph-based Attention Model, 
![](https://img.shields.io/github/stars/mp2893/gram.svg)


7. [danielegrattarola/keras-gat](https://github.com/danielegrattarola/keras-gat), Keras implementation of the graph attention networks (GAT) by Veličković et al. (2017; https://arxiv.org/abs/1710.10903), 
![](https://img.shields.io/github/stars/danielegrattarola/keras-gat.svg)

8. [Luckick/EAGCN](https://github.com/Luckick/EAGCN), Implementation of Edge Attention based Multi-relational Graph Convolutional Networks, 
![](https://img.shields.io/github/stars/Luckick/EAGCN.svg)





## Improved GCN:
1. [lightaime/deep_gcns](https://github.com/lightaime/deep_gcns), Repo for "Can GCNs Go as Deep as CNNs?", 
![](https://img.shields.io/github/stars/lightaime/deep_gcns.svg)


## Example & Tutorial: 
1. [dbusbridge/gcn_tutorial](https://github.com/dbusbridge/gcn_tutorial),  A tutorial on Graph Convolutional Neural Networks, 
![](https://img.shields.io/github/stars/dbusbridge/gcn_tutorial.svg)


## Knowledge Graph:

1. [tkipf/relational-gcn](https://github.com/tkipf/relational-gcn), Keras-based implementation of Relational Graph Convolutional Networks 
![](https://img.shields.io/github/stars/tkipf/relational-gcn.svg)

2. [1049451037/GCN-Align](https://github.com/1049451037/GCN-Align), Code of the paper: Cross-lingual Knowledge Graph Alignment via Graph Convolutional Networks.
![](https://img.shields.io/github/stars/tkipf/relational-gcn.svg)

3. [MichSchli/RelationPrediction](https://github.com/MichSchli/RelationPrediction), Implementation of R-GCNs for Relational Link Prediction
![](https://img.shields.io/github/stars/MichSchli/RelationPrediction.svg)

4. [xiangwang1223/knowledge_graph_attention_network](https://github.com/xiangwang1223/knowledge_graph_attention_network), KGAT: Knowledge Graph Attention Network for Recommendation, KDD2019,
![](https://img.shields.io/github/stars/xiangwang1223/knowledge_graph_attention_network.svg)

5. [deepakn97/relationPrediction](https://github.com/deepakn97/relationPrediction), ACL 2019: Learning Attention-based Embeddings for Relation Prediction in Knowledge Graphs, 
![](https://img.shields.io/github/stars/deepakn97/relationPrediction.svg)




## Relation Extraction:

1. [qipeng/gcn-over-pruned-trees](https://github.com/qipeng/gcn-over-pruned-trees),  Graph Convolution over Pruned Dependency Trees Improves Relation Extraction (authors' PyTorch implementation), 
![](https://img.shields.io/github/stars/qipeng/gcn-over-pruned-trees.svg)

2. [malllabiisc/RESIDE](https://github.com/malllabiisc/RESIDE), EMNLP 2018: RESIDE: Improving Distantly-Supervised Neural Relation Extraction using Side Information, 
![](https://img.shields.io/github/stars/malllabiisc/RESIDE.svg)

3. [Cartus/AGGCN_TACRED](https://github.com/Cartus/AGGCN_TACRED), Attention Guided Graph Convolutional Networks for Relation Extraction (authors' PyTorch implementation for the ACL19 paper), 
![](https://img.shields.io/github/stars/Cartus/AGGCN_TACRED.svg)



## Text Classification: 
1. [yao8839836/text_gcn](https://github.com/yao8839836/text_gcn), Graph Convolutional Networks for Text Classification. AAAI 2019, 
![](https://img.shields.io/github/stars/yao8839836/text_gcn.svg)

2. [yuanluo/text_gcn_tutorial](https://github.com/yuanluo/text_gcn_tutorial), This tutorial (currently under development) is based on the implementation of Text GCN in our paper: Liang Yao, Chengsheng Mao, Yuan Luo. "Graph Convolutional Networks for Text Classification." In 33rd AAAI Conference on Artificial Intelligence (AAAI-19), 
![](https://img.shields.io/github/stars/yuanluo/text_gcn_tutorial.svg)

3. [plkmo/Bible_Text_GCN](https://github.com/plkmo/Bible_Text_GCN), Text-Based Graph Convolution Network, 
![](https://img.shields.io/github/stars/plkmo/Bible_Text_GCN.svg)

4. [iamjagdeesh/Fake-News-Detection](https://github.com/iamjagdeesh/Fake-News-Detection), Fake news detector based on the content and users associated with it using BERT and Graph Attention Networks (GAT)., 
![](https://img.shields.io/github/stars/iamjagdeesh/Fake-News-Detection.svg)


## Word Embedding: 
3. [malllabiisc/WordGCN](https://github.com/malllabiisc/WordGCN), ACL 2019: Incorporating Syntactic and Semantic Information in Word Embeddings using Graph Convolutional Networks, 
![](https://img.shields.io/github/stars/malllabiisc/WordGCN.svg)



## NER:
1. [ContextScout/gcn_ner](https://github.com/ContextScout/gcn_ner), Graph Convolutional neural network named entity recognition, 
![](https://img.shields.io/github/stars/ContextScout/gcn_ner.svg)


## QA: 
1. [berc-uoft/Transformer-GCN-QA](https://github.com/berc-uoft/Transformer-GCN-QA), A multi-hop Q/A architecture based on transformers and GCNs,
![](https://img.shields.io/github/stars/berc-uoft/Transformer-GCN-QA.svg)


##  Coreference Resolution: 
1. [ianycxu/RGCN-with-BERT](https://github.com/ianycxu/RGCN-with-BERT), Graph Convolutional Networks (GCN) with BERT for Coreference Resolution Task [Pytorch][DGL],
![](https://img.shields.io/github/stars/ianycxu/RGCN-with-BERT.svg)


## Recommendation: 

1. [PeiJieSun/diffnet](https://github.com/PeiJieSun/diffnet),  This code is released for the paper: Le Wu, Peijie Sun, Yanjie Fu, Richang Hong, Xiting Wang and Meng Wang. A Neural Influence Diffusion Model for Social Recommendation. Accepted by SIGIR2019.
![](https://img.shields.io/github/stars/PeiJieSun/diffnet.svg)


## Skeleton-Based Action Recognition:

1. [yysijie/st-gcn](https://github.com/yysijie/st-gcn),   Spatial Temporal Graph Convolutional Networks (ST-GCN) for Skeleton-Based Action Recognition in PyTorch 
![](https://img.shields.io/github/stars/yysijie/st-gcn.svg)


##  Anomaly Detection:
1. [jx-zhong-for-academic-purpose/GCN-Anomaly-Detection](https://github.com/jx-zhong-for-academic-purpose/GCN-Anomaly-Detection), Placeholder of the source codes in CVPR 2019: Graph Convolutional Label Noise Cleaner: Train a Plug-and-play Action Classifier for Anomaly Detection. 
![](https://img.shields.io/github/stars/jx-zhong-for-academic-purpose/GCN-Anomaly-Detection.svg)

2. [kaize0409/GCN_AnomalyDetection](https://github.com/kaize0409/GCN_AnomalyDetection), Code for Deep Anomaly Detection on Attributed Networks (SDM2019).
![](https://img.shields.io/github/stars/kaize0409/GCN_AnomalyDetection.svg)

## Face Clustering: 
1. [Zhongdao/gcn_clustering](https://github.com/Zhongdao/gcn_clustering), Code for CVPR'19 paper Linkage-based Face Clustering via GCN, 
![](https://img.shields.io/github/stars/Zhongdao/gcn_clustering.svg)


2. [yl-1993/learn-to-cluster](https://github.com/yl-1993/learn-to-cluster),  Learning to Cluster Faces on an Affinity Graph (CVPR 2019), 
![](https://img.shields.io/github/stars/yl-1993/learn-to-cluster.svg)


## Person Attribute Recognition:
2. [2014gaokao/pedestrian-attribute-recognition-with-GCN](https://github.com/2014gaokao/pedestrian-attribute-recognition-with-GCN),  GCN for pedestrian attribute recognition in surveillance scenarios, 
![](https://img.shields.io/github/stars/2014gaokao/pedestrian-attribute-recognition-with-GCN.svg)

## Person Search: 
1. [sjtuzq/person_search_gcn](https://github.com/sjtuzq/person_search_gcn), This repository hosts the code for our paper “Learning Context Graph for Person Search”, CVPR2019 Oral, 
![](https://img.shields.io/github/stars/sjtuzq/person_search_gcn.svg)


##  Image Segmentation: 
1. [fidler-lab/curve-gcn](https://github.com/fidler-lab/curve-gcn), Official PyTorch code for Curve-GCN (CVPR 2019), 
![](https://img.shields.io/github/stars/fidler-lab/curve-gcn.svg)


## Image Classification: 

1. [chenzhaomin123/ML_GCN](https://github.com/chenzhaomin123/ML_GCN), PyTorch implementation of Multi-Label Image Recognition with Graph Convolutional Networks, CVPR 2019, 
![](https://img.shields.io/github/stars/chenzhaomin123/ML_GCN.svg)

2. [rusty1s/graph-based-image-classification](https://github.com/rusty1s/graph-based-image-classification),Implementation of Planar Graph Convolutional Networks in TensorFlow, 
![](https://img.shields.io/github/stars/rusty1s/graph-based-image-classification.svg)

2. [avirambh/MSDNet-GCN](https://github.com/avirambh/MSDNet-GCN),ICLR 2018 reproducibility challenge - Multi-Scale Dense Convolutional Networks for Efficient Prediction, 
![](https://img.shields.io/github/stars/avirambh/MSDNet-GCN.svg)

2. [JudyYe/zero-shot-gcn](https://github.com/JudyYe/zero-shot-gcn),Zero-Shot Learning with GCN (CVPR 2018), 
![](https://img.shields.io/github/stars/JudyYe/zero-shot-gcn.svg)


##  Scene Graph Generation: 
1. [NVIDIA/ContrastiveLosses4VRD](https://github.com/NVIDIA/ContrastiveLosses4VRD),Implementation for the CVPR2019 paper "Graphical Contrastive Losses for Scene Graph Generation", 
![](https://img.shields.io/github/stars/NVIDIA/ContrastiveLosses4VRD.svg)

2. [yuweihao/KERN](https://github.com/yuweihao/KERN),Code for Knowledge-Embedded Routing Network for Scene Graph Generation (CVPR 2019), 
![](https://img.shields.io/github/stars/yuweihao/KERN.svg)

3. [shijx12/XNM-Net](https://github.com/shijx12/XNM-Net),Pytorch implementation of "Explainable and Explicit Visual Reasoning over Scene Graphs ", 
![](https://img.shields.io/github/stars/shijx12/XNM-Net.svg)

4. [jiayan97/linknet-pytorch](https://github.com/jiayan97/linknet-pytorch),Pytorch reimplementation of LinkNet for Scene Graph Generation, 
![](https://img.shields.io/github/stars/jiayan97/linknet-pytorch.svg)


5. [Uehwan/3D-Scene-Graph](https://github.com/Uehwan/3D-Scene-Graph),3D scene graph generator implemented in Pytorch., 
![](https://img.shields.io/github/stars/Uehwan/3D-Scene-Graph.svg)


6. [Kenneth-Wong/sceneGraph_Mem](https://github.com/Kenneth-Wong/sceneGraph_Mem),Codes for CVPR 2019: Exploring Context and Visual Pattern of Relationship for Scene Graph Generation, Wenbin Wang, Ruiping Wang, Shiguang Shan, Xilin Chen, CVPR 2019., 
![](https://img.shields.io/github/stars/Kenneth-Wong/sceneGraph_Mem.svg)


7. [danfeiX/scene-graph-TF-release](https://github.com/danfeiX/scene-graph-TF-release),"Scene Graph Generation by Iterative Message Passing" code repository http://cs.stanford.edu/~danfei/scene-…, 
![](https://img.shields.io/github/stars/danfeiX/scene-graph-TF-release.svg)


8. [google/sg2im](https://github.com/google/sg2im),Code for "Image Generation from Scene Graphs", Johnson et al, CVPR 2018, 
![](https://img.shields.io/github/stars/google/sg2im.svg)


9. [rowanz/neural-motifs](https://github.com/rowanz/neural-motifs),Code for Neural Motifs: Scene Graph Parsing with Global Context (CVPR 2018) https://rowanzellers.com/neuralmotifs, 
![](https://img.shields.io/github/stars/rowanz/neural-motifs.svg)

10. [jwyang/graph-rcnn.pytorch](https://github.com/jwyang/graph-rcnn.pytorch),Pytorch code for our ECCV 2018 paper "Graph R-CNN for Scene Graph Generation" and other papers, 
![](https://img.shields.io/github/stars/jwyang/graph-rcnn.pytorch.svg)

11. [yikang-li/FactorizableNet](https://github.com/yikang-li/FactorizableNet), Factorizable Net (Multi-GPU version): An Efficient Subgraph-based Framework for Scene Graph Generation, 
![](https://img.shields.io/github/stars/yikang-li/FactorizableNet.svg)




## Traffic Flow: 
1. [lehaifeng/T-GCN](https://github.com/lehaifeng/T-GCN), Temporal Graph Convolutional Network for Urban Traffic Flow Prediction Method 
![](https://img.shields.io/github/stars/lehaifeng/T-GCN.svg)

2. [FrancesZhou/GCNTrafficPrediction](https://github.com/FrancesZhou/GCNTrafficPrediction), 
![](https://img.shields.io/github/stars/FrancesZhou/GCNTrafficPrediction.svg)

3. [Davidham3/ASTGCN](https://github.com/Davidham3/ASTGCN), Attention Based Spatial-Temporal Graph Convolutional Networks for Traffic Flow Forecasting (ASTGCN) AAAI 2019,
![](https://img.shields.io/github/stars/Davidham3/ASTGCN.svg)



## Disease Prediction: 
2. [parisots/population-gcn](https://github.com/parisots/population-gcn),Graph CNNs for population graphs: classification of the ABIDE dataset, 
![](https://img.shields.io/github/stars/parisots/population-gcn.svg)



## Path Prediction:
1. [Zhenye-Na/gcn-spp](https://github.com/Zhenye-Na/gcn-spp), Shortest Path prediction using Graph Convolutional Networks, 
![](https://img.shields.io/github/stars/Zhenye-Na/gcn-spp.svg)

2. [raphaelavalos/attention_tsp_graph_net](https://github.com/raphaelavalos/attention_tsp_graph_net), Implementation of Attention Solves Your TSP, Approximately (W. Kool et al.) with the DeepMind's Graph Nets library, 
![](https://img.shields.io/github/stars/raphaelavalos/attention_tsp_graph_net.svg)




## 3D Point Cloud: 
1. [maggie0106/Graph-CNN-in-3D-Point-Cloud-Classification](https://github.com/maggie0106/Graph-CNN-in-3D-Point-Cloud-Classification), Code for A GRAPH-CNN FOR 3D POINT CLOUD CLASSIFICATION (ICASSP 2018), 
![](https://img.shields.io/github/stars/maggie0106/Graph-CNN-in-3D-Point-Cloud-Classification.svg)


1. [jiexiong2016/GCNv2_SLAM](https://github.com/jiexiong2016/GCNv2_SLAM), Real-time SLAM system with deep features, 
![](https://img.shields.io/github/stars/jiexiong2016/GCNv2_SLAM.svg)


## Graph To Sequence: 
1. [wngzhiqi/Graph2Seq-Graph-to-Sequence-Learning-with-Attention-Based-Neural-Networks](https://github.com/wngzhiqi/Graph2Seq-Graph-to-Sequence-Learning-with-Attention-Based-Neural-Networks), This repo is project for 11785 (Deep Learning) at CMU. We are reproducing paper called "Graph2Seq: Graph to Sequence Learning with Attention-Based Neural Networks"(https://arxiv.org/pdf/1804.00823.pdf). Team Member: Zhiqi Wang, Ziyin Huang, Hong Du, Zhengkai Zhang, 
![](https://img.shields.io/github/stars/wngzhiqi/Graph2Seq-Graph-to-Sequence-Learning-with-Attention-Based-Neural-Networks.svg)

2. [syxu828/Graph2Seq-0.1](https://github.com/syxu828/Graph2Seq-0.1), This is the code for paper "Graph2Seq: Graph to Sequence Learning with Attention-based Neural Networks", 
![](https://img.shields.io/github/stars/syxu828/Graph2Seq-0.1.svg)



## Chemical Stability Prediction: 
1. [MingCPU/DeepChemStable](https://github.com/MingCPU/DeepChemStable), DeepChemStable: chemical stability prediction using attention-based graph convolution network, 
![](https://img.shields.io/github/stars/MingCPU/DeepChemStable.svg)
