# Awesome ChatGPT Plugins [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://openaicom.imgix.net/c51f2c96-3595-48ae-9fb6-165563fbb086/chat-plugins.png?w=200&h=200" width="200">](https://openai.com/blog/chatgpt-plugins)

> A curated list of awesome [ChatGPT Plugins](https://openai.com/blog/chatgpt-plugins), guides, blogs, and other resources.


## Contents
- [Official Plugins](#plugins)
- [Plugins](#plugins)
- [Demos](#demos)
- [Tutorials](#tutorials)
- [Blog Posts](#blog-posts)
- [Documentation](#documentation)

### What is a ChatGPT Plugin?
[![What is a ChatGPT Plugin?](https://res.cloudinary.com/marcomontalbano/image/upload/v1679667398/video_to_markdown/images/video--a267d1cba9d59411634ce2088744acf9-c05b58ac6eb4c4700831b2b3070cd403.jpg)](https://cdn.openai.com/chat-plugins/retrieval-gh-repo-readme/Retrieval-Final.mp4 "What is a ChatGPT Plugin?")
---


## Official Plugins
 - [Retrieval Plugin](https://github.com/openai/chatgpt-retrieval-plugin): The ChatGPT Retrieval Plugin repository provides a flexible solution for semantic search and retrieval of personal or organizational documents using natural language queries.
 - [Browsing](https://openai.com/blog/chatgpt-plugins#browsing): An experimental model that knows when and how to browse the internet
 - [Code Interpreter](https://openai.com/blog/chatgpt-plugins#code-interpreter): An experimental ChatGPT model that can use Python, handle uploads and downloads

## Unofficial Plugin Store
- [GPT Plugins Store](https://www.getit.ai/gpt-plugins): Plugins and API available.
- [Plugin list (unofficial)](https://github.com/jopilot-net/jopilot-4-job-seekers/blob/main/chat-gpt-plugins.md)

## Plugins:
- [Twilio Plugin](https://gist.github.com/danielgross/0e7a00ea882797acd92ae6779126abe3)
- [Simple TODO list](https://github.com/lencx/chat-todo-plugin): Plugin for managing a TODO list
- [Datasette](https://github.com/simonw/datasette-chatgpt-plugin): A Datasette plugin that turns a Datasette instance into a ChatGPT plugin
- [Airports](https://github.com/drnic/airports-chatgpt-plugin): Plugin to provide airport information, GPS position, that combines with ChatGPT's ability to calculate routes, times, headings, etc.
- [Google Search Plugin](https://github.com/Sogody/google-chatgpt-plugin): A plugin that uses Google Custom Search API to search the web

## Demos
- [Restaurant booking](https://twitter.com/gdb/status/1638949234681712643)
- [Retrieval](https://cdn.openai.com/chat-plugins/retrieval-gh-repo-readme/Retrieval-Final.mp4)
- [On-demand video processing](https://twitter.com/gdb/status/1638971232443076609)
- [Summarizing a HackerNews thread](https://twitter.com/gdb/status/1638986918947082241)
- [Official Zapier Integration](https://twitter.com/wadefoster/status/1638958299935801344)
- [Hacker News Summarisation](https://twitter.com/gdb/status/1638986918947082241)
- [Video File Processing](https://twitter.com/gdb/status/1638971232443076609)
- [Competitor PPC Ads](https://twitter.com/saad_codes/status/1645908869800144896?s=20)


## Tutorials
 - [(Official) Get a ChatGPT plugin up and running in under 5 minutes!](https://github.com/openai/plugins-quickstart)
 - [Extending ChatGPT with a Qdrant-based knowledge base](https://qdrant.tech/articles/chatgpt-plugin/)
 - [Building a ChatGPT + Pinecone LangChain Docs Plugin](https://github.com/pinecone-io/examples/blob/master/generation/chatgpt/plugins/langchain-docs-plugin.ipynb)
 - [LangChain + Retrieval Plugin](https://gist.github.com/hwchase17/1429e54879f0249f0a258382d8bd744c)
 - [Making a ChatGPT Plugin using GPT4](https://twitter.com/danielgross/status/1639040289816866818)
 - [Langchain on top of ChatGPT Plugins](https://python.langchain.com/en/latest/modules/agents/tools/examples/chatgpt_plugins.html): how to use ChatGPT Plugins within LangChain abstractions.
 - [Write ChatGPT plugin in Ruby and Sinatra](https://github.com/drnic/ruby-chatgpt-plugin-random-numbers)

## Blog Posts
 - [ChatGPT plugins (Announcement Post)](https://openai.com/blog/chatgpt-plugins)
 - [The Future of ChatGPT Plugins, from Jailbroken Prompts](https://app.orchard.ink/view/jailbreaking-chatgpt-plugin-a5b73bfb776948e68c1685b4d9572a70)


## Documentation
 - [OpenAI Plugin Docs](https://platform.openai.com/docs/plugins/introduction)
