/*!
 * jQuery Validation Plugin v1.17.0
 *
 * https://jqueryvalidation.org/
 *
 * Copyright (c) 2017 Jörn Zaefferer
 * Released under the MIT license
 */
(function(n){typeof define=="function"&&define.amd?define(["jquery","./jquery.validate"],n):typeof module=="object"&&module.exports?module.exports=n(require("jquery")):n(jQuery)})(function(n){return function(){function t(n){return n.replace(/<.[^<>]*?>/g," ").replace(/&nbsp;|&#160;/gi," ").replace(/[.(),;:!?%#$'\"_+=\/\-“”’]*/g,"")}n.validator.addMethod("maxWords",function(n,i,r){return this.optional(i)||t(n).match(/\b\w+\b/g).length<=r},n.validator.format("Please enter {0} words or less."));n.validator.addMethod("minWords",function(n,i,r){return this.optional(i)||t(n).match(/\b\w+\b/g).length>=r},n.validator.format("Please enter at least {0} words."));n.validator.addMethod("rangeWords",function(n,i,r){var u=t(n),f=/\b\w+\b/g;return this.optional(i)||u.match(f).length>=r[0]&&u.match(f).length<=r[1]},n.validator.format("Please enter between {0} and {1} words."))}(),n.validator.addMethod("accept",function(t,i,r){var f=typeof r=="string"?r.replace(/\s/g,""):"image/*",e=this.optional(i),u,o,s;if(e)return e;if(n(i).attr("type")==="file"&&(f=f.replace(/[\-\[\]\/\{\}\(\)\+\?\.\\\^\$\|]/g,"\\$&").replace(/,/g,"|").replace(/\/\*/g,"/.*"),i.files&&i.files.length))for(s=new RegExp(".?("+f+")$","i"),u=0;u<i.files.length;u++)if(o=i.files[u],!o.type.match(s))return!1;return!0},n.validator.format("Please enter a value with a valid mimetype.")),n.validator.addMethod("alphanumeric",function(n,t){return this.optional(t)||/^\w+$/i.test(n)},"Letters, numbers, and underscores only please"),n.validator.addMethod("bankaccountNL",function(n,t){if(this.optional(t))return!0;if(!/^[0-9]{9}|([0-9]{2} ){3}[0-9]{3}$/.test(n))return!1;for(var u=n.replace(/ /g,""),r=0,f=u.length,e,o,i=0;i<f;i++)e=f-i,o=u.substring(i,i+1),r=r+e*o;return r%11==0},"Please specify a valid bank account number"),n.validator.addMethod("bankorgiroaccountNL",function(t,i){return this.optional(i)||n.validator.methods.bankaccountNL.call(this,t,i)||n.validator.methods.giroaccountNL.call(this,t,i)},"Please specify a valid bank or giro account number"),n.validator.addMethod("bic",function(n,t){return this.optional(t)||/^([A-Z]{6}[A-Z2-9][A-NP-Z1-9])(X{3}|[A-WY-Z0-9][A-Z0-9]{2})?$/.test(n.toUpperCase())},"Please specify a valid BIC code"),n.validator.addMethod("cifES",function(n,t){"use strict";function v(n){return n%2==0}if(this.optional(t))return!0;var a=new RegExp(/^([ABCDEFGHJKLMNPQRSUVW])(\d{7})([0-9A-J])$/gi),o=n.substring(0,1),s=n.substring(1,8),f=n.substring(8,9),h=0,c=0,l=0,u,r,i,e;if(n.length!==9||!a.test(n))return!1;for(u=0;u<s.length;u++)r=parseInt(s[u],10),v(u)?(r*=2,l+=r<10?r:r-9):c+=r;return(h=c+l,i=(10-h.toString().substr(-1)).toString(),i=parseInt(i,10)>9?"0":i,e="JABCDEFGHI".substr(i,1).toString(),o.match(/[ABEH]/))?f===i:o.match(/[KPQS]/)?f===e:f===i||f===e},"Please specify a valid CIF number."),n.validator.addMethod("cpfBR",function(n){if(n=n.replace(/([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g,""),n.length!==11)return!1;var i=0,u,f,r,t;if(u=parseInt(n.substring(9,10),10),f=parseInt(n.substring(10,11),10),r=function(n,t){var i=n*10%11;return(i===10||i===11)&&(i=0),i===t},n===""||n==="00000000000"||n==="11111111111"||n==="22222222222"||n==="33333333333"||n==="44444444444"||n==="55555555555"||n==="66666666666"||n==="77777777777"||n==="88888888888"||n==="99999999999")return!1;for(t=1;t<=9;t++)i=i+parseInt(n.substring(t-1,t),10)*(11-t);if(r(i,u)){for(i=0,t=1;t<=10;t++)i=i+parseInt(n.substring(t-1,t),10)*(12-t);return r(i,f)}return!1},"Please specify a valid CPF number"),n.validator.addMethod("creditcard",function(n,t){if(this.optional(t))return"dependency-mismatch";if(/[^0-9 \-]+/.test(n))return!1;var f=0,i=0,u=!1,r,e;if(n=n.replace(/\D/g,""),n.length<13||n.length>19)return!1;for(r=n.length-1;r>=0;r--)e=n.charAt(r),i=parseInt(e,10),u&&(i*=2)>9&&(i-=9),f+=i,u=!u;return f%10==0},"Please enter a valid credit card number."),n.validator.addMethod("creditcardtypes",function(n,t,i){if(/[^0-9\-]+/.test(n))return!1;n=n.replace(/\D/g,"");var r=0;return(i.mastercard&&(r|=1),i.visa&&(r|=2),i.amex&&(r|=4),i.dinersclub&&(r|=8),i.enroute&&(r|=16),i.discover&&(r|=32),i.jcb&&(r|=64),i.unknown&&(r|=128),i.all&&(r=255),r&1&&/^(5[12345])/.test(n))?n.length===16:r&2&&/^(4)/.test(n)?n.length===16:r&4&&/^(3[47])/.test(n)?n.length===15:r&8&&/^(3(0[012345]|[68]))/.test(n)?n.length===14:r&16&&/^(2(014|149))/.test(n)?n.length===15:r&32&&/^(6011)/.test(n)?n.length===16:r&64&&/^(3)/.test(n)?n.length===16:r&64&&/^(2131|1800)/.test(n)?n.length===15:r&128?!0:!1},"Please enter a valid credit card number."),n.validator.addMethod("currency",function(n,t,i){var f=typeof i=="string",r=f?i:i[0],e=f?!0:i[1],u;return r=r.replace(/,/g,""),r=e?r+"]":r+"]?",u="^["+r+"([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}[0-9]{0,}(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$",u=new RegExp(u),this.optional(t)||u.test(n)},"Please specify a valid currency"),n.validator.addMethod("dateFA",function(n,t){return this.optional(t)||/^[1-4]\d{3}\/((0?[1-6]\/((3[0-1])|([1-2][0-9])|(0?[1-9])))|((1[0-2]|(0?[7-9]))\/(30|([1-2][0-9])|(0?[1-9]))))$/.test(n)},n.validator.messages.date),n.validator.addMethod("dateITA",function(n,t){var u=!1,i,f,e,o,r;return/^\d{1,2}\/\d{1,2}\/\d{4}$/.test(n)?(i=n.split("/"),f=parseInt(i[0],10),e=parseInt(i[1],10),o=parseInt(i[2],10),r=new Date(Date.UTC(o,e-1,f,12,0,0,0)),u=r.getUTCFullYear()===o&&r.getUTCMonth()===e-1&&r.getUTCDate()===f?!0:!1):u=!1,this.optional(t)||u},n.validator.messages.date),n.validator.addMethod("dateNL",function(n,t){return this.optional(t)||/^(0?[1-9]|[12]\d|3[01])[\.\/\-](0?[1-9]|1[012])[\.\/\-]([12]\d)?(\d\d)$/.test(n)},n.validator.messages.date),n.validator.addMethod("extension",function(n,t,i){return i=typeof i=="string"?i.replace(/,/g,"|"):"png|jpe?g|gif",this.optional(t)||n.match(new RegExp("\\.("+i+")$","i"))},n.validator.format("Please enter a value with a valid extension.")),n.validator.addMethod("giroaccountNL",function(n,t){return this.optional(t)||/^[0-9]{1,7}$/.test(n)},"Please specify a valid giro account number"),n.validator.addMethod("iban",function(n,t){if(this.optional(t))return!0;var i=n.replace(/ /g,"").toUpperCase(),f="",c=!0,e="",l="",a,o,s,v,h,y,p,r,u;if(i.length<5||(a=i.substring(0,2),y={AL:"\\d{8}[\\dA-Z]{16}",AD:"\\d{8}[\\dA-Z]{12}",AT:"\\d{16}",AZ:"[\\dA-Z]{4}\\d{20}",BE:"\\d{12}",BH:"[A-Z]{4}[\\dA-Z]{14}",BA:"\\d{16}",BR:"\\d{23}[A-Z][\\dA-Z]",BG:"[A-Z]{4}\\d{6}[\\dA-Z]{8}",CR:"\\d{17}",HR:"\\d{17}",CY:"\\d{8}[\\dA-Z]{16}",CZ:"\\d{20}",DK:"\\d{14}",DO:"[A-Z]{4}\\d{20}",EE:"\\d{16}",FO:"\\d{14}",FI:"\\d{14}",FR:"\\d{10}[\\dA-Z]{11}\\d{2}",GE:"[\\dA-Z]{2}\\d{16}",DE:"\\d{18}",GI:"[A-Z]{4}[\\dA-Z]{15}",GR:"\\d{7}[\\dA-Z]{16}",GL:"\\d{14}",GT:"[\\dA-Z]{4}[\\dA-Z]{20}",HU:"\\d{24}",IS:"\\d{22}",IE:"[\\dA-Z]{4}\\d{14}",IL:"\\d{19}",IT:"[A-Z]\\d{10}[\\dA-Z]{12}",KZ:"\\d{3}[\\dA-Z]{13}",KW:"[A-Z]{4}[\\dA-Z]{22}",LV:"[A-Z]{4}[\\dA-Z]{13}",LB:"\\d{4}[\\dA-Z]{20}",LI:"\\d{5}[\\dA-Z]{12}",LT:"\\d{16}",LU:"\\d{3}[\\dA-Z]{13}",MK:"\\d{3}[\\dA-Z]{10}\\d{2}",MT:"[A-Z]{4}\\d{5}[\\dA-Z]{18}",MR:"\\d{23}",MU:"[A-Z]{4}\\d{19}[A-Z]{3}",MC:"\\d{10}[\\dA-Z]{11}\\d{2}",MD:"[\\dA-Z]{2}\\d{18}",ME:"\\d{18}",NL:"[A-Z]{4}\\d{10}",NO:"\\d{11}",PK:"[\\dA-Z]{4}\\d{16}",PS:"[\\dA-Z]{4}\\d{21}",PL:"\\d{24}",PT:"\\d{21}",RO:"[A-Z]{4}[\\dA-Z]{16}",SM:"[A-Z]\\d{10}[\\dA-Z]{12}",SA:"\\d{2}[\\dA-Z]{18}",RS:"\\d{18}",SK:"\\d{20}",SI:"\\d{15}",ES:"\\d{20}",SE:"\\d{20}",CH:"\\d{5}[\\dA-Z]{12}",TN:"\\d{20}",TR:"\\d{5}[\\dA-Z]{17}",AE:"\\d{3}\\d{16}",GB:"[A-Z]{4}\\d{14}",VG:"[\\dA-Z]{4}\\d{16}"},h=y[a],typeof h!="undefined"&&(p=new RegExp("^[A-Z]{2}\\d{2}"+h+"$",""),!p.test(i))))return!1;for(o=i.substring(4,i.length)+i.substring(0,4),r=0;r<o.length;r++)s=o.charAt(r),s!=="0"&&(c=!1),c||(f+="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(s));for(u=0;u<f.length;u++)v=f.charAt(u),l=""+e+""+v,e=l%97;return e===1},"Please specify a valid IBAN"),n.validator.addMethod("integer",function(n,t){return this.optional(t)||/^-?\d+$/.test(n)},"A positive or negative non-decimal number please"),n.validator.addMethod("ipv4",function(n,t){return this.optional(t)||/^(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)\.(25[0-5]|2[0-4]\d|[01]?\d\d?)$/i.test(n)},"Please enter a valid IP v4 address."),n.validator.addMethod("ipv6",function(n,t){return this.optional(t)||/^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b)\.){3}(\b((25[0-5])|(1\d{2})|(2[0-4]\d)|(\d{1,2}))\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(n)},"Please enter a valid IP v6 address."),n.validator.addMethod("lettersonly",function(n,t){return this.optional(t)||/^[a-z]+$/i.test(n)},"Letters only please"),n.validator.addMethod("letterswithbasicpunc",function(n,t){return this.optional(t)||/^[a-z\-.,()'"\s]+$/i.test(n)},"Letters or punctuation only please"),n.validator.addMethod("mobileNL",function(n,t){return this.optional(t)||/^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)6((\s|\s?\-\s?)?[0-9]){8}$/.test(n)},"Please specify a valid mobile number"),n.validator.addMethod("mobileUK",function(n,t){return n=n.replace(/\(|\)|\s+|-/g,""),this.optional(t)||n.length>9&&n.match(/^(?:(?:(?:00\s?|\+)44\s?|0)7(?:[1345789]\d{2}|624)\s?\d{3}\s?\d{3})$/)},"Please specify a valid mobile number"),n.validator.addMethod("netmask",function(n,t){return this.optional(t)||/^(254|252|248|240|224|192|128)\.0\.0\.0|255\.(254|252|248|240|224|192|128|0)\.0\.0|255\.255\.(254|252|248|240|224|192|128|0)\.0|255\.255\.255\.(254|252|248|240|224|192|128|0)/i.test(n)},"Please enter a valid netmask."),n.validator.addMethod("nieES",function(n,t){"use strict";if(this.optional(t))return!0;var r=new RegExp(/^[MXYZ]{1}[0-9]{7,8}[TRWAGMYFPDXBNJZSQVHLCKET]{1}$/gi),u=n.substr(n.length-1).toUpperCase(),i;return(n=n.toString().toUpperCase(),n.length>10||n.length<9||!r.test(n))?!1:(n=n.replace(/^[X]/,"0").replace(/^[Y]/,"1").replace(/^[Z]/,"2"),i=n.length===9?n.substr(0,8):n.substr(0,9),"TRWAGMYFPDXBNJZSQVHLCKET".charAt(parseInt(i,10)%23)===u)},"Please specify a valid NIE number."),n.validator.addMethod("nifES",function(n,t){"use strict";return this.optional(t)?!0:(n=n.toUpperCase(),!n.match("((^[A-Z]{1}[0-9]{7}[A-Z0-9]{1}$|^[T]{1}[A-Z0-9]{8}$)|^[0-9]{8}[A-Z]{1}$)"))?!1:/^[0-9]{8}[A-Z]{1}$/.test(n)?"TRWAGMYFPDXBNJZSQVHLCKE".charAt(n.substring(8,0)%23)===n.charAt(8):/^[KLM]{1}/.test(n)?n[8]==="TRWAGMYFPDXBNJZSQVHLCKE".charAt(n.substring(8,1)%23):!1},"Please specify a valid NIF number."),n.validator.addMethod("nipPL",function(n){"use strict";var u,i,t,r,f;if(n=n.replace(/[^0-9]/g,""),n.length!==10)return!1;for(u=[6,5,7,2,3,4,5,6,7],i=0,t=0;t<9;t++)i+=u[t]*n[t];return r=i%11,f=r===10?0:r,f===parseInt(n[9],10)},"Please specify a valid NIP number."),n.validator.addMethod("notEqualTo",function(t,i,r){return this.optional(i)||!n.validator.methods.equalTo.call(this,t,i,r)},"Please enter a different value, values must not be the same."),n.validator.addMethod("nowhitespace",function(n,t){return this.optional(t)||/^\S+$/i.test(n)},"No white space please"),n.validator.addMethod("pattern",function(n,t,i){return this.optional(t)?!0:(typeof i=="string"&&(i=new RegExp("^(?:"+i+")$")),i.test(n))},"Invalid format."),n.validator.addMethod("phoneNL",function(n,t){return this.optional(t)||/^((\+|00(\s|\s?\-\s?)?)31(\s|\s?\-\s?)?(\(0\)[\-\s]?)?|0)[1-9]((\s|\s?\-\s?)?[0-9]){8}$/.test(n)},"Please specify a valid phone number."),n.validator.addMethod("phonesUK",function(n,t){return n=n.replace(/\(|\)|\s+|-/g,""),this.optional(t)||n.length>9&&n.match(/^(?:(?:(?:00\s?|\+)44\s?|0)(?:1\d{8,9}|[23]\d{9}|7(?:[1345789]\d{8}|624\d{6})))$/)},"Please specify a valid uk phone number"),n.validator.addMethod("phoneUK",function(n,t){return n=n.replace(/\(|\)|\s+|-/g,""),this.optional(t)||n.length>9&&n.match(/^(?:(?:(?:00\s?|\+)44\s?)|(?:\(?0))(?:\d{2}\)?\s?\d{4}\s?\d{4}|\d{3}\)?\s?\d{3}\s?\d{3,4}|\d{4}\)?\s?(?:\d{5}|\d{3}\s?\d{3})|\d{5}\)?\s?\d{4,5})$/)},"Please specify a valid phone number"),n.validator.addMethod("phoneUS",function(n,t){return n=n.replace(/\s+/g,""),this.optional(t)||n.length>9&&n.match(/^(\+?1-?)?(\([2-9]([02-9]\d|1[02-9])\)|[2-9]([02-9]\d|1[02-9]))-?[2-9]([02-9]\d|1[02-9])-?\d{4}$/)},"Please specify a valid phone number"),n.validator.addMethod("postalcodeBR",function(n,t){return this.optional(t)||/^\d{2}.\d{3}-\d{3}?$|^\d{5}-?\d{3}?$/.test(n)},"Informe um CEP válido."),n.validator.addMethod("postalCodeCA",function(n,t){return this.optional(t)||/^[ABCEGHJKLMNPRSTVXY]\d[ABCEGHJKLMNPRSTVWXYZ] *\d[ABCEGHJKLMNPRSTVWXYZ]\d$/i.test(n)},"Please specify a valid postal code"),n.validator.addMethod("postalcodeIT",function(n,t){return this.optional(t)||/^\d{5}$/.test(n)},"Please specify a valid postal code"),n.validator.addMethod("postalcodeNL",function(n,t){return this.optional(t)||/^[1-9][0-9]{3}\s?[a-zA-Z]{2}$/.test(n)},"Please specify a valid postal code"),n.validator.addMethod("postcodeUK",function(n,t){return this.optional(t)||/^((([A-PR-UWYZ][0-9])|([A-PR-UWYZ][0-9][0-9])|([A-PR-UWYZ][A-HK-Y][0-9])|([A-PR-UWYZ][A-HK-Y][0-9][0-9])|([A-PR-UWYZ][0-9][A-HJKSTUW])|([A-PR-UWYZ][A-HK-Y][0-9][ABEHMNPRVWXY]))\s?([0-9][ABD-HJLNP-UW-Z]{2})|(GIR)\s?(0AA))$/i.test(n)},"Please specify a valid UK postcode"),n.validator.addMethod("require_from_group",function(t,i,r){var u=n(r[1],i.form),f=u.eq(0),e=f.data("valid_req_grp")?f.data("valid_req_grp"):n.extend({},this),o=u.filter(function(){return e.elementValue(this)}).length>=r[0];return f.data("valid_req_grp",e),n(i).data("being_validated")||(u.data("being_validated",!0),u.each(function(){e.element(this)}),u.data("being_validated",!1)),o},n.validator.format("Please fill at least {0} of these fields.")),n.validator.addMethod("skip_or_fill_minimum",function(t,i,r){var u=n(r[1],i.form),f=u.eq(0),e=f.data("valid_skip")?f.data("valid_skip"):n.extend({},this),o=u.filter(function(){return e.elementValue(this)}).length,s=o===0||o>=r[0];return f.data("valid_skip",e),n(i).data("being_validated")||(u.data("being_validated",!0),u.each(function(){e.element(this)}),u.data("being_validated",!1)),s},n.validator.format("Please either skip these fields or fill at least {0} of them.")),n.validator.addMethod("stateUS",function(n,t,i){var u=typeof i=="undefined",o=u||typeof i.caseSensitive=="undefined"?!1:i.caseSensitive,f=u||typeof i.includeTerritories=="undefined"?!1:i.includeTerritories,e=u||typeof i.includeMilitary=="undefined"?!1:i.includeMilitary,r;return r=f||e?f&&e?"^(A[AEKLPRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$":f?"^(A[KLRSZ]|C[AOT]|D[CE]|FL|G[AU]|HI|I[ADLN]|K[SY]|LA|M[ADEINOPST]|N[CDEHJMVY]|O[HKR]|P[AR]|RI|S[CD]|T[NX]|UT|V[AIT]|W[AIVY])$":"^(A[AEKLPRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$":"^(A[KLRZ]|C[AOT]|D[CE]|FL|GA|HI|I[ADLN]|K[SY]|LA|M[ADEINOST]|N[CDEHJMVY]|O[HKR]|PA|RI|S[CD]|T[NX]|UT|V[AT]|W[AIVY])$",r=o?new RegExp(r):new RegExp(r,"i"),this.optional(t)||r.test(n)},"Please specify a valid state"),n.validator.addMethod("strippedminlength",function(t,i,r){return n(t).text().length>=r},n.validator.format("Please enter at least {0} characters")),n.validator.addMethod("time",function(n,t){return this.optional(t)||/^([01]\d|2[0-3]|[0-9])(:[0-5]\d){1,2}$/.test(n)},"Please enter a valid time, between 00:00 and 23:59"),n.validator.addMethod("time12h",function(n,t){return this.optional(t)||/^((0?[1-9]|1[012])(:[0-5]\d){1,2}(\ ?[AP]M))$/i.test(n)},"Please enter a valid time in 12-hour am/pm format"),n.validator.addMethod("url2",function(n,t){return this.optional(t)||/^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)*(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(n)},n.validator.messages.url),n.validator.addMethod("vinUS",function(n){if(n.length!==17)return!1;for(var e=["A","B","C","D","E","F","G","H","J","K","L","M","N","P","R","S","T","U","V","W","X","Y","Z"],h=[1,2,3,4,5,6,7,8,1,2,3,4,5,7,9,2,3,4,5,6,7,8,9],c=[8,7,6,5,4,3,2,10,0,9,8,7,6,5,4,3,2],s=0,r,t,o,u,f,i=0;i<17;i++){if(o=c[i],t=n.slice(i,i+1),i===8&&(f=t),isNaN(t)){for(r=0;r<e.length;r++)if(t.toUpperCase()===e[r]){t=h[r];t*=o;isNaN(f)&&r===8&&(f=e[r]);break}}else t*=o;s+=t}return(u=s%11,u===10&&(u="X"),u===f)?!0:!1},"The specified vehicle identification number (VIN) is invalid."),n.validator.addMethod("zipcodeUS",function(n,t){return this.optional(t)||/^\d{5}(-\d{4})?$/.test(n)},"The specified US ZIP Code is invalid"),n.validator.addMethod("ziprange",function(n,t){return this.optional(t)||/^90[2-5]\d\{2\}-\d{4}$/.test(n)},"Your ZIP-code must be in the range 902xx-xxxx to 905xx-xxxx"),n});