﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using cpu.nec;

namespace mame
{
    public partial class M92
    {
        public static byte irqvector;
        public static ushort sound_status;
        public static int bankaddress;
        public static Timer.emu_timer scanline_timer;
        public static byte m92_irq_vectorbase;
        public static int m92_raster_irq_position;
        public static int m92_scanline_param;
        public static int setvector_param;
        public static byte m92_sprite_buffer_busy;
        public static byte[] gfx1rom, gfx11rom, gfx2rom, gfx21rom,eeprom;
        public static byte[] gunforce_decryption_table=new byte[256] {
	        0xff,0x90,0x90,0x2c,0x90,0x90,0x43,0x88, 0x90,0x13,0x0a,0xbd,0xba,0x60,0xea,0x90, /* 00 */
	        0x90,0x90,0xf2,0x29,0xb3,0x22,0x90,0x0c, 0xa9,0x5f,0x9d,0x07,0x90,0x90,0x0b,0xbb, /* 10 */
	        0x8a,0x90,0x90,0x90,0x3a,0x3c,0x5a,0x38, 0x99,0x90,0xf8,0x89,0x90,0x91,0x90,0x55, /* 20 */
	        0xac,0x40,0x73,0x90,0x59,0x90,0xfc,0x90, 0x50,0xfa,0x90,0x25,0x90,0x34,0x47,0xb7, /* 30 */
	        0x90,0x90,0x90,0x49,0x90,0x0f,0x8b,0x05, 0xc3,0xa5,0xbf,0x83,0x86,0xc5,0x90,0x90, /* 40 */
	        0x28,0x77,0x24,0xb4,0x90,0x92,0x90,0x3b, 0x5e,0xb6,0x80,0x0d,0x2e,0xab,0xe7,0x90, /* 50 */
	        0x48,0x90,0xad,0xc0,0x90,0x1b,0xc6,0xa3, 0x04,0x90,0x90,0x90,0x16,0xb0,0x7d,0x98, /* 60 */
	        0x87,0x46,0x8c,0x90,0x90,0xfe,0x90,0xcf, 0x90,0x68,0x84,0x90,0xd2,0x90,0x18,0x51, /* 70 */
	        0x76,0xa4,0x36,0x52,0xfb,0x90,0xb9,0x90, 0x90,0xb1,0x1c,0x21,0xe6,0xb5,0x17,0x27, /* 80 */
	        0x3d,0x45,0xbe,0xae,0x90,0x4a,0x0e,0xe5, 0x90,0x58,0x1f,0x61,0xf3,0x02,0x90,0xe8, /* 90 */
	        0x90,0x90,0x90,0xf7,0x56,0x96,0x90,0xbc, 0x4f,0x90,0x90,0x79,0xd0,0x90,0x2a,0x12, /* A0 */
	        0x4e,0xb8,0x90,0x41,0x90,0x90,0xd3,0x90, 0x2d,0x33,0xf6,0x90,0x90,0x14,0x90,0x32, /* B0 */
	        0x5d,0xa8,0x53,0x26,0x2b,0x20,0x81,0x75, 0x7f,0x3e,0x90,0x90,0x00,0x93,0x90,0xb2, /* C0 */
	        0x57,0x90,0xa0,0x90,0x39,0x90,0x90,0x72, 0x90,0x01,0x42,0x74,0x9c,0x1e,0x90,0x5b, /* D0 */
	        0x90,0xf9,0x90,0x2f,0x85,0x90,0xeb,0xa2, 0x90,0xe2,0x11,0x90,0x4b,0x7e,0x90,0x78, /* E0 */
	        0x90,0x90,0x09,0xa1,0x03,0x90,0x23,0xc1, 0x8e,0xe9,0xd1,0x7c,0x90,0x90,0xc7,0x06, /* F0 */
        };
        public static byte[] bomberman_decryption_table = new byte[256] {
	        0x90,0x90,0x79,0x90,0x9d,0x48,0x90,0x90, 0x90,0x90,0x2e,0x90,0x90,0xa5,0x72,0x90, /* 00 */
	        0x46,0x5b,0xb1,0x3a,0xc3,0x90,0x35,0x90, 0x90,0x23,0x90,0x99,0x90,0x05,0x90,0x3c, /* 10 */
	        0x3b,0x76,0x11,0x90,0x90,0x4b,0x90,0x92, 0x90,0x32,0x5d,0x90,0xf7,0x5a,0x9c,0x90, /* 20 */
	        0x26,0x40,0x89,0x90,0x90,0x90,0x90,0x57, 0x90,0x90,0x90,0x90,0x90,0xba,0x53,0xbb, /* 30 */
	        0x42,0x59,0x2f,0x90,0x77,0x90,0x90,0x4f, 0xbf,0x4a,0xcb,0x86,0x62,0x7d,0x90,0xb8, /* 40 */
	        0x90,0x34,0x90,0x5f,0x90,0x7f,0xf8,0x80, 0xa0,0x84,0x12,0x52,0x90,0x90,0x90,0x47, /* 50 */
	        0x90,0x2b,0x88,0xf9,0x90,0xa3,0x83,0x90, 0x75,0x87,0x90,0xab,0xeb,0x90,0xfe,0x90, /* 60 */
	        0x90,0xaf,0xd0,0x2c,0xd1,0xe6,0x90,0x43, 0xa2,0xe7,0x85,0xe2,0x49,0x22,0x29,0x90, /* 70 */
	        0x7c,0x90,0x90,0x9a,0x90,0x90,0xb9,0x90, 0x14,0xcf,0x33,0x02,0x90,0x90,0x90,0x73, /* 80 */
	        0x90,0xc5,0x90,0x90,0x90,0xf3,0xf6,0x24, 0x90,0x56,0xd3,0x90,0x09,0x01,0x90,0x90, /* 90 */
	        0x03,0x2d,0x1b,0x90,0xf5,0xbe,0x90,0x90, 0xfb,0x8e,0x21,0x8d,0x0b,0x90,0x90,0xb2, /* A0 */
	        0xfc,0xfa,0xc6,0x90,0xe8,0xd2,0x90,0x08, 0x0a,0xa8,0x78,0xff,0x90,0xb5,0x90,0x90, /* B0 */
	        0xc7,0x06,0x18,0x90,0x90,0x1e,0x7e,0xb0, 0x0e,0x0f,0x90,0x90,0x0c,0xaa,0x55,0x90, /* C0 */
	        0x90,0x74,0x3d,0x90,0x90,0x38,0x27,0x50, 0x90,0xb6,0x5e,0x8b,0x07,0xe5,0x39,0xea, /* D0 */
	        0xbd,0x90,0x81,0xb7,0x90,0x8a,0x0d,0x90, 0x58,0xa1,0xa9,0x36,0x90,0xc4,0x90,0x8f, /* E0 */
	        0x8c,0x1f,0x51,0x04,0xf2,0x90,0xb3,0xb4, 0xe9,0x2a,0x90,0x90,0x90,0x25,0x90,0xbc, /* F0 */
        };
        public static byte[] lethalth_decryption_table=new byte[256]{
           0x7f,0x26,0x5d,0x90,0xba,0x90,0x1e,0x5e, 0xb8,0x90,0xbc,0xe8,0x01,0x90,0x4a,0x25, /* 00 */
           0x90,0xbd,0x90,0x22,0x10,0x90,0x02,0x57, 0x70,0x90,0x7e,0x90,0xe7,0x52,0x90,0xa9, /* 10 */
           0x90,0x90,0xc6,0x06,0xa0,0xfe,0xcf,0x8e, 0x43,0x8f,0x2d,0x90,0xd4,0x85,0x75,0xa2, /* 20 */
           0x3d,0x90,0x90,0x38,0x7c,0x89,0xd1,0x80, 0x3b,0x72,0x07,0x90,0x42,0x37,0x0a,0x18, /* 30 */
           0x88,0xb4,0x98,0x8b,0xb9,0x9c,0xad,0x0e, 0x2b,0x90,0xbf,0x90,0x55,0x90,0x56,0xb0, /* 40 */
           0x93,0x91,0x90,0xeb,0x90,0x50,0x41,0x29, 0x47,0x90,0x90,0x60,0x90,0xab,0x90,0x90, /* 50 */
           0xc3,0xe2,0xd0,0xb2,0x11,0x79,0x90,0x08, 0x90,0xfb,0x90,0x2c,0x23,0x90,0x28,0x0d, /* 60 */
           0x90,0x90,0x90,0x83,0x3c,0x90,0x1b,0x34, 0x5b,0x90,0x40,0x90,0x90,0x04,0xfc,0xcd, /* 70 */
           0xb1,0xf3,0x8a,0x90,0x90,0x87,0x90,0x90, 0x90,0x90,0x90,0x90,0xbe,0x84,0x1f,0xe6, /* 80 */
           0xff,0x90,0x12,0x90,0xb5,0x36,0x90,0xb3, 0x90,0x90,0x90,0xd2,0x4e,0x90,0x90,0x90, /* 90 */
           0xa5,0x90,0x90,0xc7,0x90,0x27,0x0b,0x90, 0x20,0x90,0x90,0x90,0x90,0x90,0x61,0x7d, /* A0 */
           0x90,0x90,0x86,0x0f,0x90,0xb7,0x90,0x4f, 0x90,0x90,0xc0,0xfd,0x90,0x39,0x90,0x77, /* B0 */
           0x05,0x3a,0x90,0x48,0x92,0x76,0x3e,0x03, 0x90,0xf8,0x90,0x59,0xa8,0x5f,0xf9,0xbb, /* C0 */
           0x81,0xfa,0x9d,0xe9,0x2e,0xa1,0xc1,0x33, 0x90,0x78,0x90,0x0c,0x90,0x24,0xaa,0xac, /* D0 */
           0x90,0xb6,0x90,0xea,0x90,0x73,0xe5,0x58, 0x00,0xf7,0x90,0x74,0x90,0x76,0x90,0xa3, /* E0 */
           0x90,0x5a,0xf6,0x32,0x46,0x2a,0x90,0x90, 0x53,0x4b,0x90,0x0d,0x51,0x68,0x99,0x13, /* F0 */
        };
        public static byte[] dynablaster_decryption_table=new byte[256]{
	        0x1f,0x51,0x84,0x90,0x3d,0x09,0x0d,0x90, 0x90,0x57,0x90,0x90,0x90,0x32,0x11,0x90, /* 00 */
	        0x90,0x9c,0x90,0x90,0x4b,0x90,0x90,0x03, 0x90,0x90,0x90,0x89,0xb0,0x90,0x90,0x90, /* 10 */
	        0x90,0xbb,0x18,0xbe,0x53,0x21,0x55,0x7c, 0x90,0x90,0x47,0x58,0xf6,0x90,0x90,0xb2, /* 20 */
	        0x06,0x90,0x2b,0x90,0x2f,0x0b,0xfc, 0x91 , 0x90,0x90,0xfa,0x81,0x83,0x40,0x38,0x90, /* 30 */
	        0x90,0x90,0x49,0x85,0xd1,0xf5,0x07,0xe2, 0x5e,0x1e,0x90,0x04,0x90,0x90,0x90,0xb1, /* 40 */
	        0xc7,0x90,0x96, 0xf2 /*0xaf*/, 0xb6,0xd2,0xc3,0x90, 0x87,0xba,0xcb,0x88,0x90,0xb9,0xd0,0xb5, /* 50 */
	        0x9a,0x80,0xa2,0x72,0x90,0xb4,0x90,0xaa, 0x26,0x7d,0x52,0x33,0x2e,0xbc,0x08,0x79, /* 60 */
	        0x48,0x90,0x76,0x36,0x02,0x90,0x5b,0x12, 0x8b,0xe7,0x90,0x90,0x90,0xab,0x90,0x4f, /* 70 */
	        0x90,0x90,0xa8,0xe5,0x39,0x0e,0xa9,0x90, 0x90,0x14,0x90,0xff, 0x7f/*0x75*/ ,0x90,0x90,0x27, /* 80 */
	        0x90,0x01,0x90,0x90,0xe6,0x8a,0xd3,0x90, 0x90,0x8e,0x56,0xa5,0x92,0x90,0x90,0xf9, /* 90 */
	        0x22,0x90,0x5f,0x90,0x90,0xa1,0x90,0x74, 0xb8,0x90,0x46,0x05,0xeb,0xcf,0xbf,0x5d, /* a0 */
	        0x24,0x90,0x9d,0x90,0x90,0x90,0x90,0x90, 0x59,0x8d,0x3c,0xf8,0xc5,0x90,0xf3,0x4e, /* b0 */
	        0x90,0x90,0x50,0xc6,0xe9,0xfe,0x0a,0x90, 0x99,0x86,0x90,0x90,0xaf ,0x8c/*0x8e*/,0x42,0xf7, /* c0 */
	        0x90,0x41,0x90,0xa3,0x90,0x3a,0x2a,0x43, 0x90,0xb3,0xe8,0x90,0xc4,0x35,0x78,0x25, /* d0 */
	        0x75,0x90,0xb7,0x90,0x23,0x90, 0x90/*0xe2*/,0x8f, 0x90,0x90,0x2c,0x90,0x77,0x7e,0x90,0x0f, /* e0 */
	        0x0c,0xa0,0xbd,0x90,0x90,0x2d,0x29,0xea, 0x90,0x3b,0x73,0x90,0xfb,0x20,0x90,0x5a /* f0 */
        };
        public static byte[] mysticri_decryption_table=new byte[256]{
	        0x90,0x57,0x90,0x90,0x90,0x90,0x90,0x90, 0xbf,0x43,0x90,0x90,0x90,0x90,0xfc,0x90, /* 00 */
	        0x90,0x90,0x90,0x90,0x90,0x52,0xa3,0x26, 0x90,0xc7,0x90,0x0f,0x90,0x0c,0x90,0x90, /* 10 */
	        0x90,0x90,0xff,0x90,0x90,0x02,0x90,0x90, 0x2e,0x90,0x5f,0x90,0x90,0x90,0x73,0x50, /* 20 */
	        0xb2,0x3a,0x90,0x90,0xbb,0x90,0x90,0x90, 0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90, /* 30 */
	        0x90,0x90,0x8e,0x3c,0x42,0x90,0x90,0xb9, 0x90,0x90,0x2a,0x90,0x47,0xa0,0x2b,0x03, /* 40 */
	        0xb5,0x1f,0x90,0xaa,0x90,0xfb,0x90,0x90, 0x90,0x90,0x90,0x90,0x38,0x90,0x90,0x90, /* 50 */
	        0x2c,0x90,0x90,0xc6,0x90,0x90,0xb1,0x90, 0x90,0x90,0x90,0x90,0x90,0x90,0xa2,0x90, /* 60 */
	        0xe9,0xe8,0x90,0x90,0x86,0x90,0x8b,0x90, 0x90,0x90,0x90,0x90,0x5b,0x72,0x90,0x90, /* 70 */
	        0x90,0x90,0x5d,0x0a,0x90,0x90,0x89,0x90, 0xb0,0x88,0x90,0x90,0x90,0x87,0x75,0xbd, /* 80 */
	        0x90,0x51,0x90,0x90,0x90,0x90,0x90,0x90, 0x90,0x90,0x90,0x5a,0x58,0x90,0x90,0x56, /* 90 */
	        0x90,0x8a,0x90,0x55,0x90,0x90,0x90,0xb4, 0x08,0x90,0xf6,0x90,0x90,0x9d,0x90,0xbc, /* A0 */
	        0x0b,0x90,0x90,0x5e,0x90,0x90,0x90,0x22, 0x36,0x90,0x1e,0x90,0xb6,0xba,0x23,0x90, /* B0 */
	        0x20,0x90,0x90,0x90,0x59,0x53,0x90,0x04, 0x81,0x90,0x90,0xf3,0x90,0x90,0x3b,0x06, /* C0 */
	        0x90,0x79,0x83,0x9c,0x90,0x18,0x80,0x90, 0xc3,0x90,0x90,0x90,0x32,0x90,0xcf,0x90, /* D0 */
	        0xeb,0x90,0x90,0x33,0x90,0xfa,0x90,0x90, 0xd2,0x90,0x24,0x90,0x74,0x41,0xb8,0x90, /* E0 */
	        0x90,0x90,0xd0,0x07,0x90,0x90,0x90,0x90, 0x90,0x46,0x90,0xea,0xfe,0x78,0x90,0x90, /* F0 */
        };
        public static byte[] majtitl2_decryption_table=new byte[256]{
	        0x87,0x90,0x78,0xaa,0x90,0x90,0x90,0x2c, 0x32,0x0a,0x0f,0x90,0x5e,0x90,0xc6,0x8a, /* 00 */
	        0x33,0x90,0x90,0x90,0x90,0xea,0x90,0x72, 0x90,0x90,0x90,0x90,0x90,0x90,0x24,0x55, /* 10 */
	        0x90,0x90,0x90,0x89,0xfb,0x90,0x59,0x02, 0x90,0x90,0x5d,0x90,0x90,0x90,0x36,0x90, /* 20 */
	        0x90,0x06,0x79,0x90,0x90,0x1e,0x07,0x90, 0x90,0x90,0x83,0x90,0x90,0x90,0x90,0x90, /* 30 */
	        0x9d,0x90,0x90,0x74,0x90,0x90,0x90,0x0c, 0x58,0x90,0x90,0x90,0x90,0x90,0x90,0x90, /* 40 */
	        0x3c,0x90,0x03,0x90,0x90,0xfa,0x43,0x90, 0xbf,0x90,0x90,0x75,0x90,0x88,0x90,0x80, /* 50 */
	        0x90,0xa3,0x90,0xfe,0x90,0x90,0x90,0x90, 0x90,0x90,0x90,0x90,0x3a,0x90,0x90,0x90, /* 60 */
	        0x2b,0x90,0x90,0x90,0x90,0xe9,0x5f,0x90, 0x46,0x90,0x41,0x90,0x18,0xb8,0x90,0x90, /* 70 */
	        0xb4,0x5a,0xb1,0x90,0x90,0x50,0xe8,0x20, 0x90,0xb2,0x90,0x90,0x90,0x90,0x90,0x51, /* 80 */
	        0x90,0x90,0x90,0x56,0x90,0x90,0x90,0x90, 0x90,0xcf,0x90,0x90,0x90,0xc3,0x90,0x90, /* 90 */
	        0x90,0x90,0x90,0x90,0x0b,0x90,0x90,0xb5, 0x57,0x90,0x90,0xc7,0x3b,0x90,0x90,0x90, /* A0 */
	        0x90,0x90,0x90,0x90,0xb6,0x90,0xeb,0x90, 0x38,0x90,0xa0,0x08,0x90,0x86,0xb0,0x90, /* B0 */
	        0x42,0x1f,0x73,0x90,0xf6,0x90,0x90,0x90, 0x53,0x90,0x52,0x90,0x04,0xbd,0x90,0x90, /* C0 */
	        0x26,0xff,0x2e,0x90,0x81,0x90,0x47,0x90, 0x90,0x90,0x90,0xd0,0x22,0x90,0x90,0xb9, /* D0 */
	        0x23,0x90,0xf3,0x90,0x90,0x90,0x90,0x90, 0x90,0xd2,0x8b,0xba,0x90,0x90,0x90,0x5b, /* E0 */
	        0x90,0x90,0x9c,0x90,0x90,0x90,0x90,0xfc, 0xbc,0xa2,0x2a,0x90,0x90,0x8e,0xbb,0x90, /* F0 */
        };
        public static byte[] hook_decryption_table=new byte[256] {
	        0xb6,0x20,0x22,0x90,0x0f,0x57,0x59,0xc6, 0xeb,0x90,0xb0,0xbb,0x3b,0x90,0x90,0x90, /* 00 */
	        0x36,0x90,0x90,0x90,0x90,0x90,0x90,0x90, 0x90,0xfe,0x90,0x90,0x90,0x90,0x90,0xa0, /* 10 */
	        0x2e,0x90,0x0b,0x90,0x90,0x58,0x90,0x90, 0x90,0x90,0x90,0x90,0x90,0x80,0x90,0x90, /* 20 */
	        0x33,0x90,0x90,0xbf,0x55,0x90,0x90,0x90, 0x53,0x90,0x90,0x90,0x90,0x90,0x90,0x90, /* 30 */
	        0x47,0x74,0x90,0xb1,0xb4,0x90,0x90,0x88, 0x90,0x90,0x38,0xcf,0x90,0x8e,0x90,0x90, /* 40 */
	        0x90,0xc7,0x90,0x32,0x90,0x52,0x3c,0x90, 0x90,0x90,0x90,0x90,0x90,0x90,0x83,0x72, /* 50 */
	        0x90,0x73,0x90,0x5a,0x90,0x43,0x90,0x90, 0x90,0x90,0x41,0xe9,0xbd,0x90,0xb2,0xd2, /* 60 */
	        0x90,0xaa,0xa2,0x90,0x90,0x90,0x90,0x90, 0x90,0x90,0x90,0x26,0x90,0x90,0x8a,0x90, /* 70 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x18, 0x90,0x9d,0x90,0x90,0x90,0x5d,0x90,0x46, /* 80 */
	        0x90,0x90,0x90,0xf6,0xc3,0xa3,0x1e,0x07, 0x5f,0x81,0x90,0x0c,0x90,0xb8,0x90,0x75, /* 90 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90, 0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x79, /* A0 */
	        0x90,0x5e,0x90,0x90,0x06,0x90,0xff,0x90, 0x5b,0x24,0x90,0x2b,0x90,0x90,0x90,0x02, /* B0 */
	        0x86,0x90,0x90,0xfb,0x90,0x90,0x50,0xfc, 0x08,0x90,0x90,0x90,0x03,0x90,0xb9,0x90, /* C0 */
	        0x90,0xbc,0xe8,0x1f,0xfa,0x42,0x90,0x90, 0x89,0x90,0x23,0x87,0x90,0x2a,0x90,0x90, /* D0 */
	        0x8b,0x90,0xf3,0xea,0x04,0x2c,0xb5,0x90, 0x0a,0x90,0x51,0x90,0x90,0x3a,0x90,0x9c, /* E0 */
	        0x90,0x90,0x78,0x90,0xba,0x90,0x90,0x90, 0x90,0x90,0x90,0x90,0xd0,0x56,0x90,0x90, /* F0 */
        };
        public static byte[] rtypeleo_decryption_table=new byte[256]{
	        0x5d,0x90,0xc6,0x90,0x90,0x90,0x2a,0x3a, 0x90,0x90,0x90,0x86,0x90,0x22,0x90,0xf3, /* 00 */
	        0x90,0x90,0x90,0x90,0x90,0x38,0x01,0x42, 0x04,0x90,0x90,0x1f,0x90,0x90,0x90,0x58, /* 10 */
	        0x57,0x2e,0x90,0x90,0x53,0x90,0xb9,0x90, 0x90,0x90,0x90,0x90,0x20,0x55,0x90,0x3d, /* 20 */
	        0xa0,0x90,0x90,0x0c,0x03,0x90,0x83,0x90, 0x90,0x90,0x8a,0x90,0x90,0xaa,0x90,0x90, /* 30 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90, 0x90,0x41,0x0a,0x26,0x8b,0x56,0x5e,0x90, /* 40 */
	        0x90,0x74,0x90,0x90,0x90,0x90,0x06,0x90, 0x90,0x89,0x5b,0xc7,0x43,0x90,0x90,0x90, /* 50 */
	        0x90,0xb6,0x90,0x3b,0x90,0x90,0x90,0x90, 0x90,0x36,0xea,0x80,0x90,0x90,0x90,0x5f, /* 60 */
	        0x90,0x0f,0x90,0x90,0x90,0x46,0x90,0x90, 0x3c,0x8e,0x90,0xa3,0x87,0x90,0x90,0x90, /* 70 */
	        0x2b,0xfb,0x47,0x0b,0x90,0xfc,0x02,0x90, 0x90,0x90,0x90,0x90,0x90,0x90,0x72,0x2c, /* 80 */
	        0x33,0x90,0x90,0x90,0x90,0x90,0x9d,0xbd, 0x90,0xb2,0x90,0x78,0x75,0xb8,0x90,0x90, /* 90 */
	        0x90,0x90,0x90,0x90,0xcf,0x5a,0x88,0x90, 0x90,0x90,0xc3,0x90,0xeb,0xfa,0x90,0x32, /* A0 */
	        0x90,0x90,0x90,0x52,0xb4,0x90,0x90,0x90, 0x90,0xbc,0x90,0x90,0x90,0xb1,0x59,0x50, /* B0 */
	        0x90,0x90,0xb5,0x90,0x08,0xa2,0xbf,0xbb, 0x1e,0x9c,0x90,0x73,0x90,0xd0,0x90,0x90, /* C0 */
	        0x90,0x90,0x90,0x90,0x81,0x90,0x79,0x90, 0x90,0x24,0x23,0x90,0x90,0xb0,0x07,0xff, /* D0 */
	        0x90,0xba,0xf6,0x51,0x90,0x90,0x90,0xfe, 0x90,0x90,0x90,0x90,0x90,0x90,0xe9,0x90, /* E0 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0xe8,0xd2, 0x90,0x18,0x90,0x90,0x90,0xd1,0x90,0x90, /* F0 */
        };
        public static byte[] inthunt_decryption_table=new byte[256]{
	        0x1f,0x90,0xbb,0x50,0x90,0x58,0x42,0x57, 0x90,0x90,0xe9,0x90,0x90,0x90,0x90,0x0b, /* 00 */
	        0x90,0x90,0x9d,0x9c,0x90,0x90,0x1e,0x90, 0x90,0xb4,0x5b,0x90,0x90,0x90,0x90,0x90, /* 10 */
	        0x90,0x90,0x78,0xc7,0x90,0x90,0x83,0x90, 0x90,0x0c,0xb0,0x04,0x90,0x90,0x90,0x90, /* 20 */
	        0x90,0x90,0x90,0x90,0x3b,0xc3,0xb5,0x47, 0x90,0x90,0x90,0x90,0x59,0x90,0x90,0x90, /* 30 */
	        0x90,0x90,0x90,0x38,0x90,0x90,0x90,0x90, 0x5f,0xa3,0xfa,0x90,0xe8,0x36,0x75,0x90, /* 40 */
	        0x88,0x33,0x90,0x90,0x90,0x90,0x43,0x90, 0x90,0x87,0x90,0x90,0x90,0x90,0x90,0x90, /* 50 */
	        0x90,0x90,0x90,0x90,0x8e,0xf3,0x56,0x90, 0x90,0x90,0x90,0x26,0xff,0x90,0x90,0x90, /* 60 */
	        0x90,0x90,0x90,0x2a,0x90,0x8a,0x90,0x18, 0x90,0x90,0x03,0x89,0x24,0x90,0x90,0x90, /* 70 */
	        0x0a,0x90,0xeb,0x90,0x86,0x90,0x90,0x90, 0x79,0x3a,0x90,0x90,0x90,0x90,0xa0,0x90, /* 80 */
	        0xea,0x90,0x90,0x90,0x90,0x90,0x2c,0x90, 0xc6,0x90,0x90,0x46,0x90,0xaa,0xb6,0x5e, /* 90 */
	        0x90,0x90,0x90,0x90,0x8b,0x90,0x90,0x90, 0x90,0x90,0xba,0x90,0xb9,0x53,0xa2,0x90, /* A0 */
	        0x90,0x07,0x90,0x90,0x90,0x3c,0x32,0x90, 0x2b,0x90,0xb8,0x90,0x90,0x90,0x90,0x90, /* B0 */
	        0xbd,0x90,0x90,0x90,0x90,0x81,0x90,0xd0, 0x08,0x90,0x55,0x06,0xcf,0x90,0x90,0xfc, /* C0 */
	        0x90,0x90,0x90,0xb1,0xbf,0x90,0x90,0x51, 0x52,0x90,0x5d,0x90,0x5a,0x90,0xb2,0x90, /* D0 */
	        0xfe,0x90,0x90,0x22,0x20,0x72,0xf6,0x80, 0x02,0x2e,0x90,0x74,0x0f,0x90,0x90,0x90, /* E0 */
	        0x90,0x90,0x90,0x90,0xbc,0x41,0x90,0xfb, 0x73,0x90,0x90,0x90,0x23,0xd2,0x90,0x90, /* F0 */
        };
        public static byte[] leagueman_decryption_table=new byte[256]{
	        0x90,0x90,0x90,0x55,0xbb,0x90,0x23,0x79, 0x90,0x90,0x90,0x90,0x90,0x90,0x38,0x90, /* 00 */
	        0x01,0x90,0x90,0x90,0x90,0x90,0x90,0x90, 0x3d,0x90,0x90,0x90,0xba,0x90,0x1e,0x90, /* 10 */
	        0x2c,0x46,0x90,0xb5,0x90,0x4b,0x90,0xfe, 0x90,0x90,0xfb,0x2e,0x90,0x90,0x36,0x04, /* 20 */
	        0xcf,0x90,0xf3,0x5a,0x8a,0x0c,0x9c,0x90, 0x90,0x90,0xb2,0x50,0x90,0x90,0x90,0x5f, /* 30 */
	        0x90,0x90,0x24,0x90,0x90,0x41,0x2b,0x90, 0xe9,0x90,0x08,0x3b,0x90,0x90,0x90,0x90, /* 40 */
	        0x90,0xd2,0x51,0x90,0x90,0x90,0x22,0x90, 0xeb,0x3a,0x5b,0xa2,0xb1,0x80,0x90,0x90, /* 50 */
	        0x90,0x90,0x90,0x90,0x59,0xb4,0x88,0x90, 0x90,0xbf,0xd1,0x90,0xb9,0x57,0x90,0x90, /* 60 */
	        0x72,0x90,0x73,0x90,0x90,0x90,0x90,0x0f, 0x90,0x90,0x90,0x90,0x56,0x90,0x90,0xc6, /* 70 */
	        0x90,0x90,0x90,0x90,0x90,0x2a,0x8e,0x90, 0x81,0xa3,0x58,0x90,0xaa,0x78,0x89,0x90, /* 80 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0xbd,0x90, 0x90,0x90,0xff,0x90,0x90,0x90,0x07,0x53, /* 90 */
	        0xa0,0x90,0x90,0x5e,0xb0,0x90,0x83,0xf6, 0x90,0x26,0x32,0x90,0x90,0x90,0x74,0x0a, /* A0 */
	        0x18,0x90,0x90,0x90,0x75,0x03,0x90,0x90, 0xb6,0x02,0x90,0x90,0x43,0x90,0xb8,0x90, /* B0 */
	        0xe8,0x90,0xfc,0x90,0x20,0xc3,0x90,0x06, 0x90,0x1f,0x86,0x00,0x90,0x90,0x90,0xd0, /* C0 */
	        0x47,0x90,0x87,0x90,0x90,0x9d,0x3c,0xc7, 0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90, /* D0 */
	        0x90,0x90,0x90,0x8b,0x90,0x90,0x33,0x90, 0x90,0x90,0x90,0x90,0xfa,0x42,0x90,0x90, /* E0 */
	        0x90,0x90,0x90,0xea,0x90,0x52,0x90,0x5d, 0x90,0x90,0x90,0x90,0xbc,0x90,0x90,0x90, /* F0 */
        };
        public static byte[] psoldier_decryption_table = new byte[256]{
	        0x90,0x90,0x90,0x8a,0x90,0xaa,0x90,0x90, 0x90,0x20,0x23,0x55,0x90,0xb5,0x0a,0x90, /* 00 */
	        0x90,0x46,0x90,0xb6,0x90,0x74,0x8b,0x90, 0x90,0xba,0x01,0x90,0x90,0x5a,0x86,0xfb, /* 10 */
	        0xb2,0x90,0xb0,0x90,0x42,0x06,0x1e,0x08, 0x22,0x9d,0x90,0x90,0x90,0x90,0x90,0x73, /* 20 */
	        0x90,0x90,0x5f,0x90,0x90,0xd0,0x90,0xff, 0x90,0x90,0xbd,0x90,0x03,0x90,0xb9,0x90, /* 30 */
	        0x90,0x90,0x90,0x51,0x5e,0x24,0x90,0x90, 0x90,0x90,0x90,0x58,0x59,0x90,0x90,0x90, /* 40 */
	        0x52,0x90,0x90,0x90,0xa0,0x90,0x90,0x02, 0xd2,0x90,0x79,0x26,0x3a,0x0f,0xcf,0xb4, /* 50 */
	        0xf3,0x90,0x90,0x50,0x90,0x75,0xb1,0x90, 0xd1,0x47,0x90,0x90,0x90,0x90,0x90,0x90, /* 60 */
	        0xc6,0x90,0x90,0x90,0x90,0x90,0xbc,0x90, 0x90,0x90,0x90,0x90,0x53,0x41,0x90,0x90, /* 70 */
	        0x90,0x90,0x90,0x90,0x90,0x90,0x04,0x90, 0x90,0x90,0x90,0x2c,0x90,0xbf,0x90,0x90, /* 80 */
	        0x90,0x90,0xe8,0x90,0x90,0x78,0x90,0xbb, 0x90,0x90,0x1f,0x2b,0x87,0x90,0x4b,0x56, /* 90 */
	        0x36,0x33,0x90,0x90,0x90,0x9c,0xc3,0x90, 0x90,0x81,0x90,0xe9,0x90,0xfa,0x90,0x90, /* A0 */
	        0x90,0x72,0x90,0xa2,0x90,0x90,0xc7,0x90, 0x90,0x92,0x90,0x90,0x88,0x90,0x90,0x90, /* B0 */
	        0x3b,0x90,0x0c,0x90,0x80,0x90,0x90,0x90, 0x90,0x2e,0x90,0x90,0x90,0x57,0x90,0x8e, /* C0 */
	        0x07,0x90,0xa3,0x90,0x90,0x90,0x3d,0x90, 0xfe,0x90,0x90,0xfc,0xea,0x90,0x38,0x90, /* D0 */
	        0x3c,0xf6,0x90,0x90,0x90,0x18,0x90,0x90, 0xb8,0x90,0x90,0x90,0x2a,0x5d,0x5b,0x90, /* E0 */
	        0x90,0x43,0x32,0x90,0x90,0x90,0xeb,0x90, 0x90,0x90,0x90,0x90,0x83,0x89,0x90,0x90, /* F0 */
        };
        public static void M92Init()
        {
            int i1, i2, n1, n2;
            byte[] bb1;
            Machine.bRom = true;
            Timer.setvector = setvector_callback;
            pf_master_control = new ushort[4];
            M92.pf_layer = new M92.pf_layer_info[3];
            for (i1 = 0; i1 < 3; i1++)
            {
                pf_layer[i1].control = new ushort[4];
            }
            Generic.paletteram16 = new ushort[0x800];
            Generic.spriteram16 = new ushort[0x400];
            Generic.buffered_spriteram16 = new ushort[0x400];
            m92_vram_data = new ushort[0x8000];
            m92_spritecontrol = new ushort[8];
            bb1 = Machine.GetRom("maincpu.rom");
            Memory.mainrom = new byte[0x190000];
            Array.Copy(bb1, Memory.mainrom, bb1.Length);
            Memory.audiorom = Machine.GetRom("soundcpu.rom");
            Iremga20.iremrom = Machine.GetRom("irem.rom");
            Memory.mainram = new byte[0x10000];
            Memory.audioram = new byte[0x4000];
            gfx1rom = Machine.GetRom("gfx1.rom");
            n1 = gfx1rom.Length;
            gfx11rom = new byte[n1 * 2];
            for (i1 = 0; i1 < n1; i1++)
            {
                gfx11rom[i1 * 2] = (byte)(gfx1rom[i1] >> 4);
                gfx11rom[i1 * 2 + 1] = (byte)(gfx1rom[i1] & 0x0f);
            }
            gfx2rom = Machine.GetRom("gfx2.rom");
            n2 = gfx2rom.Length;
            gfx21rom = new byte[n2 * 2];
            for (i2 = 0; i2 < n2; i2++)
            {
                gfx21rom[i2 * 2] = (byte)(gfx2rom[i2] >> 4);
                gfx21rom[i2 * 2 + 1] = (byte)(gfx2rom[i2] & 0x0f);
            }
            eeprom = Machine.GetRom("eeprom.rom");
            m92_game_kludge = 0;
            m92_irq_vectorbase = 0x80;
            m92_sprite_buffer_busy = 1;
            bankaddress = 0xa0000;
            sound_status = 0;
            dsw = 0xffbf;
            switch (Machine.sName)
            {
                case "lethalth":
                case "thndblst":
                    bankaddress = 0;
                    m92_irq_vectorbase = 0x20;
                    break;
                case "majtitl2":
                case "majtitl2a":
                case "majtitl2b":
                case "majtitl2j":
                case "skingame":
                case "skingame2":
                    m92_game_kludge = 2;
                    dsw = 0xfd9f;
                    break;
                case "rtypeleo":
                case "rtypeleoj":
                    m92_irq_vectorbase = 0x20;
                    break;
                case "nbbatman":
                case "lnbbatmanu":
                case "leaguemn":
                    dsw = 0xff9f;
                    break;
                case "ssoldier":
                case "psoldier":
                    dsw = 0xff9f;
                    sound_status = 0x80;
                    m92_irq_vectorbase = 0x20;
                    break;
            }
            if (Memory.mainrom == null || Memory.audiorom == null || gfx11rom == null || gfx21rom == null)
            {
                Machine.bRom = false;
            }
        }
        public static void machine_start_m92()
        {
            setvector_param = 0;
            setvector_callback();
            scanline_timer = Timer.timer_alloc_common(m92_scanline_interrupt, "m92_scanline_interrupt", false);
        }
        public static void machine_reset_m92()
        {
            m92_scanline_param = 0;
            Timer.timer_adjust_periodic(scanline_timer, Video.video_screen_get_time_until_pos(0, 0), Attotime.ATTOTIME_NEVER);
        }
        public static void m92_scanline_interrupt()
        {
            int scanline = m92_scanline_param;
            if (scanline == m92_raster_irq_position)
            {
                Video.video_screen_update_partial(scanline);
                Cpuexec.cpu[0].cpunum_set_input_line_and_vector(0, 0, LineState.HOLD_LINE, (m92_irq_vectorbase + 8) / 4);
            }
            else if (scanline == 0xf8)
            {
                Video.video_screen_update_partial(scanline);
                Cpuexec.cpu[0].cpunum_set_input_line_and_vector(0, 0, LineState.HOLD_LINE, (m92_irq_vectorbase + 0) / 4);
            }
            if (++scanline >= Video.screenstate.height)
            {
                scanline = 0;
            }
            m92_scanline_param = scanline;
            Timer.timer_adjust_periodic(scanline_timer, Video.video_screen_get_time_until_pos(scanline, 0), Attotime.ATTOTIME_NEVER);
        }
        public static byte m92_eeprom_r(int offset)
        {
            return eeprom[offset];
        }
        public static ushort m92_eeprom_r2(int offset)
        {
            return (ushort)(0xff00 | eeprom[offset]);
        }
        public static void m92_eeprom_w(int offset, byte data)
        {
            eeprom[offset] = data;
        }
        public static void m92_coincounter_w(byte data)
        {

        }
        public static void m92_bankswitch_w(byte data)
        {
            //if (ACCESSING_BITS_0_7)
            {
                bankaddress = 0x100000 + ((data & 0x7) * 0x10000);
                //set_m92_bank(machine);
            }
        }
        public static byte m92_sprite_busy_r()
        {
            return m92_sprite_buffer_busy;
        }
        public static void setvector_callback()
        {
            List<vec> lsvec = new List<vec>();
            foreach (vec v1 in Cpuint.lvec)
            {
                if (Attotime.attotime_compare(v1.time, Timer.global_basetime) < 0)
                {
                    lsvec.Add(v1);
                }
                else if (Attotime.attotime_compare(v1.time, Timer.global_basetime) == 0)
                {
                    setvector_param = v1.vector;
                    lsvec.Add(v1);
                    break;
                }
            }
            foreach (vec v1 in lsvec)
            {
                Cpuint.lvec.Remove(v1);
            }
            switch (setvector_param)
            {
                case 0:
                    irqvector = 0;
                    break;
                case 1:
                    irqvector |= 0x2;
                    break;
                case 2:
                    irqvector &= 0xfd;
                    break;
                case 3:
                    irqvector |= 0x1;
                    break;
                case 4:
                    irqvector &= 0xfe;
                    break;
            }
            if ((irqvector & 0x2) != 0)
            {
                Cpuint.interrupt_vector[1, 0] = 0x18;
            }
            else if ((irqvector & 0x1) != 0)
            {
                Cpuint.interrupt_vector[1, 0] = 0x19;
            }
            if (irqvector == 0)
            {
                Cpuint.cpunum_set_input_line(1, 0, LineState.CLEAR_LINE);
            }
            else
            {
                Cpuint.cpunum_set_input_line(1, 0, LineState.ASSERT_LINE);
            }
        }
        public static void m92_soundlatch_w(ushort data)
        {
            Cpuint.lvec.Add(new vec(3, Timer.get_current_time()));
            setvector_param = 3;            
            Timer.emu_timer timer = Timer.timer_alloc_common(setvector_callback, "setvector_callback", true);
            Timer.timer_adjust_periodic(timer, Attotime.ATTOTIME_ZERO, Attotime.ATTOTIME_NEVER);
            Sound.soundlatch_w((ushort)(data & 0xff));
        }
        public static ushort m92_sound_status_r()
        {
            return sound_status;
        }
        public static ushort m92_soundlatch_r()
        {
            return (ushort)(Sound.soundlatch_r() | 0xff00);
        }
        public static void m92_sound_irq_ack_w()
        {
            Cpuint.lvec.Add(new vec(4, Timer.get_current_time()));
            setvector_param = 4;
            Timer.emu_timer timer = Timer.timer_alloc_common(setvector_callback, "setvector_callback", true);
            Timer.timer_adjust_periodic(timer, Attotime.ATTOTIME_ZERO, Attotime.ATTOTIME_NEVER);
        }
        public static void m92_sound_status_w(ushort data)
        {
            sound_status = data;
            Cpuexec.cpu[0].cpunum_set_input_line_and_vector(0, 0, LineState.HOLD_LINE, (m92_irq_vectorbase + 12) / 4);
        }
        public static void sound_irq(int state)
        {
            if (state != 0)
            {
                Cpuint.lvec.Add(new vec(1, Timer.get_current_time()));
                setvector_param = 1;
                Timer.emu_timer timer = Timer.timer_alloc_common(setvector_callback, "setvector_callback", true);
                Timer.timer_adjust_periodic(timer, Attotime.ATTOTIME_ZERO, Attotime.ATTOTIME_NEVER);
            }
            else
            {
                Cpuint.lvec.Add(new vec(2, Timer.get_current_time()));
                setvector_param = 2;
                Timer.emu_timer timer = Timer.timer_alloc_common(setvector_callback, "setvector_callback", true);
                Timer.timer_adjust_periodic(timer, Attotime.ATTOTIME_ZERO, Attotime.ATTOTIME_NEVER);
            }
        }
        public static void m92_sprite_interrupt()
        {
            Cpuexec.cpu[0].cpunum_set_input_line_and_vector(0, 0, LineState.HOLD_LINE, (m92_irq_vectorbase + 4) / 4);
        }
    }
}
