using TestBasicSiteRazor;

namespace RoutesList.Integration.Razor
{
    public class WebApplicationTest
    {
        private readonly CustomWebApplication<Program> _application;
        public WebApplicationTest()
        {
            _application = new CustomWebApplication<Program>();
        }

        [Theory]
        [InlineData("/", "text/html; charset=utf-8")]
        [InlineData("/Privacy", "text/html; charset=utf-8")]
        [InlineData("/routes", "text/html")]
        [InlineData("/routes/json", "application/json; charset=utf-8")]
        public async Task ResponseTest(string url, string contentType)
        {
            using var client = _application.CreateClient();
            using var response = await client.GetAsync(url);

            response.EnsureSuccessStatusCode();
            Assert.Equal(
                contentType,
                response?.Content?.Headers?.ContentType?.ToString()
            );
        }
    }
}