﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Reflection;

namespace RoutesList.Build.Extensions
{
    public static class EnumExtension
    {
        public static Dictionary<int, string> ToDictionary(Enum myEnum)
        {
            var myEnumType = myEnum.GetType();

            var names = myEnumType.GetFields()
                .Where(m => m.GetCustomAttribute<DisplayAttribute>() != null)
                .Select(e => e.GetCustomAttribute<DisplayAttribute>().Name);

            var values = Enum.GetValues(myEnumType).Cast<int>();

            return names.Zip(values, (n, v) => new KeyValuePair<int, string>(v, n))
                .ToDictionary(kv => kv.Key, kv => kv.Value);
        }

        public static List<string> GetListOfDescription<T>() where T : struct
        {
            Type t = typeof(T);
            return !t.IsEnum ? null : Enum.GetValues(t).Cast<Enum>().Select(x => x.GetDescription()).ToList();
        }

        public static string GetDescription(this Enum value)
        {
            Type type = value.GetType();
            string name = Enum.GetName(type, value);

            if (name != null) {
                FieldInfo field = type.GetField(name);

                if (field != null) {
                    DescriptionAttribute attr = Attribute.GetCustomAttribute(field, typeof(DescriptionAttribute)) as DescriptionAttribute;

                    if (attr != null) {
                        return attr.Description;
                    }
                }
            }

            return null;
        }
    }
}
