A collection of my *favorite* stuff from across the web, loosly assorted into categories. If you find any broken links, please let me know!

*This page is way too l o n g, so click the links below to jump to jake's favorite [blank]:*

JUMP -> [Competitive Programming Resources]("#CompetitiveProgrammingResources")
JUMP -> [Software Engineering Resources]("#SoftwareEngineeringResources")
JUMP -> [Cybersecurity Tools]("#CybersecurityTools")
JUMP -> [Misc. Tech Stuff]("#Misc.TechStuff")
JUMP -> [News Sources & Link Aggregators]("#NewsSources&LinkAggregators")
JUMP -> [Wikis]("#Wikis")
JUMP -> [Mathematics Resources]("#MathematicsResources")
JUMP -> [Academia Resources]("#AcademiaResources")
JUMP -> [Blog Posts and Articles]("#BlogPostsandArticles")
JUMP -> [Personal Websites]("#PersonalWebsites")
JUMP -> [Misc.]("#Misc.")

### Competitive Programming Resources
- [Benjamin QI's USACO Repo](https://github.com/bqi343/USACO) - A cracked competitive programmer's repository containing his Q&A, solves, and resources
- [USACO.guide](https://usaco.guide/) - A collection of high-quality resources curated for the USA computing olympiad 
- [Clist.by](https://clist.by/) - A database of future and active programming competitions
- [USACO Training](https://train.usaco.org/) - Hundreds of hours of computational problem solving instruction and countless practice problems
- [Codeforces](https://codeforces.org) - A great website for practicing  
- [Leetcode](https://leetcode.com) - An *inferior* website for practicing. Use codeforces. Nerd.

### Software Engineering Resources 
- [The C Programming Language](https://www.amazon.com/Programming-Language-2nd-Brian-Kernighan/dp/0131103628) - A PDF of the greatest programming book of all time, imo
- [Unsplash](https://unsplash.com/images) - Free stock images
- [Pexels](https://www.pexels.com) - More free stock images
- [Learn-regex](https://github.com/ziishaned/learn-regex) - A great guide on regular expressions
- [Github Is My Resume](https://pydanny.blogspot.com/2011/08/github-is-my-resume.html) - An interesting article on resumes vs portfolios
- [Github Student Developer Pack](https://education.github.com/pack) - Free access to great developer tools if you're a student
- [How to improve at any programming language](https://www.cbui.dev/how-to-rapidly-improve-at-any-programming-language/) - A great read
- [Carbon](https://carbon.now.sh) - Create pretty images of your source code
- [Weather.com API](https://weather.com/swagger-docs/call-for-code) - A great weather API
- [Stanford large Network Dataset Collection](http://snap.stanford.edu/data/) - A massive amount of free data 
- [Wikidata](https://www.wikidata.org/wiki/Wikidata:Main_Page) - Free and open data platform from Wikipedia
- [Tech Jobs For Good](https://www.techjobsforgood.com/) - How to work in tech and not be evil
- [x0.at](https://x0.at/) - File pastebin
- [Termbin](https://termbin.com/) - Terminal-based file pastebin
- [hakyll](https://jaspervdj.be/hakyll/) - Using Haskell to build static websites
- [Rosetta Code](https://www.rosettacode.org/wiki/Rosetta_Code) - The Rosetta stone, but for code
- [PL notes](https://pl.barzilay.org/lec98.txt) - Northeastern's programming languages course notes 
- [Compiler Explorer](https://alive2.llvm.org/ce/) - Explore compiler behaviors
- [Headscale](https://headscale.net/stable/) - Self-host tailscale infrastructure 
- [Pyomo](https://www.pyomo.org/) - My favorite optimization software
- [Lambda Explorer](https://lambdaexplorer.com/) - Taught me lambda calculus

### Cybersecurity Tools
*Critical Reminder*: I am *not* responsible for what you do with this stuff.   

- [CTF101.org](https://ctf101.org) - Learn how to compete in CTFs
- [CTFtime](https://ctftime.org) - See upcoming CTFs
- [exploit.education](https://exploit.education/) - Learn binary exploitation
- [Sherlock Project](https://github.com/sherlock-project/sherlock) - Track down social media accounts
- [Reverse Engineering for Beginners](https://beginners.re/main.html) - Good book on assembly and reverse engineering. My go-to. 
- [Massscan](https://github.com/robertdavidgraham/masscan) - "TCP port scanner, spews SYN packets asynchronously, scanning entire Internet in under 5 minutes."
- [NSA@home](http://nsa.unaligned.org/index.php) - password cracker
- [testssl.sh](https://testssl.sh/) - /bin/bash based SSL/TLS tester
- [nmap](https://nmap.org/) - because duh. also read the [book](https://github.com/Rushimamtora/pentestingbooks/blob/master/Book%20-%20Nmap%20Cookbook%20The%20Fat-free%20Guide%20to%20Network%20Scanning-1.pdf)
- [OSINT Dojo](https://www.osintdojo.com/resources/)
- [Veil](https://github.com/Veil-Framework/Veil) - Tool for generating metasploit payloads that bypass common antiviruses
- [From 0x90 to 0x4c454554](https://pastebin.com/3Qtw6JQw)
- [privacy.sexy](https://privacy.sexy/) - Privacy is sexy
- [Reverse Shell Cheat Sheet](https://github.com/swisskyrepo/PayloadsAllTheThings/blob/master/Methodology%20and%20Resources/Reverse%20Shell%20Cheatsheet.md) - Reverse shell anything
- [linpeas](https://github.com/carlospolop/PEASS-ng/tree/master/linPEAS) - OP linux privilege escalation 
- [hydra](https://www.kali.org/tools/hydra/) - SSH brute force
- [nikto](https://github.com/sullo/nikto) - OP web server scanning
- [wfuzz](https://github.com/xmendez/wfuzz) - OP webapp fuzzing
- [winpeas](https://github.com/carlospolop/PEASS-ng/tree/master/winPEAS) - OP windows privilege escalation 
- [The Copenhagen Book](https://thecopenhagenbook.com/) - implement auth right!

### Misc. Tech Stuff
- [xkcd comics](https://xkcd.com) - Comics
- [A Cyberpunk Manifesto, by Christian A. Kirtchev](https://mogami.neocities.org/files/manifesto.html) (kinda edgy)
- [Geekhack.org](https://geekhack.org/index.php) - Mechanical Keyboard Community
- [Gopher Proxy](https://proxy.vulpes.one/) - Proxy for an old, minimal internet protocol that was eventually supplanted by the current web stack
- [arrl.org](http://www.arrl.org/ham-radio-licenses) - Ham Radio Licenses
- [https://prism-break.org/en/](https://prism-break.org/en/) - Alternatives to modern applications that emphasize privacy
- [portquiz](http://portquiz.net/) - See if your ports are open
- [Labgopher](https://labgopher.com/) - Tool for getting great deals on ebay
- [r/homelab's software wiki](https://www.reddit.com/r/homelab/wiki/software) - List of software for home servers
- [OpenVPN](https://openvpn.net/community-downloads/) - Best VPN
- [Lubed Holy Pandas](https://youtu.be/aeqnEJpPZVY) - No explanation necessary
- [WTFPL](http://www.wtfpl.net/) - The epicly named "Do What the Fuck You Want to Public License
- [The World's Most Advanced Video Editing Tutorial](https://www.youtube.com/watch?v=O6ERELse_QY) - The best video editing tutorial avaiable, done by the main editor for Linus Tech Tips
- [xkcd 195](https://xkcd.com/195/)
- [Preserving Laptop Stickers on Laptops](https://grh.am/2019/preserving-laptop-stickers-on-macbooks/)
- [Don't Hex The Water](https://www.youtube.com/watch?v=Fzhkwyoe5vI) - Digital privacy is important!
- [Online Spyware Watchdog](https://spyware.neocities.org/) 
- [Mullvad VPN](https://mullvad.net/en/) - The second best VPN
- [996](https://github.com/996icu/996.ICU) - *fuck the ccp*
- [12ft](https://12ft.io/) - "hop" any paywall
- [Pandoc](https://pandoc.org/) - Universal document converter 
- [Text Files](http://textfiles.com/) - Reading
- [notes.andymatuschak.org](https://notes.andymatuschak.org/About_these_notes) - Andy Matuschak's fantastic working notes
- [pgp.mit.edu](http://pgp.mit.edu/) - MIT's PGP key server
- [HTTP Cats](https://http.cat/) - HTTP Cats
- [The Invisible Internet Project](https://geti2p.net/en/)
- [Temp Mail](https://temp-mail.org/en/) - Temporary email addresses
- [Xyte.ch](https://www.xyte.ch/) - Sells modified Thinkpads
- [privacyguides.org](https://www.privacyguides.org/) - Privacy is important
- [secret.club](https://secret.club) - A group of people who break software
- [libreboot.org](https://libreboot.org/) - don't boot intel management engine on system startup 
- [orgroam.com](https://www.orgroam.com/) - An emacs-based organization system that I do not use
- [loopsnoop](http://www.lel.ed.ac.uk/~gpullum/loopsnoop.html) - A proof that the halting problem is undecidable
- [catb.org/hacker-emblem/](http://www.catb.org/hacker-emblem/)
- [plv.mpi-sws.org/rustbelt/](https://plv.mpi-sws.org/rustbelt/) - Formally verifying rust
- [syncthing.net](https://syncthing.net/) - A nice tool for syncing things between devices
- [The Internet Hosting Cooperative](https://hcoop.net/) - Shared hosting environment 
- [TOTP Token Generator](https://totp.danhersam.com/) - Two factor for the uninterested 
- [Verifpal Manual](https://verifpal.com/res/pdf/manual.pdf) - The best manual for any verification tool
- [Libreoffice](https://www.libreoffice.org/) - Genuinely good office suite alternative
- [SAT competition](http://satcompetition.org/)
- [LWN.net](https://lwn.net/) - Linux News
- [Linux Hardening Guide](https://madaidans-insecurities.github.io/guides/linux-hardening.html) - The *ultimate* linux hardening guide, and backbone of some of my [nuccdc](https://nuccdc.club/) scripts
- [Anti Software Software Club](https://antisoftware.club/)

### News Sources & Link Aggregators
- [Hacker News](https://news.ycombinator.com) - Kind of like reddit, but for tech bros  
- [Phoronix](https://phoronix.com/scan.php?page=home) - Mostly Linux News
- [Pluralistic](https://pluralistic.net/) - Daily links from [Cory Doctorow](https://en.wikipedia.org/wiki/Cory_Doctorow)
- [lobste.rs](https://lobste.rs/) - Similar to Hacker News, but for rust
- [tildes.net](https://tildes.net/) - Similar to Hacker News and Lobste.rs
- [news.t0.vc](https://news.t0.vc/) - Tech and science-oriented link aggregation across different sites
- [Lemmy](https://join-lemmy.org/) - Link aggregator for the fediverse
- [Krebs On Security](https://krebsonsecurity.com/) 
- [n-o-d-e.net](https://n-o-d-e.net) - Byte-sized tech news

### Wikis
- [Thinkwiki](http://www.thinkwiki.org/wiki/ThinkWiki) - Wiki for all things Thinkpads
- [Arch Linux Wiki](https://wiki.archlinux.org) - Anything and everything Arch Linux
- [r/linuxmasterrace Reddit Wiki]("https://www.reddit.com/r/linuxmasterrace/wiki/tips)
- [Kernel.org](https://www.kernel.org/doc/html/latest/) - Linux Documentation Project
- [The Linux Documentation Project](https://tldp.org/) - Huuge repo of linux info

### Mathematics Resources
- [A Manga Guide to Linear Algebra](https://web.math.ucsb.edu/~jerryluo8/teaching/Fall2018-4A/The%20Manga%20Guide%20to%20Linear%20Algebra.pdf) - A cute educational manga on linear algebra
- [Wolfram Alpha](https://www.wolframalpha.com/) - Because, of course
- [The Natural Number Game](https://www.ma.imperial.ac.uk/~buzzard/xena/natural_number_game/) - See the power of induction!
- [Erdos Number](https://en.wikipedia.org/wiki/Erd%C5%91s_number)
- [web.evanchen.cc/napkin.html](https://web.evanchen.cc/napkin.html) - The napkin
- [15-251 Great Ideas in Theoretical Computer Science](https://www.cs.cmu.edu/~15251/) - Peak CMU course in theoretical computer science
- [ncatlab](https://ncatlab.org/nlab/show/HomePage) - category theory godsend
- [1cat](https://1lab.dev/) - essentially, ncat but for agda
- [Homotopy Type Theory Book](https://homotopytypetheory.org/book/) - Canonical type theory resource
- [The Knot Atlas](http://katlas.org/wiki/Main_Page) - Knots database
- [Integer Encyclopedia Database](https://oeis.org/) - Pretty integer sequences
- [Is Mathematics Obsolete?](https://www.youtube.com/watch?v=lE48QtO4xBQ) - Lovely talk
- [Number Theory Foundation](https://numbertheoryfoundation.org/)
- [math.nist.gov](https://math.nist.gov/) - NIST's collection of mathematical algorithms and software. Also, see their [guide](https://gams.nist.gov/)

### Academia Resources 
- [CSRankings.org](http://csrankings.org/#/index?all&us) - A website I use to systematically discover interesting professors and PhD students. 
- [Sci-Hub](https://sci-hub.se/) - Because open access *is* king
- [Library Genesis](http://libgen.li/) - Free books galore 
- [Arxiv](https://arxiv.org/) - A free, highly used distribution service for research papers
- [Mendely](https://www.mendeley.com/) - An effective citation manager
- [Collaboration & Credit Principles](https://colah.github.io/posts/2019-05-Collaboration/) - Interesting article on trust between researchers 
- [The Academic Family Tree](https://academictree.org/) - A single, interdisciplinary academic genealogy
- [search.marginlia.nu](https://search.marginalia.nu/) - A search engine that prioritizes information-dense websites
- [Faculty Job Search Resources](https://www.seas.upenn.edu/~sweirich/resources.htm) 
- [HeVeA](http://hevea.inria.fr/) - LaTeX to HTML
- [6-045j](https://ocw.mit.edu/courses/6-045j-automata-computability-and-complexity-spring-2011) - MIT's automata theory course
- [Zotero](https://www.zotero.org/) - Genuinely, honest to god, the best paper manager

### Blog Posts and Articles
- [So you want to reform democracy](https://medium.com/civic-tech-thoughts-from-joshdata/so-you-want-to-reform-democracy-7f3b1ef10597)
- [The Danger of Journaling IS Introspection](https://www.bramadams.dev/projects/the-danger-of-journaling-is-introspection)
- [A Manifesto for Preserving Content on the Web](https://web.archive.org/web/20220625161623/https://jeffhuang.com/designed_to_last/)
- ["On Writing" by Terence Tao](https://terrytao.wordpress.com/advice-on-writing-papers/)
- [NSA, NIST, and post-quantum cryptography](http://blog.cr.yp.to/20220805-nsa.html)
- [Google says it mitigated a 2.54 Tbps DDoS attack in 2017](https://www.zdnet.com/article/google-says-it-mitigated-a-2-54-tbps-ddos-attack-in-2017-largest-known-to-date/) 
- [Computer Science Open Data: CS Faculty composition and hiring trends](https://jeffhuang.com/computer-science-open-data/#cs-faculty-composition-and-hiring-trends)
- [From Novice to Master, and back again](https://blog.djmnet.org/2013/01/14/from-novice-to-master-and-back-again/)
- [your data is not safe](https://nilfm.cc/your_data_is_not_safe.html)
- [hallucinating the cloud](https://everest-pipkin.com/#drawings/hallucinating.html)
- [What Did I Learn This Decade? 2010-2019](https://blog.ncase.me/2010-2019/)
- [The sum of all knowledge](https://christianheilmann.com/2022/08/29/the-sum-of-all-knowledge/)
- [CLOSURE](https://kev.town/blog_content/CLOSURE.pdf)
- [A History of Trnashumanist Thought](https://nickbostrom.com/papers/history.pdf)
- [How I'm able to take notes in mathematics lectures using LaTeX and Vim](https://castel.dev/post/lecture-notes-1/)
- [Intentionally Making Close Friends](https://www.neelnanda.io/blog/43-making-friends)
- [FFmpeg - The Ultimate Guide](https://img.ly/blog/ultimate-guide-to-ffmpeg/)
- [How I wrote a self-hosting C compiler in 40 days](https://www.sigbus.info/how-i-wrote-a-self-hosting-c-compiler-in-40-days)
- [The Decline of Usability](https://datagubbe.se/decusab/)
- [What's Inside the EU Green Pass QR Code?](https://gir.st/blog/greenpass.html)
- [Quantum Computing for the very curious](https://quantum.country/qcvc)
- [Postscript on the Societies of Control](https://theanarchistlibrary.org/library/gilles-deleuze-postscript-on-the-societies-of-control) *(edgy, ik)*
- [Overclocking my old Raspberry Pi 3 Model B](https://haydenjames.io/overclocking-my-old-raspberry-pi-3-model-b/)
- [Love](https://inessential.com/2015/06/30/love)
- [Notes on technology in the 2020s](https://elidourado.com/blog/notes-on-technology-2020s)
- [A Nod to Ned Ludd](https://thebaffler.com/salvos/a-nod-to-ned-ludd)
- [Alienation, Marvelous Persuits and the New Nomadic Sciences](https://theanarchistlibrary.org/library/anonymous-alienation-marvelous-pursuits-and-the-new-nomadic-sciences?curius=1628)
- [Wat](https://www.destroyallsoftware.com/talks/wat)
- [Getting a Computer Science PhD in the USA](https://parentheticallyspeaking.org/articles/us-cs-phd-faq/)
- [Teaching the Hidden Curriculum](https://www.bu.edu/teaching-writing/resources/teaching-the-hidden-curriculum/)
- [Why we stopped maing Einsteins](https://erikhoel.substack.com/p/why-we-stopped-making-einsteins)
- [The End of Trust](https://www.eff.org/document/end-trust-0)
- [Magic Ink](http://worrydream.com/MagicInk/)
- [How To Deflate An SUV Tyre](https://tyreextinguishers.com/how-to-deflate-an-suv-tyre)
- [How Sustainable is a Solar Powered Website?](https://solar.lowtechmagazine.com/2020/01/how-sustainable-is-a-solar-powered-website.html)
- [An extensive guide to optimizing a Linux laptop for battery life](https://amanusk.medium.com/an-extensive-guide-to-optimizing-a-linux-laptop-for-battery-life-and-performance-27a7d853856c)
- [The Dark Mountain Project's Manifesto](https://dark-mountain.net/about/manifesto/) - *edgy af*
- [Writing as Distilled Thought](https://old.azlen.me/blog/writing_as_distilled_thought/)
- [Your Computer Isn't Yours](https://sneak.berlin/20201112/your-computer-isnt-yours/)
- [Why Metadata Matters](https://ssd.eff.org/module/why-metadata-matters)
- [Cities and Ambition](http://www.paulgraham.com/cities.html) - An *absolute* favorite. Boston <3
- [My Dream Text Editor](https://badd10de.dev/notes/dream-text-editor.html)
- [I'm a fucking webmaster](https://justinjackson.ca/webmaster/)
- [How to get a busy person to respond to your email](https://byrslf.co/how-to-get-a-busy-person-to-respond-to-your-email-52e5d4d69671?gi=5cc3fb1bbbd9)
- [Life Is Short](http://paulgraham.com/vb.html)
- [I Hacked the Dutch Government, and all I got was this t-shirt!](https://jacobriggs.io/blog/posts/i-hacked-the-dutch-government-and-all-i-got-was-this-t-shirt-24.html)
- [Mechanical Watch](https://ciechanow.ski/mechanical-watch/)
- [Analyzing Rail Tickets](https://eta.st/2023/01/31/rail-tickets.html)
- [The Philisophical Implications of Complexity Theory](https://www.scottaaronson.com/papers/philos.pdf)
- [What is ChatGPT and why does it work?](https://writings.stephenwolfram.com/2023/02/what-is-chatgpt-doing-and-why-does-it-work/)
- [How to Kill Decentralized Networks](https://ploum.net/2023-06-23-how-to-kill-decentralised-networks.html)
- [Running a single-user Mastodon instance](https://blog.thms.uk/2023/01/setting-up-mastodon)
- [The Collatz Conjecture & Non-Archimedean Spectral Theory](https://siegelmaxwellc.wordpress.com/2022/08/09/the-collatz-conjecture-non-archimedean-spectral-theory-part-i-the-numen-of-a-hydra-map/)
- [The Silent Revolution of SAT](https://cacm.acm.org/magazines/2023/6/273222-the-silent-revolution-of-sat/fulltext)
- [E-Ink is so Retropunk](https://rmkit.dev/eink-is-so-retropunk/)
- [A Linux Evening](https://fabiensanglard.net/a_linux_evening/index.html)
- [Search Query](https://www.henrikkarlsson.xyz/p/search-query)
- [20-person house](https://web.archive.org/web/20210226101821/https://jasonbenn.com/tag/community)
- [Research As Understanding](https://kanjun.me/writing/research-as-understanding)
- [Pound for Pound, Taiwan Is the Most Important Place in the World](https://archive.is/qkK8M#selection-417.0-417.64)
- [Why I attack](https://nicholas.carlini.com/writing/2024/why-i-attack.html)
- [The Moral Character of Cryptographic Work](https://web.cs.ucdavis.edu/~rogaway/papers/moral-fn.pdf) - Just an incredible piece

### Personal Websites
- [Terence Tao's Blog](https://terrytao.wordpress.com/) - The blog of a fantastic mathematician
- [bramadams.dev](https://www.bramadams.dev)
- [jeffhuang.com/](https://jeffhuang.com/) - Prof at Brown researching HCI
- [henryneeds.coffee](https://henryneeds.coffee/blog/)
- [blog.cr.yp.to](http://blog.cr.yp.to/) - Guy who sued the US govt over crypto
- [azdavis.net](https://azdavis.net/) - A Fella
- [sookocheff.com](https://sookocheff.com/) - A distributed systems engineer
- [zhangmingming.org](https://www.zhangmingming.org/) - A security researcher at Tsinghau university with similar research interests to mine
- [void.cc/](https://void.cc/) 
- [nilfm.cc](https://nilfm.cc) - Digital minimalist 
- [everest-pipkin](https://everest-pipkin.com/#) - Great art
- [blog.ncase.me](https://blog.ncase.me/) - Game dev
- [matt.might.net](https://matt.might.net/) - Incredible prof
- [msx.gay](https://msx.gay/) - Radio person
- [kae.si](https://kae.si/)
- [icyphox.sh](https://icyphox.sh/)
- [danielkirs.ch](http://danielkirs.ch/)
- [samuelgruetter.net/](https://samuelgruetter.net/) - Compiler guy
- [jmilne.org](https://www.jmilne.org/)
- [dontvacuum.me](https://dontvacuum.me/) - IoT security goat
- [cyber.dabamos.de](http://cyber.dabamos.de/blog/)
- [faultlore.com](https://faultlore.com/blah/) - Author of "you can't spell trust without rust"
- [h313.info](https://h313.info/)
- [bernsteinbear.com](https://bernsteinbear.com/)
- [scottaaronson.blog](https://scottaaronson.blog/) - A guy who loves quantum computers
- [www.gwern.net](https://www.gwern.net/) - many edges
- [people.cispa.io](https://people.cispa.io/ben.stock/)
- [eli.thegreenplace.net](https://eli.thegreenplace.net/)
- [castel.dev](https://castel.dev/)
- [neelnanda.io](https://www.neelnanda.io/)
- [The Creative Independent](https://thecreativeindependent.com/)
- [mattcolewilson.com](https://mattcolewilson.com/)
- [louismeunier.net](https://louismeunier.net/)
- [henryheffernan.com](https://henryheffernan.com/) - ThreeJS<3
- [mogami.neocities.org](https://mogami.neocities.org/)
- [amieko.space](https://amieko.space/) - Great photographer
- [yin.neocities.org](https://yin.neocities.org/) 
- [sigbus.info](https://www.sigbus.info/) 
- [coelacanth-dream.com](https://www.coelacanth-dream.com/)
- [analogdreams.blog](https://analogdreams.blog/)
- [demin.ws](https://demin.ws/) 
- [maya.land](https://maya.land/) 
- [suragu.net](https://suragu.net/about.html) 
- [wowana.me](https://wowana.me/) - a guy big into fediverse
- [datagubbe](https://datagubbe.se/) - Monke
- [gir.st](https://gir.st/blog/) 
- [blog.bemoe.online](https://blog.bemoe.online/)
- [zlkj.in](https://zlkj.in/)
- [surenaga.neocities.org](https://surenaga.neocities.org/)
- [drkhsh.at](https://drkhsh.at/) - Gopher user
- [neugierig.org](https://neugierig.org/)
- [raymii.org](https://raymii.org/s/blog/)
- [m455.casa](https://m455.casa/)
- [swindlesmccoop.xyz](https://swindlesmccoop.xyz/blog/) - Serial Experiments Linux
- [casual.agency](https://causal.agency/)
- [ELI DOURADO](https://elidourado.com/) - A great writer
- [blog.cjeller.site](https://blog.cjeller.site/) - Classical Guitar by Training, Cloud Engineer by Accident
- [cass.si](https://cass.si/)
- [sneak.berlin](https://sneak.berlin/)
- [moxie.org](https://moxie.org/) - Hope to meet him
- [stephenfay.xyz](https://stephenfay.xyz/) - Good writing
- [www.lukeheine.com](https://www.lukeheine.com/)
- [www.boringcactus.com](https://www.boringcactus.com/) - An immortal programming person who works for the MBTA
- [mm4rk3t.neocities.org](https://mm4rk3t.neocities.org/home) - Space
- [badd10de.dev](https://badd10de.dev)
- [100r.co](http://100r.co/site/home.html) - Offgrid living
- [mrshll.com](https://mrshll.com/)
- [electro.pizza](https://electro.pizza/)
- [ad044.neocities.org](https://ad044.neocities.org/) - Another lain-er
- [evasive.tech](https://evasive.tech/) - Art
- [davidovski.xyz](https://davidovski.xyz/) - Vibes
- [Danish Prakash](https://danishpraka.sh/) - A dev from India
- [Lisa Lee](https://leelisa.com/) - PhD in ML at CMU who likes pokemon
- [Maruan Al-Shedivat](https://www.cs.cmu.edu/~mshediva/) - The founding editor of CMU's machine learning blog
- [Ariel Procaccia](http://procaccia.info/teaching/) - CMU and Harvard prof into the relationship between algorithms and society. He's taught some interesting courses, including "Optimized Democracy" (Harvard CS238) and "Truth, Justice, and Algorithms" (CMU I5896)
- [Daniel Roy Greenfeld](https://daniel.feldroy.com/) - ex-Nasa employee 
- [Shriram Krishnamurthi](https://cs.brown.edu/~sk/) - CS Prof at Brown into programming languages and formal methods
- [Qntm](https://qntm.org/) - Qntm
- [blog.soykaf.com](https://blog.soykaf.com/) - Lain person
- [Neg Serg](https://github.com/neg-serg) 
- [Daniel Howe](https://rednoise.org/daniel/pubs.html) - Prof at HKU focusing on privacy, surveillance, and disinformation
- [Jordan Ellenberg](https://www.jordanellenberg.com/writings/) - Great mathematician and speaker
- [999eagle.moe/](https://999eagle.moe/)
- [eta.st](https://eta.st)
- [sqrtminusone.xyz](https://sqrtminusone.xyz/posts) - emacs freak. I prefer (n)vim, but I respect it
- [bryndr.sn](https://bryndr.sn)
- [calnewport.com](https://calnewport.com/) - Great author
- [justchokingaround](https://github.com/justchokingaround) - My favorite choker
- [Marc Lange](https://philosophy.unc.edu/people/marc-lange/) - A philosophy prof at Purdue with a hilarious webpage
- [Ice1000](https://ice1000.org/) - Type theory 
- [Travis Ormandly](https://lock.cmpxchg8b.com/) 
- [Germacheck](https://merlinfo.github.io/) - Minimal website, lovely person
- [Jordan Ellenberg](https://people.math.wisc.edu/~ellenberg/) - A mathematician and writer
- [Justine Tunney](https://justine.lol/)
- [Erik Demaine](https://erikdemaine.org/) - MIT Professor, computational origami
- [Xie Yuheng](https://xieyuheng.com/) - Interaction net guy
- [Mazza](https://lipn.univ-paris13.fr/~mazza/) - Interaction net goat
- [amelia.how](https://amelia.how/) 
- [Julien Voisin](https://dustri.org/) - A cool reverser, great writer
- [Alexander Bulekov](https://physics.bu.edu/~alxndr/) - fuzzer
- [j3s.sh](https://j3s.sh/)
- [mcyoung](https://mcyoung.xyz) - compiler/math dude
- [nick-black.com](https://nick-black.com) - Personal website turned cool mediawiki
- [thel3tterm](https://thel3tterm.com/) - nice art
- [Evan Chen](https://web.evanchen.cc/) 
- [Jeremy Avigad](https://www.andrew.cmu.edu/user/avigad/) - Logic prof at CMU. A guy behind Lean's mathlib
- [Colin James](https://compiler.club/) - compiler.club
- [nayuki.io/](https://www.nayuki.io/) - the goat
- [pwn.cat](https://pwn.cat/) - their thesis is okay
- [maxammann.org](https://maxammann.org/) - fuzzer
- [David Adrian](https://dadrian.io/) - Security Cryptography Whatever

### Misc.
- [Pool Suite](https://poolsuite.net/) - R e t r o Internet Radio Station 
- [Swapfest: The Flea at MIT](https://w1mx.mit.edu/flea-at-mit/) - Flea market at MIT
- [Vessi Everyday Classic](https://vessi.com/products/mens-everyday-classic-mist-grey) - Nice shoes
- [Eat Well Guide](https://www.eatwellguide.org/) - Search by location for hand-picked restaurants, farms, markets and other sources of local, sustainable food
- [zettelkasten.de](https://zettelkasten.de/posts/overview/) - Organization method
- [getting-rich-from-zero-to-hero-in-one-blog-post](https://www.mrmoneymustache.com/2013/02/22/getting-rich-from-zero-to-hero-in-one-blog-post)
- [polyphasic.net](https://www.polyphasic.net/) - Sleep 2 hours a day
- [Calm Tech](https://calmtech.com/) - Design your websites nicely
- [Annas Archive](https://annas-archive.org/) - Read anything
- [listen.moe](https://listen.moe/) - Weeb radio
- [slowroads](https://slowroads.io/) - d r i v e 
- [Good Guy Godel](https://ihavenoteeth.com/2014/10/23/good-guy-godel/)
- [Wikivoyage](https://en.wikivoyage.org/wiki/Main_Page) - Find travel info about any place
