Kubernetes: Container orchestration. Uses the primary/replica model.

# Links
- [Wikipedia](https://en.wikipedia.org/wiki/Kubernetes)

# Commands
- `kubectl get nodes` -> list all cluster nodes
- `kubectl describe nodes` -> gives detailed node info
- `kubectl get namespaces` -> describes all namespaces in the cluster
- `kubectl get pods --all-namespaces` -> get pods in namespaces
- `kubectl get pods -n [namespace]` -> get shit in the given namespace
- `kubectl get deployments --all-namespaces` -> list all deployments lol
- `kubectl get statefulset --all-namespaces` -> lists all statefulsets
- `kubectl top pods --all-namespaces` -> gets the top pods lol. also, can work with `nodes` too
- `kubectl get events --all-namespaces` -> gets all events
- `kubectl get services` -> get all services
- `kubectl describe service <service-name>` -> describe a service lol
- `kubectl get secrets --all-namespaces` -> list all secrets, used for storing sensitive data like passwords and keys etc
- `kubektl delete pods -l app=[app] -n [namespace]` -> delete pods lol
- `kubectl exec -it [pod name] -n [namespace] -- /bin/sh` -> exec a shell in the docker container of the pod
- `kubectl logs -n [namespace] [pod-name]` -> get logs and stuff
- `kubectl get secret [secret] -o yaml` -> get some secret, output it to yaml. you will have to decode the password and shit.
- `kubectl get services -w` -> watch the services
- `kubectl delete service [service]` -> deletes a service
- `kubectl delete -f [file]` -> delete a configuration file

# Concepts
- Control Plane: master node, which manages workload across the whole system
    - API server: serves the kubernetes API
    - scheduler
- Nodes: a machine where containers/workloads are deployed
    - contains kubelet, nameserver, etc
- Pod: multiple pods in a node.
    - ReplicaSet: a replica of the current applications
    - StatefulSets: controller that enforce uniqueness etc among pods

# Nextcloud
- [medium.com/@laurent.roffe_24715/first-nextcloud-deployment-in-k8s-manual-full-steps-eca2566751e7](https://medium.com/@laurent.roffe_24715/first-nextcloud-deployment-in-k8s-manual-full-steps-eca2566751e7)
- falco: [xmlisse.wordpress.com/2023/04/27/falco/](https://xmlisse.wordpress.com/2023/04/27/falco/)
    - note with falco, we need to install the falco kernel module on all our things. reference this: [falco.org/docs/getting-started/falco-kubernetes-quickstart/](https://falco.org/docs/getting-started/falco-kubernetes-quickstart/)
