FORMAL METHODS. I like to think of it as using mathematical rigor for reasoning about systems. Because mathematical reasoning and systems are such broad concepts, formal methods is an extremely broad field.

Formal methods is tied closely to:
- Logic 
- Formal languages 
- Automata Theory 
- Control Theory
- Type Theory 
- Theorem Proving 
- Verification 

Formal methods, in general, involves the specification, development, analysis, and verification of systems.

# People
- [Dustin Jamner](https://jamner.net/)
- [Georgio Nicolas](https://georgio.xyz/)
- [Nadim Kobeissi](https://nadim.computer/)
- [Bernd Finkbeiner](https://cispa.de/en/people/finkbeiner) 
- [Christoph Haase](https://www.cs.ox.ac.uk/people/christoph.haase/)
- [Max von Hippel](https://mxvh.pl)
- [Talia Ringer](https://dependenttyp.es/)
- [Shriram Krishnamurthi](https://parentheticallyspeaking.org/about/), [work site](https://cs.brown.edu/~sk/)
- [ice1000](https://github.com/ice1000), [personal site](https://ice1000.org/)
- [Julia Belyakova](https://julbinb.github.io/)
- [Armando Solar-Lezama](https://people.csail.mit.edu/asolar/)
- [Adam Chlipala](http://adam.chlipala.net/)

# Tools
- [Verifpal](https://verifpal.com/)
- [Linear Temporal Logic](https://en.wikipedia.org/wiki/Linear_temporal_logic)
- [compcert](https://compcert.org/)
- [Haskell](https://www.haskell.org/)
- [CakeML](https://cakeml.org/)

## Model Checkers
- [Spin](https://spinroot.com/spin/whatispin.html)
- [TLA+](https://en.wikipedia.org/wiki/TLA%2B)
- [NuSMV](https://nusmv.fbk.eu/)

## Theorem Provers/Proof Assistants
- [Coq](https://coq.inria.fr/)
    - [Ltac](https://github.com/ice1000)
- [Lean Theorem Prover](https://leanprover.github.io/)
- [ACL2](https://www.cs.utexas.edu/users/moore/acl2/)
    - [ACL2s](http://acl2s.ccs.neu.edu/acl2s/doc/)
- [Isabelle](https://isabelle.in.tum.de/overview.html)
- [Agda](https://github.com/agda/agda)
- [SASyLF](https://www.cs.cmu.edu/~aldrich/SASyLF/)

# Links
- [https://symbolic.software/](https://symbolic.software/)
- [Formal Security Analysis of the Signal Messaging Protocol](https://eprint.iacr.org/2016/1013.pdf)
- [From Program Verification to Synthesis](https://cms.cispa.saarland/pvs_22/)
- [Proof Assistant Stack Exchange](https://proofassistants.stackexchange.com/)
- [MIT 6.512](https://frap.csail.mit.edu/main)
- [The Science of Deep Specificaiton](https://deepspec.org/main)
- [en.wikipedia.org/wiki/Formal_verification](https://en.wikipedia.org/wiki/Formal_verification)
- [The Invariant Game](http://invgame.atwalter.com/dashboard1)
- [Software Foundations](https://softwarefoundations.cis.upenn.edu/)
- [NEU Programming Research Laboratory](https://prl.khoury.northeastern.edu/)
- [Solving Hexiom with SAT](https://github.com/hugomg/hexiom)
- [IC3ref](https://github.com/arbrad/IC3ref)
- "A gently curated list of companies using verification formal methods in industry" - [github.com/ligurio/practical-fm](https://github.com/ligurio/practical-fm)

# Papers
(see local library)

- Using state machines to guide LLMs: [arxiv.org/pdf/2307.09702v3.pdf](https://arxiv.org/pdf/2307.09702v3.pdf)
- Interaction Trees: [arxiv.org/pdf/1906.00046.pdf](https://arxiv.org/pdf/1906.00046.pdf)
- Hardware Model Checking Competition: [link](https://content.iospress.com/download/journal-on-satisfiability-boolean-modeling-and-computation/sat190106?id=journal-on-satisfiability-boolean-modeling-and-computation%2Fsat190106)
- Reducing state machines to sat: [people.eecs.berkeley.edu/~alanmi/publications/other/tcad15_pdr.pdf](https://people.eecs.berkeley.edu/~alanmi/publications/other/tcad15_pdr.pdf)
- Understanding IC3 (a SAT-based model checking algorithm): [theory.stanford.edu/~arbrad/papers/Understanding_IC3.pdf](https://theory.stanford.edu/~arbrad/papers/Understanding_IC3.pdf)

# Concepts
- Markov Decision Processes: a *model* for decision making using states and probabilities. transitions are probabilities.
