The Fediverse is a decentralized, federated social media network with ~5 million users and ~10 thousand instances.

### Protocol 
Similarly to how email servers use the "email protocol" (SMTP) to share information across services, Fediverse instances use the [ActivityPub protocol](https://activitypub.rocks/) to share information.

  
Due to the unifying ActivityPub protocol, the Fediverse is a network of independently hosted services interconnected through the protocol alone. Thousands of instances of the popular [services](https://fediverse.party/en/miscellaneous) are hosted by everyday people

### Appeal 
Fediverse's appeal lies in its decentralized nature, massive potential for customization, personal modification, and [open source software](https://www.gnu.org/philosophy/free-sw.html). In the age of data warehouses, walled gardens, shadowbanning, and targetted ads, Fediverse certainly has its appeal.

### Further Reading
• [Mastodon quick start guide](https://blog.joinmastodon.org/2018/08/mastodon-quick-start-guide/)  
• [What is Pleroma?](https://blog.soykaf.com/post/what-is-pleroma)  
• [Why Mastodon and the Fediverse are “doomed to fail”](https://write.as/eloquence/why-mastodon-and-the-fediverse-are-doomed-to-fail)
• [The Unrealized Potential of Federation](https://drewdevault.com/2020/09/20/The-potential-of-federation.html)  
• [A quick guide to the Free Network](https://medium.com/we-distribute/a-quick-guide-to-the-free-network-c069309f334)  
• [Awesome Fediverse Github Repo](https://github.com/emilebosch/awesome-fediverse)  
• [Awesome ActivityPub Github Repo](https://github.com/BasixKOR/awesome-activitypub)  

### References
[1] Fediverse, [en.Wikipedia.org](https://en.wikipedia.org/wiki/Fediverse)  
[2] ActivityPub, [activitypub.rocks](https://activitypub.rocks/)  
[3] Simple Mail Transfer Protocol, [datatracker.ietf.org](https://datatracker.ietf.org/doc/html/rfc5321)