import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

class LunaTextStyle {
  static TextStyle bodySmall() {
    return GoogleFonts.robotoFlex(
      height: 1.33, // md.sys.typescale.body-small.line-height
      fontSize: 12.0, // md.sys.typescale.body-small.size
      fontWeight: FontWeight.w400, // md.sys.typescale.body-small.weight
    );
  }

  static TextStyle bodyMedium() {
    return GoogleFonts.robotoFlex(
      height: 1.43, // md.sys.typescale.body-medium.line-height
      fontSize: 14.0, // md.sys.typescale.body-medium.size
      fontWeight: FontWeight.w400, // md.sys.typescale.body-medium.weight
    );
  }

  static TextStyle bodyLarge() {
    return GoogleFonts.robotoFlex(
      height: 1.50, // md.sys.typescale.body-large.line-height
      fontSize: 16.0, // md.sys.typescale.body-large.size
      fontWeight: FontWeight.w400, // md.sys.typescale.body-large.weight
    );
  }

  static TextStyle displaySmall() {
    return GoogleFonts.robotoFlex(
      height: 1.22, // md.sys.typescale.display-small.line-height
      fontSize: 36.0, // md.sys.typescale.display-small.size
      fontWeight: FontWeight.w400, // md.sys.typescale.display-small.weight
    );
  }

  static TextStyle displayMedium() {
    return GoogleFonts.robotoFlex(
      height: 1.56, // md.sys.typescale.display-medium.line-height
      fontSize: 45.0, // md.sys.typescale.display-medium.size
      fontWeight: FontWeight.w400, // md.sys.typescale.display-medium.weight
    );
  }

  static TextStyle displayLarge() {
    return GoogleFonts.robotoFlex(
      height: 1.23, // md.sys.typescale.display-large.line-height
      fontSize: 57.0, // md.sys.typescale.display-large.size
      fontWeight: FontWeight.w400, // md.sys.typescale.display-large.weight
    );
  }

  static TextStyle headlineSmall() {
    return GoogleFonts.robotoFlex(
      height: 1.25, // md.sys.typescale.headline-small.line-height
      fontSize: 32.0, // md.sys.typescale.headline-small.size
      fontWeight: FontWeight.w400, // md.sys.typescale.headline-small.weight
    );
  }

  static TextStyle headlineMedium() {
    return GoogleFonts.robotoFlex(
      height: 1.29, // md.sys.typescale.headline-medium.line-height
      fontSize: 28.0, // md.sys.typescale.headline-medium.size
      fontWeight: FontWeight.w400, // md.sys.typescale.headline-medium.weight
    );
  }

  static TextStyle headlineLarge() {
    return GoogleFonts.robotoFlex(
      height: 1.33, // md.sys.typescale.headline-large.line-height
      fontSize: 24.0, // md.sys.typescale.headline-large.size
      fontWeight: FontWeight.w400, // md.sys.typescale.headline-large.weight
    );
  }

  static TextStyle labelSmall() {
    return GoogleFonts.robotoFlex(
      height: 1.45, // md.sys.typescale.label-small.line-height
      fontSize: 11.0, // md.sys.typescale.label-small.size
      fontWeight: FontWeight.w500, // md.sys.typescale.label-small.weight
    );
  }

  static TextStyle labelMedium() {
    return GoogleFonts.robotoFlex(
      height: 1.33, // md.sys.typescale.label-medium.line-height
      fontSize: 12.0, // md.sys.typescale.label-medium.size
      fontWeight: FontWeight.w500, // md.sys.typescale.label-medium.weight
    );
  }

  static TextStyle labelLarge() {
    return GoogleFonts.robotoFlex(
      height: 1.43, // md.sys.typescale.label-large.line-height
      fontSize: 14.0, // md.sys.typescale.label-large.size
      fontWeight: FontWeight.w500, // md.sys.typescale.label-large.weight
    );
  }

  static TextStyle titleSmall() {
    return GoogleFonts.robotoFlex(
      height: 1.43, // md.sys.typescale.title-small.line-height
      fontSize: 14.0, // md.sys.typescale.title-small.size
      fontWeight: FontWeight.w500, // md.sys.typescale.title-small.weight
    );
  }

  static TextStyle titleMedium() {
    return GoogleFonts.robotoFlex(
      height: 1.50, // md.sys.typescale.title-medium.line-height
      fontSize: 16.0, // md.sys.typescale.title-medium.size
      fontWeight: FontWeight.w500, // md.sys.typescale.title-medium.weight
    );
  }

  static TextStyle titleLarge() {
    return GoogleFonts.robotoFlex(
      height: 1.27, // md.sys.typescale.title-large.line-height
      fontSize: 22.0, // md.sys.typescale.title-large.size
      fontWeight: FontWeight.w400, // md.sys.typescale.title-large.weight
    );
  }
}
