/// Library containing all logic and accessors to make calls to Tautulli's API.
library tautulli_commands;

import 'dart:typed_data';
import 'package:dio/dio.dart';
import 'package:lunasea/api/tautulli/types.dart';
import 'package:lunasea/api/tautulli/models.dart';

// Activity
part 'commands/activity.dart';
part 'commands/activity/delete_temp_sessions.dart';
part 'commands/activity/get_activity.dart';
part 'commands/activity/terminate_session.dart';
// History
part 'commands/history.dart';
part 'commands/history/delete_history.dart';
part 'commands/history/get_history.dart';
part 'commands/history/get_home_stats.dart';
part 'commands/history/get_plays_by_date.dart';
part 'commands/history/get_plays_by_dayofweek.dart';
part 'commands/history/get_plays_by_hourofday.dart';
part 'commands/history/get_plays_by_source_resolution.dart';
part 'commands/history/get_plays_by_stream_resolution.dart';
part 'commands/history/get_plays_by_stream_type.dart';
part 'commands/history/get_plays_by_top_10_platforms.dart';
part 'commands/history/get_plays_by_top_10_users.dart';
part 'commands/history/get_plays_per_month.dart';
part 'commands/history/get_stream_data.dart';
part 'commands/history/get_stream_type_by_top_10_platforms.dart';
part 'commands/history/get_stream_type_by_top_10_users.dart';
// Libraries
part 'commands/libraries.dart';
part 'commands/libraries/delete_all_library_history.dart';
part 'commands/libraries/delete_library.dart';
part 'commands/libraries/delete_recently_added.dart';
part 'commands/libraries/edit_library.dart';
part 'commands/libraries/get_libraries.dart';
part 'commands/libraries/get_libraries_table.dart';
part 'commands/libraries/get_library.dart';
part 'commands/libraries/get_library_media_info.dart';
part 'commands/libraries/get_library_names.dart';
part 'commands/libraries/get_library_user_stats.dart';
part 'commands/libraries/get_library_watch_time_stats.dart';
part 'commands/libraries/get_metadata.dart';
part 'commands/libraries/get_new_rating_keys.dart';
part 'commands/libraries/get_old_rating_keys.dart';
part 'commands/libraries/get_recently_added.dart';
part 'commands/libraries/get_synced_items.dart';
part 'commands/libraries/refresh_libraries_list.dart';
part 'commands/libraries/search.dart';
part 'commands/libraries/update_metadata_details.dart';
part 'commands/libraries/undelete_library.dart';
// Miscellaneous
part 'commands/miscellaneous.dart';
part 'commands/miscellaneous/arnold.dart';
part 'commands/miscellaneous/docs.dart';
part 'commands/miscellaneous/docs_md.dart';
part 'commands/miscellaneous/download_config.dart';
part 'commands/miscellaneous/download_database.dart';
part 'commands/miscellaneous/download_log.dart';
part 'commands/miscellaneous/download_plex_log.dart';
part 'commands/miscellaneous/get_date_formats.dart';
part 'commands/miscellaneous/get_plex_log.dart';
part 'commands/miscellaneous/get_geoip_lookup.dart';
part 'commands/miscellaneous/get_logs.dart';
part 'commands/miscellaneous/get_server_friendly_name.dart';
part 'commands/miscellaneous/get_server_id.dart';
part 'commands/miscellaneous/get_server_identity.dart';
part 'commands/miscellaneous/get_server_list.dart';
part 'commands/miscellaneous/get_server_pref.dart';
part 'commands/miscellaneous/get_servers_info.dart';
part 'commands/miscellaneous/get_whois_lookup.dart';
part 'commands/miscellaneous/pms_image_proxy.dart';
part 'commands/miscellaneous/sql.dart';
// Notification
part 'commands/notifications.dart';
part 'commands/notifications/add_newsletter_config.dart';
part 'commands/notifications/add_notifier_config.dart';
part 'commands/notifications/delete_mobile_device.dart';
part 'commands/notifications/delete_newsletter.dart';
part 'commands/notifications/delete_notifier.dart';
part 'commands/notifications/get_newsletter_config.dart';
part 'commands/notifications/get_newsletter_log.dart';
part 'commands/notifications/get_newsletters.dart';
part 'commands/notifications/get_notification_log.dart';
part 'commands/notifications/get_notifier_config.dart';
part 'commands/notifications/get_notifier_parameters.dart';
part 'commands/notifications/get_notifiers.dart';
part 'commands/notifications/notify.dart';
part 'commands/notifications/notify_newsletter.dart';
part 'commands/notifications/notify_recently_added.dart';
part 'commands/notifications/register_device.dart';
part 'commands/notifications/set_mobile_device_config.dart';
part 'commands/notifications/set_newsletter_config.dart';
part 'commands/notifications/set_notifier_config.dart';
// System
part 'commands/system.dart';
part 'commands/system/backup_config.dart';
part 'commands/system/backup_db.dart';
part 'commands/system/delete_cache.dart';
part 'commands/system/delete_hosted_images.dart';
part 'commands/system/delete_image_cache.dart';
part 'commands/system/delete_login_log.dart';
part 'commands/system/delete_lookup_info.dart';
part 'commands/system/delete_media_info_cache.dart';
part 'commands/system/delete_newsletter_log.dart';
part 'commands/system/delete_notification_log.dart';
part 'commands/system/get_pms_token.dart';
part 'commands/system/get_pms_update.dart';
part 'commands/system/get_settings.dart';
part 'commands/system/restart.dart';
part 'commands/system/status.dart';
part 'commands/system/update.dart';
part 'commands/system/update_check.dart';
// Users
part 'commands/users.dart';
part 'commands/users/delete_all_user_history.dart';
part 'commands/users/delete_user.dart';
part 'commands/users/edit_user.dart';
part 'commands/users/get_user.dart';
part 'commands/users/get_user_ips.dart';
part 'commands/users/get_user_logins.dart';
part 'commands/users/get_user_names.dart';
part 'commands/users/get_user_player_stats.dart';
part 'commands/users/get_user_watch_time_stats.dart';
part 'commands/users/get_users.dart';
part 'commands/users/get_users_table.dart';
part 'commands/users/refresh_users_list.dart';
part 'commands/users/undelete_user.dart';
