/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.core;

import android.os.Handler;
import android.util.Log;
import java.util.Observer;
import net.x52im.mobileimsdk.android.ClientCoreSDK;
import net.x52im.mobileimsdk.android.core.LocalDataSender;
import net.x52im.mobileimsdk.android.utils.MBThreadPoolExecutor;

public class AutoReLoginDaemon {
    private static final String TAG = AutoReLoginDaemon.class.getSimpleName();
    private static AutoReLoginDaemon instance = null;
    public static int AUTO_RE$LOGIN_INTERVAL = 3000;
    private Handler handler = null;
    private Runnable runnable = null;
    private boolean autoReLoginRunning = false;
    private boolean _excuting = false;
    private boolean init = false;
    private Observer debugObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoReLoginDaemon getInstance() {
        if (instance != null) return instance;
        Class<AutoReLoginDaemon> clazz = AutoReLoginDaemon.class;
        synchronized (AutoReLoginDaemon.class) {
            if (instance != null) return instance;
            instance = new AutoReLoginDaemon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AutoReLoginDaemon() {
        this.init();
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.handler = new Handler();
        this.runnable = () -> {
            if (!this._excuting) {
                MBThreadPoolExecutor.runInBackground(() -> {
                    int code = this.doSendLogin();
                    MBThreadPoolExecutor.runOnMainThread(() -> this.onSendLogin(code));
                });
            }
        };
        this.init = true;
    }

    private int doSendLogin() {
        this._excuting = true;
        if (ClientCoreSDK.DEBUG) {
            Log.d((String)TAG, (String)("\u3010IMCORE-TCP\u3011\u81ea\u52a8\u91cd\u65b0\u767b\u9646\u7ebf\u7a0b\u6267\u884c\u4e2d, autoReLogin?" + ClientCoreSDK.autoReLogin + "..."));
        }
        int code = -1;
        if (ClientCoreSDK.autoReLogin) {
            code = LocalDataSender.getInstance().sendLogin(ClientCoreSDK.getInstance().getCurrentLoginInfo());
        }
        return code;
    }

    private void onSendLogin(int result) {
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 2);
        }
        if (result == 0) {
            // empty if block
        }
        this._excuting = false;
        this.handler.postDelayed(this.runnable, (long)AUTO_RE$LOGIN_INTERVAL);
    }

    public void stop() {
        this.handler.removeCallbacks(this.runnable);
        this.autoReLoginRunning = false;
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 0);
        }
    }

    public void start(boolean immediately) {
        this.stop();
        this.handler.postDelayed(this.runnable, immediately ? 0L : (long)AUTO_RE$LOGIN_INTERVAL);
        this.autoReLoginRunning = true;
        if (this.debugObserver != null) {
            this.debugObserver.update(null, 1);
        }
    }

    public boolean isAutoReLoginRunning() {
        return this.autoReLoginRunning;
    }

    public boolean isInit() {
        return this.init;
    }

    public Observer getDebugObserver() {
        return this.debugObserver;
    }

    public void setDebugObserver(Observer debugObserver) {
        this.debugObserver = debugObserver;
    }
}

