/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import net.x52im.mobileimsdk.android.core.AutoReLoginDaemon;
import net.x52im.mobileimsdk.android.core.KeepAliveDaemon;
import net.x52im.mobileimsdk.android.core.LocalDataReciever;
import net.x52im.mobileimsdk.android.core.LocalSocketProvider;
import net.x52im.mobileimsdk.android.core.QoS4ReciveDaemon;
import net.x52im.mobileimsdk.android.core.QoS4SendDaemon;
import net.x52im.mobileimsdk.android.event.ChatBaseEvent;
import net.x52im.mobileimsdk.android.event.ChatMessageEvent;
import net.x52im.mobileimsdk.android.event.MessageQoSEvent;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;

public class ClientCoreSDK {
    private static final String TAG = ClientCoreSDK.class.getSimpleName();
    public static boolean DEBUG = true;
    public static boolean autoReLogin = true;
    private static ClientCoreSDK instance = null;
    private boolean _init = false;
    private boolean connectedToServer = true;
    private boolean loginHasInit = false;
    private PLoginInfo currentLoginInfo = null;
    private ChatBaseEvent chatBaseEvent = null;
    private ChatMessageEvent chatMessageEvent = null;
    private MessageQoSEvent messageQoSEvent = null;
    private Context context = null;
    private final BroadcastReceiver networkConnectionStatusBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo mobNetInfo = connectMgr.getNetworkInfo(0);
            NetworkInfo wifiNetInfo = connectMgr.getNetworkInfo(1);
            NetworkInfo ethernetInfo = connectMgr.getNetworkInfo(9);
            if (!(mobNetInfo != null && mobNetInfo.isConnected() || wifiNetInfo != null && wifiNetInfo.isConnected() || ethernetInfo != null && ethernetInfo.isConnected())) {
                Log.w((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u3010\u672c\u5730\u7f51\u7edc\u901a\u77e5\u3011\u68c0\u6d4b\u672c\u5730\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00\u4e86!");
                LocalSocketProvider.getInstance().closeLocalSocket();
            } else {
                if (DEBUG) {
                    Log.i((String)TAG, (String)"\u3010IMCORE-TCP\u3011\u3010\u672c\u5730\u7f51\u7edc\u901a\u77e5\u3011\u68c0\u6d4b\u672c\u5730\u7f51\u7edc\u5df2\u8fde\u63a5\u4e0a\u4e86!");
                }
                LocalSocketProvider.getInstance().closeLocalSocket();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientCoreSDK getInstance() {
        if (instance != null) return instance;
        Class<ClientCoreSDK> clazz = ClientCoreSDK.class;
        synchronized (ClientCoreSDK.class) {
            if (instance != null) return instance;
            instance = new ClientCoreSDK();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ClientCoreSDK() {
    }

    public void init(Context _context) {
        if (!this._init) {
            if (_context == null) {
                throw new IllegalArgumentException("context can't be null!");
            }
            this.context = _context instanceof Application ? _context : _context.getApplicationContext();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.context.registerReceiver(this.networkConnectionStatusBroadcastReceiver, intentFilter);
            AutoReLoginDaemon.getInstance();
            KeepAliveDaemon.getInstance();
            LocalDataReciever.getInstance();
            QoS4ReciveDaemon.getInstance();
            QoS4SendDaemon.getInstance();
            this._init = true;
        }
    }

    public void release() {
        this.setConnectedToServer(false);
        LocalSocketProvider.getInstance().closeLocalSocket();
        AutoReLoginDaemon.getInstance().stop();
        QoS4SendDaemon.getInstance().stop();
        KeepAliveDaemon.getInstance().stop();
        QoS4ReciveDaemon.getInstance().stop();
        QoS4SendDaemon.getInstance().clear();
        QoS4ReciveDaemon.getInstance().clear();
        try {
            this.context.unregisterReceiver(this.networkConnectionStatusBroadcastReceiver);
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"\u8fd8\u672a\u6ce8\u518candroid\u7f51\u7edc\u4e8b\u4ef6\u5e7f\u64ad\u7684\u76d1\u542c\u5668\uff0c\u672c\u6b21\u53d6\u6d88\u6ce8\u518c\u5df2\u88ab\u6b63\u5e38\u5ffd\u7565\u54e6.");
        }
        this._init = false;
        this.setLoginHasInit(false);
    }

    public void setCurrentLoginInfo(PLoginInfo currentLoginInfo) {
        this.currentLoginInfo = currentLoginInfo;
    }

    public PLoginInfo getCurrentLoginInfo() {
        return this.currentLoginInfo;
    }

    public void saveFirstLoginTime(long firstLoginTime) {
        if (this.currentLoginInfo != null) {
            this.currentLoginInfo.setFirstLoginTime(firstLoginTime);
        }
    }

    @Deprecated
    public String getCurrentLoginUserId() {
        return this.currentLoginInfo.getLoginUserId();
    }

    @Deprecated
    public String getCurrentLoginToken() {
        return this.currentLoginInfo.getLoginToken();
    }

    @Deprecated
    public String getCurrentLoginExtra() {
        return this.currentLoginInfo.getExtra();
    }

    public boolean isLoginHasInit() {
        return this.loginHasInit;
    }

    public ClientCoreSDK setLoginHasInit(boolean loginHasInit) {
        this.loginHasInit = loginHasInit;
        return this;
    }

    public boolean isConnectedToServer() {
        return this.connectedToServer;
    }

    public void setConnectedToServer(boolean connectedToServer) {
        this.connectedToServer = connectedToServer;
    }

    public boolean isInitialed() {
        return this._init;
    }

    public void setChatBaseEvent(ChatBaseEvent chatBaseEvent) {
        this.chatBaseEvent = chatBaseEvent;
    }

    public ChatBaseEvent getChatBaseEvent() {
        return this.chatBaseEvent;
    }

    public void setChatMessageEvent(ChatMessageEvent chatMessageEvent) {
        this.chatMessageEvent = chatMessageEvent;
    }

    public ChatMessageEvent getChatMessageEvent() {
        return this.chatMessageEvent;
    }

    public void setMessageQoSEvent(MessageQoSEvent messageQoSEvent) {
        this.messageQoSEvent = messageQoSEvent;
    }

    public MessageQoSEvent getMessageQoSEvent() {
        return this.messageQoSEvent;
    }
}

