/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.swing9patch.toast;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.Timer;
import org.jb2011.lnf.beautyeye.utils.WindowTranslucencyHelper;
import org.jb2011.swing9patch.toast.ToastPane;

public class Toast
extends JDialog
implements ActionListener {
    private Point showPossition = null;
    private Timer timer = null;
    private ToastPane toastPane = null;

    public Toast(int delay, String message, Point p) {
        this.initGUI();
        this.timer = new Timer(delay, this);
        this.toastPane.setMessage(message);
        this.showPossition = p;
    }

    protected void initGUI() {
        this.setAlwaysOnTop(true);
        this.setUndecorated(true);
        WindowTranslucencyHelper.setWindowOpaque(this, false);
        ((JComponent)this.getContentPane()).setOpaque(false);
        this.getRootPane().setWindowDecorationStyle(0);
        this.toastPane = new ToastPane();
        this.add(this.toastPane);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (float i = 1.0f; i >= 0.0f; i -= 0.05f) {
            try {
                WindowTranslucencyHelper.setOpacity(this, i);
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.dispose();
    }

    public Toast showItNow() {
        this.pack();
        if (this.showPossition == null || this.showPossition.x < 0 && this.showPossition.y < 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(new Point(this.showPossition.x < 0 ? 0 : this.showPossition.x, this.showPossition.y < 0 ? 0 : this.showPossition.y));
        }
        this.setVisible(true);
        this.timer.start();
        return this;
    }

    public static Toast showTost(int delay, String message, Point p) {
        return new Toast(delay, message, p).showItNow();
    }
}

