/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch4_scroll;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jb2011.lnf.beautyeye.ch4_scroll.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.BEUtils;
import org.jb2011.ninepatch4j.NinePatch;

public class BEScrollBarUI
extends BasicScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new BEScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected JButton createIncreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (c == null || g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint oldp = g2.getPaint();
        int w = trackBounds.width;
        int h = trackBounds.height;
        int x = trackBounds.x;
        int y = trackBounds.y;
        if (this.scrollbar.getOrientation() == 1) {
            int hhhWidth = 5;
            int px = (w - hhhWidth) / 2;
            int delta = 50;
            g2.setColor(new Color(150 + delta, 151 + delta, 146 + delta));
            g2.drawLine(px + 0, y + 10, px + 0, y + h - 10);
            g2.setColor(new Color(160 + delta, 160 + delta, 162 + delta));
            g2.drawLine(px + 1, y + 10, px + 1, y + h - 10);
            g2.setColor(new Color(163 + delta, 162 + delta, 167 + delta));
            g2.drawLine(px + 2, y + 10, px + 2, y + h - 10);
            g2.setColor(new Color(162 + delta, 162 + delta, 162 + delta));
            g2.drawLine(px + 3, y + 10, px + 3, y + h - 10);
            g2.setColor(new Color(150 + delta, 150 + delta, 150 + delta));
            g2.drawLine(px + 4, y + 10, px + 4, y + h - 10);
        } else {
            int hhhWidth = 5;
            int py = (h - hhhWidth) / 2;
            int delta = 50;
            g2.setColor(new Color(150 + delta, 151 + delta, 146 + delta));
            g2.drawLine(x + 10, py + 0, x + w - 10, py + 0);
            g2.setColor(new Color(160 + delta, 160 + delta, 162 + delta));
            g2.drawLine(x + 10, py + 1, x + w - 10, py + 1);
            g2.setColor(new Color(163 + delta, 162 + delta, 167 + delta));
            g2.drawLine(x + 10, py + 2, x + w - 10, py + 2);
            g2.setColor(new Color(162 + delta, 162 + delta, 162 + delta));
            g2.drawLine(x + 10, py + 3, x + w - 10, py + 3);
            g2.setColor(new Color(150 + delta, 150 + delta, 150 + delta));
            g2.drawLine(x + 10, py + 4, x + w - 10, py + 4);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = thumbBounds.width - 4;
        int h = thumbBounds.height - 4;
        g2.translate(thumbBounds.x + 2, thumbBounds.y + 2);
        BEUtils.setAntiAliasing(g2, true);
        if (this.scrollbar.getOrientation() == 1) {
            NinePatch np = null;
            np = this.isDragging ? __Icon9Factory__.getInstance().getScrollBar_pressed_v() : (this.isThumbRollover() ? __Icon9Factory__.getInstance().getScrollBar_rover_v() : __Icon9Factory__.getInstance().getScrollBar_v());
            if (h < np.getHeight()) {
                this.paintThumbIfSoSmall(g2, 0, 0, w, h);
            } else {
                np.draw(g2, 0, 0, w, h);
            }
        } else {
            NinePatch np = null;
            np = this.isDragging ? __Icon9Factory__.getInstance().getScrollBar_pressed_h() : (this.isThumbRollover() ? __Icon9Factory__.getInstance().getScrollBar_rover_h() : __Icon9Factory__.getInstance().getScrollBar_h());
            if (w < np.getWidth()) {
                this.paintThumbIfSoSmall(g2, 0, 0, w, h);
            } else {
                np.draw(g2, 0, 0, w, h);
            }
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
        BEUtils.setAntiAliasing(g2, false);
    }

    protected void paintThumbIfSoSmall(Graphics2D g2, int x, int y, int w, int h) {
        int NORMAL_ARC = 6;
        int arc = w <= 6 || h <= 6 ? 0 : 6;
        g2.setColor(this.thumbDarkShadowColor);
        g2.drawRoundRect(x, y, w - 1, h - 1, arc, arc);
        g2.setColor(this.thumbColor);
        g2.fillRoundRect(x + 1, y + 1, w - 2, h - 2, arc, arc);
    }

    protected class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
        }

        public WindowsArrowButton(int direction) {
            super(direction);
        }

        public void paint(Graphics g) {
            ButtonModel model = this.getModel();
            Graphics2D g2 = (Graphics2D)g;
            switch (this.direction) {
                case 1: {
                    if (model.isRollover()) {
                        __Icon9Factory__.getInstance().getScrollBarArrow_toTop_rover().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    __Icon9Factory__.getInstance().getScrollBarArrow_toTop().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case 5: {
                    if (model.isRollover()) {
                        __Icon9Factory__.getInstance().getScrollBarArrow_toBottom_rover().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    __Icon9Factory__.getInstance().getScrollBarArrow_toBottom().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case 7: {
                    if (model.isRollover()) {
                        __Icon9Factory__.getInstance().getScrollBarArrow_toLeft_rover().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    __Icon9Factory__.getInstance().getScrollBarArrow_toLeft().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                    break;
                }
                case 3: {
                    if (model.isRollover()) {
                        __Icon9Factory__.getInstance().getScrollBarArrow_toRight_rover().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    __Icon9Factory__.getInstance().getScrollBarArrow_toRight().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                }
            }
        }

        public Dimension getPreferredSize() {
            int size = 16;
            if (BEScrollBarUI.this.scrollbar != null) {
                switch (BEScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        size = BEScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        size = BEScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                size = Math.max(size, 5);
            }
            return new Dimension(size, size);
        }
    }
}

