/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.demo;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.widget.HardLayoutPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.LineBorder;
import net.x52im.mobileimsdk.java.conf.ConfigEntity;
import net.x52im.mobileimsdk.java.core.LocalDataSender;
import net.x52im.mobileimsdk.java.core.LocalSocketProvider;
import net.x52im.mobileimsdk.java.demo.IMClientManager;
import net.x52im.mobileimsdk.java.demo.Launch;
import net.x52im.mobileimsdk.java.demo.MainGUI;
import net.x52im.mobileimsdk.server.protocal.c.PLoginInfo;
import org.jb2011.lnf.beautyeye.ch3_button.BEButtonUI;
import org.jb2011.swing9patch.toast.Toast;

public class LoginGUI
extends JFrame {
    private JTextField editServerIp = null;
    private JTextField editServerPort = null;
    private JTextField editLoginName = null;
    private JPasswordField editLoginPsw = null;
    private JButton btnLogin = null;
    private OnLoginProgress onLoginProgress = null;
    private Observer onLoginSucessObserver = null;

    public LoginGUI() {
        this.initViews();
        this.initListeners();
        IMClientManager.getInstance().initMobileIMSDK();
        this.initForLogin();
    }

    private void initViews() {
        this.editServerIp = new JTextField(16);
        this.editServerPort = new JTextField(5);
        this.editServerIp.setForeground(new Color(13, 148, 252));
        this.editServerPort.setForeground(new Color(13, 148, 252));
        this.editServerIp.setText("rbcore.52im.net");
        this.editServerPort.setText("8901");
        this.btnLogin = new JButton("  \u767b \u9646  ");
        this.btnLogin.setUI(new BEButtonUI().setNormalColor(BEButtonUI.NormalColor.blue));
        this.btnLogin.setForeground(Color.white);
        this.editLoginName = new JTextField(30);
        this.editLoginPsw = new JPasswordField(30);
        HardLayoutPane mainPanel = new HardLayoutPane();
        mainPanel.setComponentInsets(new Insets(4, 10, 4, 10));
        JPanel serverInfoPane = new JPanel(new BorderLayout());
        JPanel portInfoPane = new JPanel(new BorderLayout());
        portInfoPane.add((Component)new JLabel("\uff1a"), "West");
        portInfoPane.add((Component)this.editServerPort, "Center");
        serverInfoPane.add((Component)this.editServerIp, "Center");
        serverInfoPane.add((Component)portInfoPane, "East");
        mainPanel.addTo(serverInfoPane, 2, true);
        mainPanel.nextLine();
        mainPanel.addTo(new JLabel("\u7528\u6237\u540d\uff1a"), 1, true);
        mainPanel.addTo(this.editLoginName, 1, true);
        mainPanel.nextLine();
        mainPanel.addTo(new JLabel("\u5bc6  \u7801\uff1a"), 1, true);
        mainPanel.addTo(this.editLoginPsw, 1, true);
        mainPanel.addTitledLineSeparator("");
        JPanel btnAndVerPanel = new JPanel();
        btnAndVerPanel.setLayout(new BoxLayout(btnAndVerPanel, 2));
        JLabel lbVer = new JLabel("v6.5b240427");
        lbVer.setForeground(new Color(184, 184, 184));
        btnAndVerPanel.add(lbVer);
        btnAndVerPanel.add(Box.createHorizontalGlue());
        btnAndVerPanel.add(this.btnLogin);
        mainPanel.addTo(btnAndVerPanel, 2, true);
        LineBorder bottomPabelTopBorder = new LineBorder(new Color(235, 235, 235)){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color oldColor = g.getColor();
                g.setColor(this.lineColor);
                g.drawLine(x, y, width, y);
                g.setColor(oldColor);
            }
        };
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.setBackground(Color.white);
        bottomPanel.setBorder(BorderFactory.createCompoundBorder(bottomPabelTopBorder, BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        bottomPanel.add((Component)new JLabel(new ImageIcon(LoginGUI.class.getResource("res/copyright_img.png"))), "Center");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 5, 4, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.setTitle("MobileIMSDK_TCP v6 - Demo\u767b\u9646");
        this.setResizable(false);
        this.pack();
    }

    private void initListeners() {
        this.btnLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginGUI.this.doLogin();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainGUI.doExit();
            }
        });
    }

    private void initForLogin() {
        this.onLoginProgress = new OnLoginProgress();
        this.onLoginSucessObserver = new Observer(){

            @Override
            public void update(Observable observable, Object data) {
                LoginGUI.this.onLoginProgress.showProgressing(false);
                int code = (Integer)data;
                if (code == 0) {
                    Launch.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            MainGUI frame = new MainGUI();
                            frame.setLocationRelativeTo(null);
                            frame.setVisible(true);
                            LoginGUI.this.dispose();
                        }
                    });
                } else {
                    JOptionPane.showMessageDialog(LoginGUI.this, "Sorry\uff0c\u767b\u9646\u5931\u8d25\uff0c\u9519\u8bef\u7801=" + code, "\u53cb\u60c5\u63d0\u793a", 0);
                }
            }
        };
    }

    private void doLogin() {
        String serverIP = this.editServerIp.getText();
        String serverPort = this.editServerPort.getText();
        if (!CommonUtils.isStringEmpty(serverIP, true) && !CommonUtils.isStringEmpty(serverPort, true)) {
            LocalSocketProvider.getInstance().closeLocalSocket();
            ConfigEntity.serverIP = serverIP.trim();
            try {
                ConfigEntity.serverPort = Integer.parseInt(serverPort.trim());
            }
            catch (Exception e2) {
                this.showToast("\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u7aef\u53e3\u53f7\uff01");
                return;
            }
        } else {
            this.showToast("\u8bf7\u786e\u4fdd\u670d\u52a1\u7aef\u5730\u5740\u548c\u7aef\u53e3\u53f7\u90fd\u4e0d\u4e3a\u7a7a\uff01");
            return;
        }
        if (this.editLoginName.getText().toString().trim().length() > 0) {
            this.doLoginImpl();
        } else {
            JOptionPane.showMessageDialog(this, "\u5e05\u54e5\uff0c\u767b\u9646\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0cDemo\u8fd0\u884c\u65f6\u8bf7\u968f\u4fbf\u8f93\u5165^_^!", "\u53cb\u60c5\u63d0\u793a", 2);
        }
    }

    private void doLoginImpl() {
        this.onLoginProgress.showProgressing(true);
        IMClientManager.getInstance().getBaseEventListener().setLoginOkForLaunchObserver(this.onLoginSucessObserver);
        PLoginInfo loginInfo = new PLoginInfo(this.editLoginName.getText(), this.editLoginPsw.getText());
        new LocalDataSender.SendLoginDataAsync(loginInfo){

            @Override
            protected void fireAfterSendLogin(int code) {
                if (code == 0) {
                    LoginGUI.this.showToast("\u6570\u636e\u53d1\u9001\u6210\u529f\uff01");
                } else {
                    LoginGUI.this.showToast("\u6570\u636e\u53d1\u9001\u5931\u8d25\u3002\u9519\u8bef\u7801\u662f\uff1a" + code + "\uff01");
                    LoginGUI.this.onLoginProgress.showProgressing(false);
                }
            }
        }.execute();
    }

    public void showToast(String text) {
        Toast.showTost(3000, text, new Point((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY()));
    }

    private class OnLoginProgress {
        private static final int RETRY_DELAY = 6000;
        private Timer timer = null;

        public OnLoginProgress() {
            this.init();
        }

        private void init() {
            this.timer = new Timer(6000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OnLoginProgress.this.onTimeout();
                }
            });
        }

        private void onTimeout() {
            Object[] options = new Object[]{"\u91cd\u8bd5\uff01", "\u53d6\u6d88"};
            int n = JOptionPane.showOptionDialog(LoginGUI.this, "\u767b\u9646\u8d85\u65f6\uff0c\u53ef\u80fd\u662f\u7f51\u7edc\u6545\u969c\u6216\u670d\u52a1\u5668\u65e0\u6cd5\u8fde\u63a5\uff0c\u662f\u5426\u91cd\u8bd5\uff1f", "\u8d85\u65f6\u4e86", 0, 3, null, options, options[0]);
            if (n == 0) {
                LoginGUI.this.doLogin();
            } else {
                this.showProgressing(false);
            }
        }

        public void showProgressing(boolean show) {
            if (show) {
                this.showLoginProgressGUI(true);
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.timer.start();
            } else {
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.showLoginProgressGUI(false);
            }
        }

        private void showLoginProgressGUI(boolean show) {
            if (show) {
                LoginGUI.this.btnLogin.setText("\u767b\u9646\u4e2d,\u8bf7\u7a0d\u5019..");
                LoginGUI.this.btnLogin.setEnabled(false);
            } else {
                LoginGUI.this.btnLogin.setText("  \u767b \u9646  ");
                LoginGUI.this.btnLogin.setEnabled(true);
            }
        }
    }
}

