/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.demo;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.conf.ConfigEntity;
import net.x52im.mobileimsdk.java.demo.event.ChatBaseEventImpl;
import net.x52im.mobileimsdk.java.demo.event.ChatMessageEventImpl;
import net.x52im.mobileimsdk.java.demo.event.MessageQoSEventImpl;
import net.x52im.mobileimsdk.java.utils.Log;

public class IMClientManager {
    private static String TAG = IMClientManager.class.getSimpleName();
    private static IMClientManager instance = null;
    private boolean init = false;
    private ChatBaseEventImpl baseEventListener = null;
    private ChatMessageEventImpl transDataListener = null;
    private MessageQoSEventImpl messageQoSListener = null;

    public static IMClientManager getInstance() {
        if (instance == null) {
            instance = new IMClientManager();
        }
        return instance;
    }

    private IMClientManager() {
        this.initMobileIMSDK();
    }

    public void initMobileIMSDK() {
        if (!this.init) {
            ConfigEntity.setSenseMode(ConfigEntity.SenseMode.MODE_5S);
            ClientCoreSDK.DEBUG = true;
            this.baseEventListener = new ChatBaseEventImpl();
            this.transDataListener = new ChatMessageEventImpl();
            this.messageQoSListener = new MessageQoSEventImpl();
            ClientCoreSDK.getInstance().setChatBaseEvent(this.baseEventListener);
            ClientCoreSDK.getInstance().setChatMessageEvent(this.transDataListener);
            ClientCoreSDK.getInstance().setMessageQoSEvent(this.messageQoSListener);
            this.init = true;
        }
    }

    public SslContext createSslContext() {
        SslContext sslContext = null;
        try {
            sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            Log.d(TAG, "\u3010IMCORE-TCP\u3011\u5df2\u5f00\u542fSSL/TLS\u52a0\u5bc6(\u5355\u5411\u8ba4\u8bc1)\uff0c\u4e14sslContext\u521b\u5efa\u6210\u529f\u3002");
        }
        catch (Exception e) {
            Log.w(TAG, "\u3010IMCORE-TCP\u3011\u521b\u5efasslContext\u65f6\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), e);
        }
        return sslContext;
    }

    public void release() {
        ClientCoreSDK.getInstance().release();
        this.resetInitFlag();
    }

    public void resetInitFlag() {
        this.init = false;
    }

    public ChatMessageEventImpl getChatMessageListener() {
        return this.transDataListener;
    }

    public ChatBaseEventImpl getBaseEventListener() {
        return this.baseEventListener;
    }

    public MessageQoSEventImpl getMessageQoSListener() {
        return this.messageQoSListener;
    }
}

