/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.java.core;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.netty.util.CharsetUtil;
import net.x52im.mobileimsdk.java.ClientCoreSDK;
import net.x52im.mobileimsdk.java.conf.ConfigEntity;
import net.x52im.mobileimsdk.java.core.KeepAliveDaemon;
import net.x52im.mobileimsdk.java.core.LocalDataReciever;
import net.x52im.mobileimsdk.java.utils.Log;
import net.x52im.mobileimsdk.java.utils.MBObserver;

public class LocalSocketProvider {
    private static final String TAG = LocalSocketProvider.class.getSimpleName();
    public static int TCP_FRAME_FIXED_HEADER_LENGTH = 4;
    public static int TCP_FRAME_MAX_BODY_LENGTH = 6144;
    public static SslContext sslContext = null;
    private static LocalSocketProvider instance = null;
    private Bootstrap bootstrap = null;
    private Channel localSocket = null;
    private ChannelFuture localConnectingFuture = null;
    private MBObserver connectionDoneObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalSocketProvider getInstance() {
        if (instance != null) return instance;
        Class<LocalSocketProvider> clazz = LocalSocketProvider.class;
        synchronized (LocalSocketProvider.class) {
            if (instance != null) return instance;
            instance = new LocalSocketProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LocalSocketProvider() {
    }

    private void initLocalBootstrap() {
        try {
            NioEventLoopGroup group = new NioEventLoopGroup();
            this.bootstrap = new Bootstrap();
            ((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class);
            this.bootstrap.handler(new TCPChannelInitializerHandler());
            this.bootstrap.option(ChannelOption.SO_KEEPALIVE, true);
            this.bootstrap.option(ChannelOption.TCP_NODELAY, true);
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
        }
        catch (Exception e) {
            Log.w(TAG, "localSocket\u521d\u59cb\u5316\u65f6\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), e);
        }
    }

    public void setConnectionDoneObserver(MBObserver connectionDoneObserver) {
        this.connectionDoneObserver = connectionDoneObserver;
    }

    public Channel resetLocalSocket() {
        try {
            this.closeLocalSocket();
            this.initLocalBootstrap();
            this.tryConnectToHost();
            return this.localSocket;
        }
        catch (Exception e) {
            Log.w(TAG, "\u3010IMCORE-TCP\u3011\u91cd\u7f6elocalSocket\u65f6\u51fa\u9519\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), e);
            this.closeLocalSocket();
            return null;
        }
    }

    private boolean tryConnectToHost() {
        if (ClientCoreSDK.DEBUG) {
            Log.d(TAG, "\u3010IMCORE-TCP\u3011tryConnectToHost\u5e76\u83b7\u53d6connection\u5f00\u59cb\u4e86...");
        }
        try {
            ChannelFuture cf = this.bootstrap.connect(ConfigEntity.serverIP, ConfigEntity.serverPort);
            this.localSocket = cf.channel();
            this.localConnectingFuture = cf;
            cf.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isDone()) {
                        if (f.isCancelled()) {
                            Log.w(TAG, "\u3010IMCORE-tryConnectToHost-\u5f02\u6b65\u56de\u8c03\u3011Connection attempt cancelled by user");
                        } else if (!f.isSuccess()) {
                            Log.w(TAG, "\u3010IMCORE-tryConnectToHost-\u5f02\u6b65\u56de\u8c03\u3011\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", f.cause());
                        } else {
                            Log.i(TAG, "\u3010IMCORE-tryConnectToHost-\u5f02\u6b65\u56de\u8c03\u3011Connection established successfully");
                        }
                        if (LocalSocketProvider.this.connectionDoneObserver != null) {
                            LocalSocketProvider.this.connectionDoneObserver.update(f.isSuccess(), null);
                            LocalSocketProvider.this.connectionDoneObserver = null;
                        }
                    }
                    LocalSocketProvider.this.localConnectingFuture = null;
                }
            });
            this.localSocket.closeFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Log.i(TAG, "\u3010IMCORE-TCP\u3011channel\u4f18\u96c5\u9000\u51fa\u5f00\u59cb\u3002\u3002\u3002");
                    if (future.channel() != null) {
                        future.channel().eventLoop().shutdownGracefully();
                    }
                    LocalSocketProvider.this.localSocket = null;
                    Log.i(TAG, "\u3010IMCORE-TCP\u3011channel\u4f18\u96c5\u9000\u51fa\u7ed3\u675f\u3002");
                }
            });
            if (ClientCoreSDK.DEBUG) {
                Log.d(TAG, "\u3010IMCORE-TCP\u3011tryConnectToHost\u5e76\u83b7\u53d6connectio\u5df2\u5b8c\u6210\u3002 .... continue ...");
            }
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, String.format("\u3010IMCORE-TCP\u3011\u8fde\u63a5Server(IP[%s],PORT[%s])\u5931\u8d25", ConfigEntity.serverIP, ConfigEntity.serverPort), e);
            return false;
        }
    }

    public boolean isLocalSocketReady() {
        return this.localSocket != null && this.localSocket.isActive();
    }

    public Channel getLocalSocket() {
        if (this.isLocalSocketReady()) {
            if (ClientCoreSDK.DEBUG) {
                Log.d(TAG, "\u3010IMCORE-TCP\u3011isLocalSocketReady()==true\uff0c\u76f4\u63a5\u8fd4\u56de\u672c\u5730socket\u5f15\u7528\u54e6" + (LocalSocketProvider.isSsl() ? "(\u5df2\u5f00\u542fSSL/TLS\u52a0\u5bc6\u4f20\u8f93)" : "") + "\u3002");
            }
            return this.localSocket;
        }
        if (ClientCoreSDK.DEBUG) {
            Log.d(TAG, "\u3010IMCORE-TCP\u3011isLocalSocketReady()==false\uff0c\u9700\u8981\u5148resetLocalSocket()...");
        }
        return this.resetLocalSocket();
    }

    public void closeLocalSocket() {
        this.closeLocalSocket(true);
    }

    public void closeLocalSocket(boolean silent) {
        if (ClientCoreSDK.DEBUG && !silent) {
            Log.d(TAG, "\u3010IMCORE-TCP\u3011\u6b63\u5728closeLocalSocket()...");
        }
        if (this.localConnectingFuture != null) {
            try {
                this.localConnectingFuture.cancel(true);
                this.localConnectingFuture = null;
            }
            catch (Exception e) {
                Log.w(TAG, "\u3010IMCORE-TCP\u3011\u5728closeLocalSocket\u65b9\u6cd5\u4e2d\u8bd5\u56fe\u91ca\u653elocalConnectingFuture\u8d44\u6e90\u65f6\uff1a", e);
            }
        }
        if (this.bootstrap != null) {
            try {
                this.bootstrap.config().group().shutdownGracefully();
                this.bootstrap = null;
            }
            catch (Exception e) {
                Log.w(TAG, "\u3010IMCORE-TCP\u3011\u5728closeLocalSocket\u65b9\u6cd5\u4e2d\u8bd5\u56fe\u91ca\u653ebootstrap\u8d44\u6e90\u65f6\uff1a", e);
            }
        }
        if (this.localSocket != null) {
            try {
                this.localSocket.close();
                this.localSocket = null;
            }
            catch (Exception e) {
                Log.w(TAG, "\u3010IMCORE-TCP\u3011\u5728closeLocalSocket\u65b9\u6cd5\u4e2d\u8bd5\u56fe\u91ca\u653elocalSocket\u8d44\u6e90\u65f6\uff1a", e);
            }
        } else if (!silent) {
            Log.d(TAG, "\u3010IMCORE-TCP\u3011Socket\u5904\u4e8e\u672a\u521d\u5316\u72b6\u6001\uff08\u53ef\u80fd\u662f\u60a8\u8fd8\u672a\u767b\u9646\uff09\uff0c\u65e0\u9700\u5173\u95ed\u3002");
        }
    }

    public static boolean isSsl() {
        return sslContext != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TCPChannelInitializerHandler
    extends ChannelInitializer<Channel> {
        private TCPChannelInitializerHandler() {
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            if (sslContext != null) {
                pipeline.addFirst("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
            }
            pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(TCP_FRAME_FIXED_HEADER_LENGTH + TCP_FRAME_MAX_BODY_LENGTH, 0, TCP_FRAME_FIXED_HEADER_LENGTH, 0, TCP_FRAME_FIXED_HEADER_LENGTH));
            pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(TCP_FRAME_FIXED_HEADER_LENGTH));
            pipeline.addLast(TcpClientHandler.class.getSimpleName(), (ChannelHandler)new TcpClientHandler());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TcpClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final String TAG = TcpClientHandler.class.getSimpleName();

        private TcpClientHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            if (ClientCoreSDK.DEBUG) {
                Log.d(this.TAG, "\u3010IMCORE-netty-channelActive\u3011\u8fde\u63a5\u5df2\u6210\u529f\u5efa\u7acb\uff01(isLocalSocketReady=" + LocalSocketProvider.this.isLocalSocketReady() + ")");
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (ClientCoreSDK.DEBUG) {
                Log.d(this.TAG, "\u3010IMCORE-netty-channelInactive\u3011\u8fde\u63a5\u5df2\u65ad\u5f00\u3002\u3002\u3002\u3002(isLocalSocketReady=" + LocalSocketProvider.this.isLocalSocketReady() + ", ClientCoreSDK.connectedToServer=" + ClientCoreSDK.getInstance().isConnectedToServer() + ")");
            }
            if (ClientCoreSDK.getInstance().isConnectedToServer()) {
                if (ClientCoreSDK.DEBUG) {
                    Log.d(this.TAG, "\u3010IMCORE-netty-channelInactive\u3011\u8fde\u63a5\u5df2\u65ad\u5f00\uff0c\u7acb\u5373\u63d0\u524d\u8fdb\u5165\u6846\u67b6\u7684\u201c\u901a\u4fe1\u901a\u9053\u201d\u65ad\u5f00\u5904\u7406\u903b\u8f91(\u800c\u4e0d\u662f\u7b49\u5fc3\u8df3\u7ebf\u7a0b\u63a2\u6d4b\u5230\uff0c\u90a3\u5c31\u5df2\u7ecf\u6bd4\u8f83\u8fdf\u4e86)......");
                }
                KeepAliveDaemon.getInstance().notifyConnectionLost();
            }
        }

        @Override
        public void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
            if (ClientCoreSDK.DEBUG) {
                Log.d(this.TAG, "\u3010IMCORE-netty-channelRead0\u3011\u3010NOTE\u3011>>>>>> \u6536\u5230\u6d88\u606f(\u539f\u59cb\u5185\u5bb9)\uff1a" + buf.toString(CharsetUtil.UTF_8));
            }
            byte[] req = new byte[buf.readableBytes()];
            buf.readBytes(req);
            LocalDataReciever.getInstance().handleProtocal(req);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (ClientCoreSDK.DEBUG) {
                Log.w(this.TAG, "\u3010IMCORE-netty-exceptionCaught\u3011\u5f02\u5e38\u88ab\u89e6\u53d1\u4e86\uff0c\u539f\u56e0\u662f\uff1a" + cause.getMessage());
            }
            ctx.close();
        }
    }
}

