/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.common.util.SimpleLogger;
import com.eva.epc.widget.EDateField;
import com.eva.epc.widget.EQueryScope;
import com.eva.epc.widget.ERender;
import com.eva.epc.widget.ERenderComboBox;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.text.DateDocument;
import com.eva.epc.widget.util.WindowEfect;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class SwingUtils {
    public static String[] DEFAULT_FONT = new String[]{"Table.font", "TableHeader.font", "CheckBox.font", "Tree.font", "Viewport.font", "ProgressBar.font", "RadioButtonMenuItem.font", "ToolBar.font", "ColorChooser.font", "ToggleButton.font", "Panel.font", "TextArea.font", "Menu.font", "TableHeader.font", "OptionPane.font", "MenuBar.font", "Button.font", "Label.font", "PasswordField.font", "ScrollPane.font", "MenuItem.font", "ToolTip.font", "List.font", "EditorPane.font", "Table.font", "TabbedPane.font", "RadioButton.font", "CheckBoxMenuItem.font", "TextPane.font", "PopupMenu.font", "TitledBorder.font", "ComboBox.font"};

    public static void componentsOpaque(Component[] comps, boolean opaque) {
        if (comps == null) {
            return;
        }
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                if (c instanceof JComponent) {
                    ((JComponent)c).setOpaque(opaque);
                }
                SwingUtils.componentsOpaque(((Container)c).getComponents(), opaque);
            } else if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(opaque);
            }
            ++n2;
        }
    }

    public static void setButtonIcon(AbstractButton btn, ImageIcon ico) {
        btn.setIcon(ico);
        btn.setRolloverIcon(SwingUtils.filterWithRescaleOp(ico, 2.0f, 1.0f, 1.0f, 1.0f));
        btn.setPressedIcon(SwingUtils.filterWithRescaleOp(ico, 2.0f, 1.0f, 1.0f, 0.3f));
    }

    public static ImageIcon filterWithRescaleOp(ImageIcon iconBottom, float redFilter, float greenFilter, float blueFilter, float alphaFilter) {
        try {
            int w = iconBottom.getIconWidth();
            int h = iconBottom.getIconHeight();
            BufferedImage bi = new BufferedImage(w, h, 2);
            Graphics2D gg = (Graphics2D)bi.getGraphics();
            gg.drawImage(iconBottom.getImage(), 0, 0, w, h, null);
            float[] scales = new float[]{redFilter, greenFilter, blueFilter, alphaFilter};
            float[] offsets = new float[4];
            RescaleOp rop = new RescaleOp(scales, offsets, null);
            rop.filter(bi, bi);
            return new ImageIcon(bi);
        }
        catch (Exception e) {
            System.out.println("filterWithRescaleOp\u51fa\u9519\u4e86\uff0c" + e.getMessage() + ",iconBottom=" + iconBottom);
            return new ImageIcon();
        }
    }

    public static ImageIcon iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage bg = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)bg.getGraphics();
        icon.paintIcon(null, g2, 0, 0);
        return new ImageIcon(bg);
    }

    public static BigDecimal sumTableColumn(TableModel tmWillBeSumed, int checkColumn, int columnWillBeSumed) {
        return SwingUtils.sumTableColumn(tmWillBeSumed, checkColumn, new int[]{columnWillBeSumed});
    }

    public static BigDecimal sumTableColumn(TableModel tmWillBeSumed, int checkColumn, int[] columnsWillBeSumed) {
        BigDecimal value = new BigDecimal(0);
        int i = 0;
        while (i < tmWillBeSumed.getRowCount()) {
            if (checkColumn == -1 || checkColumn != -1 && (tmWillBeSumed.getValueAt(i, checkColumn).equals("1") || String.valueOf(tmWillBeSumed.getValueAt(i, checkColumn)).toLowerCase().equals("true"))) {
                int j = 0;
                while (j < columnsWillBeSumed.length) {
                    try {
                        value = value.add(new BigDecimal(tmWillBeSumed.getValueAt(i, columnsWillBeSumed[j]).toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            ++i;
        }
        return value;
    }

    public static byte[] imageToByte(Image i) {
        return SwingUtils.imageToByte(i, "PNG");
    }

    public static byte[] imageToByte(Image i, String imageFormatName) {
        if (i == null) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u53c2\u6570\u503c,i=null!");
        }
        byte[] tagInfo = null;
        try {
            BufferedImage bu = new BufferedImage(i.getWidth(null), i.getHeight(null), 1);
            Graphics g = bu.getGraphics();
            g.drawImage(i, 0, 0, i.getWidth(null), i.getHeight(null), null);
            ByteArrayOutputStream imageStream = new ByteArrayOutputStream();
            boolean resultWrite = ImageIO.write((RenderedImage)bu, imageFormatName, imageStream);
            tagInfo = imageStream.toByteArray();
        }
        catch (Exception e) {
            System.err.println("\u56fe\u7247\u6570\u636e\u8f6c\u6362\u6210byte\u6570\u7ec4\u65f6\u51fa\u9519\u4e86,\u539f\u56e0\u662f:" + e.getMessage());
        }
        return tagInfo;
    }

    public static Image byteToImage(byte[] imageWithBytes) throws Exception {
        if (imageWithBytes == null) {
            return null;
        }
        Image i = null;
        i = new ImageIcon(imageWithBytes).getImage();
        return i;
    }

    public static File showFileChooser(File f, FileOprType type) {
        return SwingUtils.showFileChooser(f, type, null);
    }

    public static File showFileChooser(File f, FileOprType type, FileFilter filter) {
        JFileChooser fileChooser = new JFileChooser();
        if (filter != null) {
            fileChooser.addChoosableFileFilter(filter);
        }
        fileChooser.setSelectedFile(f);
        int result = -1;
        switch (type) {
            case read: {
                result = fileChooser.showOpenDialog(null);
                break;
            }
            case write: {
                result = fileChooser.showSaveDialog(null);
            }
        }
        if (result == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static ERender createSfkyRenderer() {
        return SwingUtils.createSfkyRenderer("\u662f", "\u5426");
    }

    public static ERender createSfkyRenderer(String yesTxt, String noTxt) {
        if (CommonUtils.isStringEmpty(yesTxt, true) || CommonUtils.isStringEmpty(noTxt, true)) {
            throw new IllegalArgumentException("yesTxt or noTxt is empty!");
        }
        return new ERender(new IdName[]{new IdName("0", new ERender.ERenderDTO(noTxt, IconFactory.getInstance().getSfkyNOIcon16_16())), new IdName("1", new ERender.ERenderDTO(yesTxt, IconFactory.getInstance().getSfkyYESIcon16_16()))});
    }

    public static ERenderComboBox createSfkyComBox() {
        ERenderComboBox com = new ERenderComboBox(SwingUtils.createSfkyRenderer());
        com.setSelectedIndex(1);
        return com;
    }

    public static ERenderComboBox createSfkyComBox(String yesTxt, String noTxt) {
        ERenderComboBox com = new ERenderComboBox(SwingUtils.createSfkyRenderer(yesTxt, noTxt));
        com.setSelectedIndex(1);
        return com;
    }

    public static String parseTextFromMemonicText(String name, int[] mnemonic) {
        int index = -1;
        int mn = 0;
        if (name != null && (index = name.indexOf(38)) != -1 && index != name.length() - 1) {
            name = name.substring(0, index).concat(name.substring(index + 1));
            mn = name.charAt(index);
        } else if (name != null && (index = name.lastIndexOf(41)) != -1 && (index = name.lastIndexOf(40, index - 2)) != -1) {
            mn = name.charAt(index + 1);
        }
        mnemonic[0] = mn;
        return name;
    }

    public static EDateField createDateField(String pattern) {
        EDateField field = new EDateField(pattern);
        field.setDate(new Date());
        field.setColumns(12);
        return field;
    }

    public static EDateField createDateField() {
        return SwingUtils.createDateField(DateDocument.DEFAULT_DATE_PATTERN);
    }

    public static EDateField createMonthField() {
        EDateField txt = new EDateField();
        txt.getDocument().setPattern(DateDocument.DEFAULT_YEAR$MONTH_PATTERN);
        txt.setDate(new Date());
        txt.setColumns(12);
        return txt;
    }

    public static EDateField createYearField() {
        EDateField txt = new EDateField();
        txt.getDocument().setPattern(DateDocument.DEFAULT_YEAR_PATTERN);
        txt.setDate(new Date());
        txt.setColumns(12);
        return txt;
    }

    public static EQueryScope createDateScope() {
        return SwingUtils.createDateScope(DateDocument.DEFAULT_DATE_PATTERN);
    }

    public static EQueryScope createDateScope(String pattern) {
        return SwingUtils.createDateScope(pattern, new GregorianCalendar(), 1);
    }

    public static EQueryScope createDateScope(String pattern, GregorianCalendar gc, int dayOfMonth) {
        GregorianCalendar gcStart = (GregorianCalendar)gc.clone();
        gcStart.set(5, dayOfMonth);
        return SwingUtils.createDateScope(pattern, gcStart, gc);
    }

    public static EQueryScope createDateScope(String pattern, GregorianCalendar gc, int calendarField, int delta) {
        GregorianCalendar gcStart = (GregorianCalendar)gc.clone();
        gcStart.add(calendarField, -delta);
        return SwingUtils.createDateScope(pattern, gcStart, gc);
    }

    public static EQueryScope createDateScope(String pattern, GregorianCalendar gcStart, GregorianCalendar gcEnd) {
        EDateField beginDate = SwingUtils.createDateField(pattern);
        EDateField endDate = SwingUtils.createDateField(pattern);
        EQueryScope ripDate = new EQueryScope(beginDate, endDate);
        ripDate.setDefaultOperation("\u2265");
        beginDate.setDate(gcStart.getTime());
        endDate.setDate(gcEnd.getTime());
        return ripDate;
    }

    public static EQueryScope getMonthScope() {
        GregorianCalendar gc = new GregorianCalendar();
        return SwingUtils.getMonthScope(gc);
    }

    public static EQueryScope getMonthScope(GregorianCalendar gc) {
        GregorianCalendar gcStart = (GregorianCalendar)gc.clone();
        gcStart.set(2, 0);
        return SwingUtils.getMonthScope(gcStart, gc);
    }

    public static EQueryScope getMonthScope(GregorianCalendar gc, int decrease) {
        GregorianCalendar gcStart = (GregorianCalendar)gc.clone();
        gcStart.add(2, -decrease);
        return SwingUtils.getMonthScope(gcStart, gc);
    }

    public static EQueryScope getMonthScope(GregorianCalendar gcStart, GregorianCalendar gcEnd) {
        EDateField beginDate = new EDateField(DateDocument.DEFAULT_YEAR$MONTH_PATTERN);
        EDateField endDate = new EDateField(DateDocument.DEFAULT_YEAR$MONTH_PATTERN);
        EQueryScope ripDate = new EQueryScope(beginDate, endDate);
        ripDate.setDefaultOperation("\u2265");
        endDate.setDate(gcEnd.getTime());
        beginDate.setDate(gcStart.getTime());
        return ripDate;
    }

    public static EQueryScope getYearScope() {
        return SwingUtils.getYearScope(1);
    }

    public static EQueryScope getYearScope(int decrease) {
        GregorianCalendar gc = new GregorianCalendar();
        return SwingUtils.getYearScope(gc, decrease);
    }

    public static EQueryScope getYearScope(GregorianCalendar gc, int decrease) {
        EDateField beginDate = new EDateField(DateDocument.DEFAULT_YEAR_PATTERN);
        EDateField endDate = new EDateField(DateDocument.DEFAULT_YEAR_PATTERN);
        EQueryScope ripDate = new EQueryScope(beginDate, endDate);
        ripDate.setDefaultOperation("\u2265");
        endDate.setDate(gc.getTime());
        gc.add(1, -decrease);
        beginDate.setDate(gc.getTime());
        return ripDate;
    }

    public static void bindDateField(final EDateField srcDateField, final EDateField destDateField, final int depth, final int calendarField) {
        srcDateField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                SwingUtils.setDateField(srcDateField, destDateField, depth, calendarField);
            }
        });
    }

    public static void setDateField(EDateField srcDateField, EDateField destDateField, int depth, int calendarField) {
        destDateField.setText(CommonUtils.getDateDepthed(srcDateField.getText(), depth, calendarField));
    }

    public static void reverseTableRow(JTable t, DefaultTableModel tm) {
        int left = 0;
        int right = t.getRowCount() - 1;
        while (left < right) {
            SwingUtils.swapTableRow(tm, left, right);
            ++left;
            --right;
        }
    }

    public static void swapTableRow(DefaultTableModel model, int rowIndexA, int rowIndexB) {
        SwingUtils.swapTableRow(model, rowIndexA, rowIndexB, null);
    }

    public static void swapTableRow(DefaultTableModel model, int rowIndexA, int rowIndexB, int[] oldSelectedRows) {
        Vector<Vector> dataVector = model.getDataVector();
        Vector temp = dataVector.get(rowIndexA);
        dataVector.setElementAt(dataVector.get(rowIndexB), rowIndexA);
        dataVector.setElementAt(temp, rowIndexB);
        if (oldSelectedRows == null || oldSelectedRows.length == 0) {
            return;
        }
        int si = Arrays.binarySearch(oldSelectedRows, rowIndexA);
        int sj = Arrays.binarySearch(oldSelectedRows, rowIndexB);
        if (si >= 0 && sj < 0) {
            oldSelectedRows[si] = rowIndexB;
            Arrays.sort(oldSelectedRows);
        } else if (sj >= 0 && si < 0) {
            oldSelectedRows[sj] = rowIndexA;
            Arrays.sort(oldSelectedRows);
        }
    }

    public static void addUndoRedo(final JTextComponent txt) {
        if (txt == null) {
            return;
        }
        final UndoManager undo = new UndoManager();
        txt.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        txt.getActionMap().put("Undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo() && txt.isFocusOwner() && txt.isEnabled() && txt.isEditable()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        txt.getInputMap().put(KeyStroke.getKeyStroke(90, 2), "Undo");
        txt.getActionMap().put("Redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo() && txt.isFocusOwner() && txt.isEnabled() && txt.isEditable()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        txt.getInputMap().put(KeyStroke.getKeyStroke(89, 2), "Redo");
    }

    public static void setComponentValue(Component com, Object value) {
        if (com instanceof JTextComponent) {
            ((JTextComponent)com).setText("" + value);
        } else if (com instanceof JComboBox) {
            ((JComboBox)com).setSelectedItem(value);
        } else if (com instanceof JList) {
            ((JList)com).setSelectedValue(value, true);
        } else {
            SimpleLogger.w("\u6709\u4e00\u4e2a\u63a7\u4ef6\u4e0d\u652f\u6301\uff0c\u76ee\u524d\u53ea\u652f\u6301\u5bf9JTextComponent\u3001JComboBox\u3001JList\u53ca\u5176\u5b50\u7c7b\u7684\u503c\u8bbe\u5b9a.");
        }
    }

    public static void clearComponent(Component[] childs) {
        int i = childs.length - 1;
        while (i >= 0) {
            if (childs[i] instanceof JTextComponent) {
                ((JTextComponent)childs[i]).setText(null);
            } else if (childs[i] instanceof JComboBox) {
                ((JComboBox)childs[i]).setSelectedIndex(-1);
            } else if (childs[i] instanceof JList) {
                ((JList)childs[i]).setSelectedIndex(-1);
            } else {
                SimpleLogger.w("clearComponent\u4e2d\u6709\u4e00\u4e2a\u63a7\u4ef6\u4e0d\u652f\u6301.");
            }
            --i;
        }
    }

    public static String truncString(String str, Font font, float maxPixelWidth) {
        return SwingUtils.truncString(str, Toolkit.getDefaultToolkit().getFontMetrics(font), maxPixelWidth);
    }

    public static String truncString(String str, FontMetrics fm, float maxPixelWidth) {
        if (maxPixelWidth <= 0.0f) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff0cmaxPixelWidth = " + maxPixelWidth);
        }
        if (str == null || str.getBytes().length == 2 && str.length() == 1 || str.getBytes().length == 1 && str.length() == 1) {
            return str;
        }
        float firstCharLen = fm.charWidth(str.charAt(0));
        if (firstCharLen >= maxPixelWidth || firstCharLen <= 0.0f) {
            return str.substring(0, 1);
        }
        int resultSize = (int)CommonUtils.getScaledDoubleValue(maxPixelWidth / firstCharLen, 0);
        return str.length() <= resultSize ? str : str.substring(0, resultSize);
    }

    public static int getLinesWithWidth(Font font, String str, int width, List subStringList) {
        if (str == null) {
            return 0;
        }
        String subStr = SwingUtils.truncString(str, font, (float)width);
        int end = subStr.length();
        if (end < str.length()) {
            subStringList.add(str.substring(0, end));
            return 1 + SwingUtils.getLinesWithWidth(font, str.substring(end), width, subStringList);
        }
        subStringList.add(str);
        return 1;
    }

    public static String[] getLinesWithWidth(FontMetrics fm, String str, int width) {
        if (str == null) {
            return new String[0];
        }
        String subStr = SwingUtils.truncString(str, fm, (float)width);
        int end = subStr.length();
        if (end < str.length()) {
            String[] next = SwingUtils.getLinesWithWidth(fm, str.substring(end), width);
            int len = next.length;
            String[] ret = new String[len + 1];
            System.arraycopy(next, 0, ret, 1, len);
            ret[0] = subStr;
            return ret;
        }
        return new String[]{str};
    }

    public static String[] getAllAvaliableFontNames() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public static int getStrPixWidth(FontMetrics fm, String str) {
        return fm.stringWidth(String.valueOf(str));
    }

    public static int getStrPixWidth(Font f, String str) {
        return SwingUtils.getStrPixWidth(Toolkit.getDefaultToolkit().getFontMetrics(f), str);
    }

    public static int getStrPixHeight(FontMetrics fm) {
        return fm.getHeight();
    }

    public static int getStrPixHeight(Font f) {
        return SwingUtils.getStrPixHeight(Toolkit.getDefaultToolkit().getFontMetrics(f));
    }

    public static int getStrCenterDrawY(int areaHeight, Font f) {
        return SwingUtils.getStrCenterDrawY(areaHeight, Toolkit.getDefaultToolkit().getFontMetrics(f));
    }

    public static int getStrCenterDrawY(int areaHeight, FontMetrics fm) {
        return (areaHeight - (fm.getAscent() + fm.getDescent())) / 2 + fm.getAscent();
    }

    public static Rectangle getScreenBounds() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static int getScreenWidth() {
        return (int)SwingUtils.getScreenSize().getWidth();
    }

    public static int getScreenHeight() {
        return (int)SwingUtils.getScreenSize().getHeight();
    }

    public static Dimension getSizeWithScreen(double xd, double yd) {
        Dimension d = SwingUtils.getScreenSize();
        double width = d.getWidth() * xd;
        double height = d.getHeight() * yd;
        d = new Dimension((int)width, (int)height);
        return d;
    }

    public static JInternalFrame getSelectedFrame(JDesktopPane desktop) {
        JInternalFrame[] frames = desktop.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isSelected()) {
                return frames[i];
            }
            ++i;
        }
        return null;
    }

    public static void setOpaqeChileds(JComponent com, boolean opaqe) {
        if (com != null) {
            Component[] chiles;
            Component[] componentArray = chiles = com.getComponents();
            int n = chiles.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (child instanceof JComponent) {
                    ((JComponent)child).setOpaque(opaqe);
                }
                ++n2;
            }
        }
    }

    public static void componentsDisabled(Component[] comps) {
        int i = 0;
        while (i < comps.length) {
            if (!(comps[i] instanceof JLabel)) {
                if (comps[i] instanceof Container) {
                    SwingUtils.componentsDisabled(((Container)comps[i]).getComponents());
                } else {
                    comps[i].setEnabled(false);
                }
            }
            ++i;
        }
    }

    public static JButton createTransparentButton(ImageIcon icon, ImageIcon roverIcon, ImageIcon pressedIcon) {
        return SwingUtils.createTransparentButton(icon, roverIcon, pressedIcon, null);
    }

    public static JButton createTransparentButton(ImageIcon icon, ImageIcon roverIcon, ImageIcon pressedIcon, ImageIcon disableIcon) {
        JButton button = new JButton();
        button.setBorder(null);
        button.setMargin(null);
        button.setOpaque(false);
        button.setIcon(icon);
        button.setRolloverEnabled(true);
        button.setRolloverIcon(roverIcon);
        button.setPressedIcon(pressedIcon);
        if (disableIcon != null) {
            button.setDisabledIcon(disableIcon);
        }
        button.setContentAreaFilled(false);
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        return button;
    }

    public static TexturePaint createTexturePaint(Image image) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return new TexturePaint(bi, new Rectangle(0, 0, imageWidth, imageHeight));
    }

    public static JComponent addHandCursorStyle(final JComponent com) {
        com.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                com.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                com.setCursor(Cursor.getDefaultCursor());
            }
        });
        return com;
    }

    public static Vector getComponentFromJTextPane(JTextPane pane) {
        Vector<Component> ret = new Vector<Component>();
        StyledDocument st = pane.getStyledDocument();
        Element root = st.getDefaultRootElement();
        int i = 0;
        while (i < root.getElementCount()) {
            Element paragraph = root.getElement(i);
            int j = 0;
            while (j < paragraph.getElementCount()) {
                Element element = paragraph.getElement(j);
                Component com = StyleConstants.getComponent(element.getAttributes());
                if (com != null) {
                    ret.add(com);
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static void showWindow(Window w) {
        WindowEfect.show(w);
    }

    public static void unshowWindow(Window w, boolean needClose) {
        WindowEfect.unshow(w, needClose);
    }

    public static void centerTheWindow(Window f) {
        f.setLocationRelativeTo(null);
    }

    public static void setAutoChangeCursor(final Component com, final Cursor cur) {
        com.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                com.setCursor(cur);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                com.setCursor(new Cursor(0));
            }
        });
    }

    public static ImageIcon getOverprintPic(ImageIcon iconBottom, ImageIcon iconTop, boolean isCenterDraw) {
        try {
            int bfImgWidth = iconBottom.getIconWidth();
            int bfImgHeight = iconBottom.getIconHeight();
            if (iconTop.getIconWidth() > iconBottom.getIconWidth()) {
                bfImgWidth = iconTop.getIconWidth();
            }
            if (iconTop.getIconHeight() > iconBottom.getIconHeight()) {
                bfImgHeight = iconTop.getIconHeight();
            }
            BufferedImage bfImg = new BufferedImage(bfImgWidth, bfImgHeight, 2);
            Graphics2D g = (Graphics2D)bfImg.getGraphics();
            SwingUtils.setAntiAliasing(g, true);
            g.drawImage(iconBottom.getImage(), 0, 0, iconBottom.getIconHeight(), iconBottom.getIconWidth(), iconBottom.getImageObserver());
            if (!isCenterDraw) {
                g.drawImage(iconTop.getImage(), bfImgWidth - iconTop.getIconWidth(), bfImgHeight - iconTop.getIconHeight(), iconTop.getIconWidth(), iconTop.getIconHeight(), iconTop.getImageObserver());
            } else {
                g.drawImage(iconTop.getImage(), (bfImgWidth - iconTop.getIconWidth()) / 2, (bfImgHeight - iconTop.getIconHeight()) / 2, iconTop.getIconWidth(), iconTop.getIconHeight(), iconTop.getImageObserver());
            }
            iconBottom = null;
            iconTop = null;
            g = null;
            return new ImageIcon(bfImg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void append(Color c, String s, JTextPane p) {
        try {
            SimpleAttributeSet sa = new SimpleAttributeSet();
            StyleConstants.setForeground(sa, c);
            int len = p.getDocument().getLength();
            p.getDocument().insertString(len, s, sa);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AbstractButton createIconButton(Action ac) {
        JButton b = new JButton(ac);
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        SwingUtils.addHandCursorStyle(b);
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    public static JButton getPicsButton(String txt, Icon ico) {
        return SwingUtils.getPicsButton(txt, ico, null);
    }

    public static JButton getPicsButton(String txt, Icon ico, Action a) {
        JButton b = new JButton(txt);
        if (a != null) {
            b.setAction(a);
        }
        if (ico != null) {
            b.setIcon(ico);
        }
        return (JButton)SwingUtils.getPicsButton(b);
    }

    public static AbstractButton getPicsButton(AbstractButton b) {
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        b.setRequestFocusEnabled(false);
        b.setFocusable(false);
        return b;
    }

    public static JButton getToolBarButton(Action ac) {
        JButton b = new JButton(ac){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        b.setIconTextGap(-2);
        return b;
    }

    public static JButton getToolBarButton(String titile, Icon i) {
        JButton b = new JButton(titile, i){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        b.setIconTextGap(-2);
        return b;
    }

    public static Point getPoint(Point originalP, int deltaX, int deltaY) {
        return new Point(originalP.x + deltaX, originalP.y + deltaY);
    }

    public static JComboBox optimizeCombox(JComboBox com) {
        com.setSelectedIndex(com.getItemCount() == 1 ? 0 : -1);
        return com;
    }

    public static void setAntiAliasing(Graphics2D g2, boolean antiAliasing) {
        if (antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public static void setTextAntiAliasing(Graphics2D g2, boolean antiAliasing) {
        if (antiAliasing) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static void minimizeColumn(JTable t, int colIndx) {
        if (colIndx >= 0) {
            SwingUtils.setColumnWidth(t, colIndx, 1);
        }
    }

    public static void setColumnVisible(JTable t, int colIndx, boolean visible) {
        if (colIndx >= 0) {
            if (visible) {
                SwingUtils.selfAdaptingColumnWidth(t, colIndx);
            } else {
                SwingUtils.setColumnWidth(t, colIndx, 0);
            }
        }
    }

    public static void setColumnVisible(JTable t, String fieldName, boolean visible) {
        int colIndx = SwingUtils.columnIndex(t, fieldName);
        SwingUtils.setColumnVisible(t, colIndx, visible);
    }

    public static void setColumnWidth(JTable t, int col, int w) {
        TableColumn tc = t.getColumnModel().getColumn(col);
        if (w < 0) {
            w = t.getFontMetrics(t.getFont()).stringWidth(t.getColumnName(col)) + t.getColumnModel().getColumnMargin() * 2;
        }
        tc.setPreferredWidth(w);
        if (w == 0) {
            tc.setMinWidth(0);
            tc.setMaxWidth(0);
            tc.setResizable(false);
        }
    }

    public static int columnIndex(JTable t, String columnFieldName) {
        try {
            return t.getColumnModel().getColumnIndex(columnFieldName);
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public static void selfAdaptingColumnWidth(JTable table) {
        try {
            int columnCnt = table.getColumnCount();
            int i = 0;
            while (i < columnCnt) {
                SwingUtils.selfAdaptingColumnWidth(table, i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void selfAdaptingColumnWidth(JTable table, int col) {
        SwingUtils.selfAdaptingColumnWidth(table, col, 0, table.getRowCount());
    }

    public static void selfAdaptingColumnWidth(JTable table, int col, int from, int to) {
        Border cb;
        TableColumn tc = table.getColumnModel().getColumn(col);
        if (tc.getMinWidth() == 0) {
            return;
        }
        TableCellRenderer tcr = tc.getCellRenderer();
        tcr = tcr != null ? tcr : table.getDefaultRenderer(table.getColumnClass(col));
        int max = 50;
        if (table.getTableHeader().getDefaultRenderer() != null && table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, table.getColumnName(col), false, false, 0, col) != null) {
            max = table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)table, (Object)table.getColumnName((int)col), (boolean)false, (boolean)false, (int)0, (int)col).getPreferredSize().width;
        }
        if ((cb = UIManager.getBorder("TableHeader.cellBorder")) != null) {
            max += cb.getBorderInsets((Component)table).left + cb.getBorderInsets((Component)table).right;
        }
        int margin = table.getColumnModel().getColumnMargin();
        int cellMax = max;
        Component rc = null;
        int i = from;
        while (i < to) {
            Object value = table.getValueAt(i, col);
            if (value != null) {
                if (rc != null) {
                    rc.invalidate();
                }
                rc = tcr.getTableCellRendererComponent(table, value, false, false, i, col);
                int temp = rc.getPreferredSize().width + margin;
                if (temp > cellMax) {
                    cellMax = temp;
                }
            }
            ++i;
        }
        if (cellMax > max) {
            max = cellMax;
        }
        tc.setPreferredWidth(Math.min(max, 200));
        if (rc != null) {
            rc.invalidate();
        }
    }

    public static int[] getColWidths(TableColumnModel tcm) {
        Enumeration<TableColumn> vColumns = tcm.getColumns();
        int cNum = tcm.getColumnCount();
        int[] originalColWidth = new int[cNum];
        int i = 0;
        while (i < cNum) {
            TableColumn item = vColumns.nextElement();
            originalColWidth[i] = item.getWidth();
            ++i;
        }
        return originalColWidth;
    }

    public static int getColTotalWidth(TableColumnModel tcm) {
        int[] cols = SwingUtils.getColWidths(tcm);
        int colWidth = 0;
        int i = 0;
        while (i < cols.length) {
            colWidth += cols[i];
            ++i;
        }
        return colWidth;
    }

    public static void opentWin32FileOrDir(String absoluteFileOrDirPath) throws Exception {
        SwingUtils.processNativeCmd("rundll32 SHELL32.DLL,ShellExec_RunDLL " + absoluteFileOrDirPath);
    }

    public static Process processNativeCmd(String cmd) throws Exception {
        return Runtime.getRuntime().exec(cmd);
    }

    public static enum FileOprType {
        read,
        write;

    }
}

