/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.common.util.CommonUtils;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class RenderFactory {
    public static final Class CLASS_OBJECT = Object.class;
    public static final Class CLASS_NUMERIC = Number.class;
    public static final Class CLASS_DOUBLE = Double.class;
    public static final Class CLASS_DATE = Date.class;
    public static final Class CLASS_ICON = Icon.class;
    public static final Class CLASS_BOOLEAN = Boolean.class;

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block7: {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    super.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                try {
                    this.setSelected(value != null && (Boolean)value != false);
                }
                catch (Exception e) {
                    if (value.equals("1")) {
                        this.setSelected(true);
                    }
                    if (!value.equals("0") && !CommonUtils.isStringEmpty((String)value)) break block7;
                    this.setSelected(false);
                }
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class GenericRenderer
    extends DefaultTableCellRenderer.UIResource {
        public GenericRenderer() {
            this.setHorizontalAlignment(2);
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer.UIResource {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class NumberRenderer
    extends DefaultTableCellRenderer.UIResource {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }
}

