/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.util;

import com.eva.epc.widget.border.EBorderFactory;
import com.eva.epc.widget.border.ERoundBorder;
import com.eva.epc.widget.res.IconFactory;
import com.eva.epc.widget.util.ColorHelper;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;

@Deprecated
public final class MustInputHelper {
    private Vector<JComponent> acionComs = new Vector();
    private Vector<JComponent> responseComs = new Vector();
    private ArrayList<ExtraVerifier> extraVerifiers = null;
    private DocumentListener listenerForTextCom;
    private ListChecker listenerFormListCom;
    private TreeSelectionListener listenerForTreeCom;
    public static Color mustInputDefaultBgColor = ColorHelper.LIGHT_YELLOW1;
    private boolean needChangeBgColor = false;
    private BorderPromptType borderPromptType = BorderPromptType.imageBorderPrompt;

    public MustInputHelper() {
    }

    public MustInputHelper(JComponent[] actionComs, JComponent responseComs) {
        this(actionComs, new JComponent[]{responseComs});
    }

    public MustInputHelper(JComponent[] actionComs, JComponent[] responseComs) {
        this(actionComs, responseComs, BorderPromptType.imageBorderPrompt, false);
    }

    public MustInputHelper(JComponent[] actionComs, JComponent[] responseComs, BorderPromptType borderPromptType, boolean changeBackgroundColor) {
        this.borderPromptType = borderPromptType;
        this.needChangeBgColor = changeBackgroundColor;
        if (actionComs != null) {
            int i = 0;
            while (i < actionComs.length) {
                JComponent c = actionComs[i];
                if (c != null) {
                    this.addActionCom(c);
                }
                ++i;
            }
        }
        if (responseComs != null) {
            int i = 0;
            while (i < responseComs.length) {
                if (responseComs[i] != null) {
                    this.responseComs.add(responseComs[i]);
                }
                ++i;
            }
        }
        this.isPass();
    }

    protected ListChecker getListenerForListCom() {
        if (this.listenerFormListCom == null) {
            this.listenerFormListCom = new ListChecker();
        }
        return this.listenerFormListCom;
    }

    protected DocumentListener getListenerForTextCom() {
        if (this.listenerForTextCom == null) {
            this.listenerForTextCom = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    MustInputHelper.this.isPass();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    MustInputHelper.this.isPass();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        return this.listenerForTextCom;
    }

    protected TreeSelectionListener getListenerForTreeCom() {
        if (this.listenerForTreeCom == null) {
            this.listenerForTreeCom = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    MustInputHelper.this.isPass();
                }
            };
        }
        return this.listenerForTreeCom;
    }

    public MustInputHelper addActionCom(JComponent actionCom) {
        if (!this.acionComs.contains(actionCom)) {
            if (this.needChangeBgColor) {
                actionCom.setBackground(mustInputDefaultBgColor);
            }
            if (this.borderPromptType == BorderPromptType.stringBorderPrompt) {
                actionCom.setBorder(MustInputHelper.createDefaultMustInputStringBorder());
            } else if (this.borderPromptType == BorderPromptType.imageBorderPrompt) {
                actionCom.setBorder(MustInputHelper.createDefaultMustInputImageBorder());
            } else if (this.borderPromptType == BorderPromptType.none) {
                // empty if block
            }
            if (actionCom instanceof JTextComponent) {
                ((JTextComponent)actionCom).getDocument().addDocumentListener(this.getListenerForTextCom());
            } else if (actionCom instanceof JComboBox) {
                ((JComboBox)actionCom).addItemListener(this.getListenerForListCom());
                actionCom.addPropertyChangeListener("model", this.getListenerForListCom());
            } else if (actionCom instanceof JList) {
                ((JList)actionCom).getSelectionModel().addListSelectionListener(this.getListenerForListCom());
            } else if (actionCom instanceof JTree) {
                ((JTree)actionCom).addTreeSelectionListener(this.getListenerForTreeCom());
            }
            this.acionComs.add(actionCom);
            this.isPass();
        }
        return this;
    }

    public MustInputHelper cancelActionCom(JComponent actionCom) {
        if (actionCom != null && this.acionComs.indexOf(actionCom) != -1) {
            this.acionComs.remove(actionCom);
            if (actionCom instanceof JTextComponent) {
                actionCom.setBackground(UIManager.getColor("TextField.background"));
                actionCom.setBorder(UIManager.getBorder("TextField.border"));
                ((JTextComponent)actionCom).getDocument().removeDocumentListener(this.getListenerForTextCom());
            } else if (actionCom instanceof JComboBox) {
                ((JComboBox)actionCom).getModel().removeListDataListener(this.getListenerForListCom());
                actionCom.removePropertyChangeListener("model", this.getListenerForListCom());
                actionCom.setBorder(UIManager.getBorder("ComboBox.border"));
            } else if (actionCom instanceof JList) {
                ((JList)actionCom).getSelectionModel().removeListSelectionListener(this.getListenerForListCom());
            } else if (actionCom instanceof JTree) {
                ((JTree)actionCom).removeTreeSelectionListener(this.getListenerForTreeCom());
            }
            this.isPass();
        }
        return this;
    }

    public MustInputHelper addResponseCom(JComponent responseCom) {
        if (responseCom != null && this.responseComs.indexOf(responseCom) == -1) {
            this.responseComs.add(responseCom);
            this.isPass();
        }
        return this;
    }

    public void cancelResponseCom(JComponent responseCom) {
        this.responseComs.remove(responseCom);
    }

    public void removeExtraVerifier(ExtraVerifier extraVerifier) {
        if (this.extraVerifiers != null) {
            this.extraVerifiers.remove(extraVerifier);
        }
    }

    public void removeAllExtraVerifiers() {
        this.extraVerifiers = null;
    }

    public void removeAllActionComs() {
        while (this.acionComs.size() > 0) {
            this.cancelActionCom(this.acionComs.get(0));
        }
    }

    public void removeAllResponseComs() {
        while (this.responseComs.size() > 0) {
            this.cancelResponseCom(this.responseComs.get(0));
        }
    }

    private void enabledResponseComs(boolean enable) {
        int i = 0;
        while (i < this.responseComs.size()) {
            this.responseComs.get(i).setEnabled(enable);
            ++i;
        }
    }

    public boolean isPass() {
        if (this.responseComs.size() == 0) {
            return true;
        }
        boolean ok = true;
        for (JComponent c : this.acionComs) {
            if (!(c instanceof JTextComponent && ((JTextComponent)c).getText().trim().length() == 0 || c.getInputVerifier() != null && !c.getInputVerifier().verify(c) || c instanceof JComboBox && (((JComboBox)c).getSelectedItem() == null || ((JComboBox)c).getSelectedItem().toString().trim().equals("")) || c instanceof JList && ((JList)c).getSelectedIndex() < 0) && (!(c instanceof JTree) || ((JTree)c).getSelectionPath() != null)) continue;
            ok = false;
            break;
        }
        if (ok) {
            ok = this.isExtraPass();
        }
        this.enabledResponseComs(ok);
        return ok;
    }

    private boolean isExtraPass() {
        if (this.extraVerifiers != null) {
            for (ExtraVerifier ev : this.extraVerifiers) {
                if (ev.isPass()) continue;
                return false;
            }
        }
        return true;
    }

    public MustInputHelper addExtraVerifier(ExtraVerifier extraVerifier) {
        if (extraVerifier != null) {
            if (this.extraVerifiers == null) {
                this.extraVerifiers = new ArrayList();
            } else if (this.extraVerifiers.indexOf(extraVerifier) != -1) {
                return this;
            }
            this.extraVerifiers.add(extraVerifier);
            this.isPass();
        }
        return this;
    }

    public BorderPromptType getBorderPromptType() {
        return this.borderPromptType;
    }

    public void setBorderPromptType(BorderPromptType borderPromptType) {
        this.borderPromptType = borderPromptType;
    }

    public boolean isNeedChangeBgColor() {
        return this.needChangeBgColor;
    }

    public void setNeedChangeBgColor(boolean needChangeBgColor) {
        this.needChangeBgColor = needChangeBgColor;
    }

    public static Border createDefaultMustInputImageBorder() {
        ERoundBorder bb = EBorderFactory.createRoundRecBorder(10).setLineColor(new Color(0, 0, 0, 0));
        bb.setRightCornerIcon(IconFactory.getInstance().getWarnSmallIcon());
        return bb;
    }

    public static Border createDefaultMustInputStringBorder() {
        return MustInputHelper.createDefaultMustInputStringBorder("*");
    }

    public static Border createDefaultMustInputStringBorder(String str) {
        ERoundBorder bb = EBorderFactory.createRoundRecBorder(10).setLineColor(new Color(0, 0, 0, 0));
        bb.setRightCornerStr(str);
        bb.setRightCornerStrColorBingCom(true);
        return bb;
    }

    public static enum BorderPromptType {
        stringBorderPrompt,
        imageBorderPrompt,
        none;

    }

    public static interface ExtraVerifier {
        public boolean isPass();
    }

    private class ListChecker
    implements ListDataListener,
    ListSelectionListener,
    PropertyChangeListener,
    ItemListener {
        private ListChecker() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ListModel dm = (ListModel)evt.getOldValue();
            if (dm != null) {
                dm.removeListDataListener(MustInputHelper.this.getListenerForListCom());
            }
            ((ListModel)evt.getOldValue()).addListDataListener(MustInputHelper.this.getListenerForListCom());
            MustInputHelper.this.isPass();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            MustInputHelper.this.isPass();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (((ComboBoxModel)e.getSource()).getSize() < 1) {
                MustInputHelper.this.isPass();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MustInputHelper.this.isPass();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MustInputHelper.this.isPass();
        }
    }
}

