/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.text;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public final class TextFocusAction
extends TextAction {
    public static final TextFocusAction SINGLETON = new TextFocusAction();
    public static final KeyStroke MODE_FOCUS_KEY_STROKE = KeyStroke.getKeyStroke(10, 0);

    private TextFocusAction() {
        super("transferFocus");
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component next;
        JTextComponent target = this.getFocusedComponent();
        if (target instanceof JTextField && ((ActionListener[])((JTextField)target).getListeners(ActionListener.class)).length > 0) {
            ((JTextField)target).postActionEvent();
        }
        if (e.getSource() instanceof JComponent && (next = ((JComponent)e.getSource()).getNextFocusableComponent()) != null) {
            next.requestFocus();
            return;
        }
        ((Component)e.getSource()).transferFocus();
    }

    @Override
    public boolean isEnabled() {
        return this.getFocusedComponent() instanceof JTextField;
    }

    public static void installTextActionMap(String ... uiClassNames) {
        String[] stringArray = uiClassNames;
        int n = uiClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String uiClass = stringArray[n2];
            TextFocusAction.installActionMap(uiClass);
            ++n2;
        }
    }

    private static Keymap installActionMap(String uiClassKey) {
        String uiClass = UIManager.getString(uiClassKey);
        if (uiClass == null) {
            return null;
        }
        int lastDot = uiClass.lastIndexOf(46);
        if (lastDot != -1) {
            uiClass = uiClass.substring(lastDot + 1);
        }
        Keymap map = JTextComponent.addKeymap(uiClass, JTextComponent.getKeymap("default"));
        map.addActionForKeyStroke(MODE_FOCUS_KEY_STROKE, SINGLETON);
        return map;
    }
}

