/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.text;

import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DateDocument
extends PlainDocument {
    public static char DEFAULT_DATE_SEPARATOR = (char)45;
    public static String DEFAULT_YEAR_PATTERN = "yyyy";
    public static String DEFAULT_YEAR$MONTH_PATTERN = "yyyy" + DEFAULT_DATE_SEPARATOR + "MM";
    public static String DEFAULT_DATE_PATTERN = "yyyy" + DEFAULT_DATE_SEPARATOR + "MM" + DEFAULT_DATE_SEPARATOR + "dd";
    public static String DEFAULT_LONG_DATE_PATTERN = "yyyy" + DEFAULT_DATE_SEPARATOR + "MM" + DEFAULT_DATE_SEPARATOR + "dd HH:mm";
    public static String DEFAULT_FULL_DATE_PATTERN = "yyyy" + DEFAULT_DATE_SEPARATOR + "MM" + DEFAULT_DATE_SEPARATOR + "dd HH:mm:ss";
    public static final String YEAR_MASK = "yyyy";
    public static final String MONTH_MASK = "MM";
    public static final String DAY_MASK = "dd";
    public static final String HOUR_MASK = "HH";
    public static final String MINITUE_MASK = "mm";
    public static final String SECOND_MASK = "ss";
    private JTextComponent dependentTextField = null;
    private SimpleDateFormat theDateFormat = null;

    public DateDocument(JTextComponent dependentTextField) {
        this(DEFAULT_DATE_PATTERN, dependentTextField);
    }

    public DateDocument(String pattern, JTextComponent dependentTextField) {
        this.theDateFormat = new SimpleDateFormat(this.getStandardFormat(pattern));
        this.dependentTextField = dependentTextField;
    }

    public void setPattern(String newPattern) {
        this.theDateFormat.applyPattern(this.getStandardFormat(newPattern));
    }

    private String getStandardFormat(String originalPattern) {
        originalPattern = originalPattern == null ? DEFAULT_DATE_PATTERN : originalPattern;
        StringBuffer bf = new StringBuffer(originalPattern);
        int indx = -1;
        indx = originalPattern.indexOf(MONTH_MASK.charAt(0));
        if (indx != -1 && originalPattern.indexOf(MONTH_MASK) == -1) {
            bf.insert(indx, MONTH_MASK.charAt(0));
        }
        if ((indx = originalPattern.indexOf(DAY_MASK.charAt(0))) != -1 && originalPattern.indexOf(DAY_MASK) == -1) {
            bf.insert(indx, DAY_MASK.charAt(0));
        }
        if ((indx = originalPattern.indexOf(HOUR_MASK.charAt(0))) != -1 && originalPattern.indexOf(HOUR_MASK) == -1) {
            bf.insert(indx, HOUR_MASK.charAt(0));
        }
        return bf.toString();
    }

    public String getPattern() {
        return this.theDateFormat.toPattern();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (offs > 0 && this.getLength() == offs) {
            this.dependentTextField.transferFocus();
            return;
        }
        strLen = 0;
        if (str == null || (strLen = (str = str.trim()).length()) < 1) {
            return;
        }
        num = str.charAt(0) - 48;
        if (strLen == 1 && (num < 0 || num > 9)) {
            return;
        }
        pattern = this.getPattern();
        fromNull = false;
        proposedResult = null;
        if (this.getLength() == 0) {
            fromNull = strLen == 1;
            try {
                if (strLen < pattern.length()) {
                    str = String.valueOf(str.substring(0, strLen)) + this.theDateFormat.format(new Date()).substring(strLen);
                }
                if (strLen <= pattern.length()) ** GOTO lbl45
                str = str.substring(0, pattern.length());
            }
            catch (Exception ex) {
                return;
            }
        } else {
            raw = this.getText(0, this.getLength());
            currentBuffer = new StringBuffer(raw);
            currentBuffer.replace(offs, offs + strLen, str);
            proposedResult = new String(currentBuffer);
            t = "";
            end = proposedResult.length() - strLen - offs;
            i = 0;
            while (i < end) {
                try {
                    this.theDateFormat.parse(proposedResult);
                    break;
                }
                catch (Exception e) {
                    t = raw.substring(offs, offs + i + strLen);
                    currentBuffer.replace(offs, offs + (String.valueOf(t) + str).length(), String.valueOf(t) + str);
                    proposedResult = currentBuffer.toString();
                    ++i;
                }
            }
            str = String.valueOf(t) + str;
        }
lbl45:
        // 4 sources

        strLen = str.length();
        if (this.isWrongNum(fromNull != false ? offs : offs + strLen - 1, num)) {
            return;
        }
        try {
            if (this.getLength() != 0) {
                super.remove(offs, strLen);
            }
            super.insertString(offs, str, a);
            if (fromNull) {
                this.dependentTextField.setCaretPosition(1);
            } else {
                this.dependentTextField.setCaretPosition(offs + strLen);
            }
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private boolean isWrongNum(int off, int num) throws BadLocationException {
        int before;
        int indx = -1;
        String pattern = this.theDateFormat.toPattern();
        String raw = this.getText(0, this.getLength());
        boolean comp = raw.length() >= off && off > 0;
        int n = before = comp ? raw.charAt(off - 1) - 48 : -1;
        return off == pattern.indexOf(YEAR_MASK) && (num == 0 || num >= 3) || off == (indx = pattern.indexOf(MONTH_MASK.charAt(0))) && num > 1 || comp && off - 1 == indx && indx != -1 && num > 2 && before > 0 || comp && off - 1 == indx && indx != -1 && num == 0 && before == 0 || off == (indx = pattern.indexOf(DAY_MASK.charAt(0))) && num > 3 || comp && off - 1 == indx && indx != -1 && num > 1 && before > 2 || comp && off - 1 == indx && indx != -1 && num == 0 && before == 0 || off == (indx = pattern.indexOf(HOUR_MASK.charAt(0))) && num > 2 || comp && off - 1 == indx && indx != -1 && num > 3 && before > 1 || off == pattern.indexOf(MINITUE_MASK.charAt(0)) && num > 5 || off == pattern.indexOf(SECOND_MASK.charAt(0)) && num > 5;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (len == this.getLength()) {
            super.remove(0, this.getLength());
        } else {
            this.dependentTextField.setCaretPosition(offs);
        }
    }
}

