/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.widget.util.MustInputHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class TableMustSelectHelper {
    private JTable actionTable;
    private MustInputHelper mustInputHelper;
    private TableModelListener tableModelListenerImpl;
    private ListSelectionListener listSelectionListenerImpl;

    public TableMustSelectHelper(JTable theTable, JComponent[] responseComs) {
        if (theTable == null || responseComs == null) {
            throw new NullPointerException("\u8868\u683c\u6216responseComs\u4e0d\u53ef\u4e3anull.");
        }
        if (responseComs.length <= 0) {
            throw new IllegalArgumentException("responseComs.len\u957f\u5ea6<=0.");
        }
        this.listSelectionListenerImpl = new ListSelectionListenerImpl();
        theTable.getSelectionModel().addListSelectionListener(this.listSelectionListenerImpl);
        this.tableModelListenerImpl = new TableModelListenerImpl();
        theTable.getModel().addTableModelListener(this.tableModelListenerImpl);
        theTable.addPropertyChangeListener("selectionModel", new PropertyChangeListenerImpl());
        theTable.addPropertyChangeListener("model", new PropertyChangeListenerImpl());
        this.actionTable = theTable;
        this.mustInputHelper = new MustInputHelper(null, responseComs).addExtraVerifier(new MustInputHelper.ExtraVerifier(){

            @Override
            public boolean isPass() {
                return TableMustSelectHelper.this.actionTable.getSelectedRow() >= 0 && TableMustSelectHelper.this.actionTable.getSelectedRow() < TableMustSelectHelper.this.actionTable.getRowCount();
            }
        });
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                TableMustSelectHelper.this.mustInputHelper.isPass();
            }
        }
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object old = evt.getOldValue();
            if (old instanceof ListSelectionModel) {
                ((ListSelectionModel)old).removeListSelectionListener(TableMustSelectHelper.this.listSelectionListenerImpl);
                ((ListSelectionModel)evt.getNewValue()).addListSelectionListener(TableMustSelectHelper.this.listSelectionListenerImpl);
            } else if (old instanceof TableModel) {
                ((TableModel)old).removeTableModelListener(TableMustSelectHelper.this.tableModelListenerImpl);
                ((TableModel)evt.getNewValue()).addTableModelListener(TableMustSelectHelper.this.tableModelListenerImpl);
            }
            TableMustSelectHelper.this.mustInputHelper.isPass();
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private TableModelListenerImpl() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e != null && e.getType() == -1) {
                TableMustSelectHelper.this.actionTable.getSelectionModel().removeIndexInterval(e.getFirstRow(), e.getLastRow());
                if (TableMustSelectHelper.this.actionTable.getSelectedRow() == -1) {
                    TableMustSelectHelper.this.mustInputHelper.isPass();
                }
            }
        }
    }
}

