/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget.table;

import com.eva.epc.common.util.StringHelper;
import com.eva.epc.widget.ERender;
import com.eva.epc.widget.ETable;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import sun.swing.SwingUtilities2;

public class SortManager
extends MouseAdapter {
    private int currentSorttedColumn = -1;
    private int[] currentSelectedRows;
    private boolean autoDetectColumnClass = true;
    private ETable sortedTable = null;
    private SortOrder currentSortOrder = SortOrder.UNSORTED;
    public static List<SortOrder> SORT_ORDER_POLLING = Arrays.asList(SortOrder.UNSORTED, SortOrder.ASCENDING, SortOrder.DESCENDING);

    public SortManager(ETable sortedTable) {
        this.sortedTable = sortedTable;
    }

    public SortOrder decidedNextSortOrder(int theNextColumnWillBeOrder) {
        SortOrder nextOrder = SortOrder.UNSORTED;
        nextOrder = this.currentSorttedColumn != theNextColumnWillBeOrder ? SortOrder.ASCENDING : SORT_ORDER_POLLING.get((SORT_ORDER_POLLING.indexOf((Object)this.currentSortOrder) + 1) % SORT_ORDER_POLLING.size());
        return nextOrder;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && !this.sortedTable.isEditing()) {
            int col = this.sortedTable.getColumnModel().getColumnIndexAtX(e.getX());
            int c = this.getResizingColumn(col, e.getPoint());
            if (e.getClickCount() == 2 && c >= 0) {
                this.sortedTable.selfAdaptingColumnWidth(c);
            } else if (c < 0 && e.getClickCount() == 1) {
                this.sortNow(col);
            }
        }
    }

    private int getResizingColumn(int column, Point p) {
        if (column > -1) {
            Rectangle r = this.sortedTable.getTableHeader().getHeaderRect(column);
            r.grow(-3, 0);
            int midPoint = r.x + r.width / 2;
            return r.contains(p) ? -1 : (p.x < midPoint ? column - 1 : column);
        }
        return column;
    }

    public synchronized void sortNow(int col) {
        col = SwingUtilities2.convertColumnIndexToModel(this.sortedTable.getColumnModel(), col);
        if (col < 0 || col >= this.sortedTable.getColumnCount() || this.sortedTable.getRowCount() < 2) {
            return;
        }
        this.currentSortOrder = this.decidedNextSortOrder(col);
        this.sortedTable.setSorting(true);
        this.currentSelectedRows = this.sortedTable.getSelectedRows();
        Class columnClass = this.tryColumnClassForSort(col);
        if (this.currentSortOrder == SortOrder.ASCENDING) {
            this.newQuickSort(columnClass, this.sortedTable.getModel(), col, 0, this.sortedTable.getRowCount() - 1, this.currentSortOrder);
        } else if (this.currentSortOrder == SortOrder.DESCENDING) {
            SwingUtils.reverseTableRow(this.sortedTable, this.sortedTable.getModel());
            this.againInsertSort(columnClass, col, this.currentSortOrder);
        }
        this.currentSorttedColumn = col;
        this.sortedTable.getModel().fireTableDataChanged();
        if (this.currentSelectedRows.length > 0) {
            this.sortedTable.clearSelection();
            int i = 0;
            while (i < this.currentSelectedRows.length) {
                int row = this.currentSelectedRows[i];
                this.sortedTable.addRowSelectionInterval(row, row);
                ++i;
            }
        }
        this.currentSelectedRows = null;
    }

    private Class tryColumnClassForSort(int col) {
        boolean render = this.sortedTable.getColumnModel().getColumn(col).getCellRenderer() instanceof ERender;
        Class columnClass = this.sortedTable.getModel().getColumnClass(col);
        if (columnClass == null || columnClass == Object.class) {
            if (this.autoDetectColumnClass) {
                int row = -1;
                int rowCount = this.sortedTable.getModel().getRowCount();
                while (++row < rowCount) {
                    Object cellValue;
                    Object object = cellValue = render ? this.sortedTable.getShowValueAt(row, col) : this.sortedTable.getModel().getValueAt(row, col);
                    if (cellValue instanceof String) {
                        String strValue = (String)cellValue;
                        if (strValue.length() <= 0 || !StringHelper.isNaN(strValue)) continue;
                        columnClass = Object.class;
                        break;
                    }
                    if (cellValue != null) break;
                }
                if (row == rowCount) {
                    columnClass = Number.class;
                }
            }
            this.sortedTable.getModel().setColumnClass(col, columnClass == null ? Object.class : columnClass);
        }
        return columnClass;
    }

    private void againInsertSort(Class columnDataType, int col, SortOrder asc) {
        boolean render = this.sortedTable.getColumnModel().getColumn(col).getCellRenderer() instanceof ERender;
        int i = 1;
        int end = this.sortedTable.getRowCount();
        while (i < end) {
            if (!this.isLower(columnDataType, asc, render ? this.sortedTable.getShowValueAt(i - 1, col) : this.sortedTable.getModel().getValueAt(i - 1, col), render ? this.sortedTable.getShowValueAt(i, col) : this.sortedTable.getModel().getValueAt(i, col))) {
                int j = i - 1;
                --j;
                while (j >= 0) {
                    if (this.isLower(columnDataType, asc, render ? this.sortedTable.getShowValueAt(j, col) : this.sortedTable.getModel().getValueAt(j, col), render ? this.sortedTable.getShowValueAt(i, col) : this.sortedTable.getModel().getValueAt(i, col))) break;
                    --j;
                }
                this.sortedTable.getModel().moveRow(i, i, j + 1);
                --i;
            }
            ++i;
        }
    }

    private void newQuickSort(Class columnDataType, DefaultTableModel tm, int col, int rowIndexStart, int rowIndexEnd, SortOrder ascending) {
        int center = this.quickSortOneTimeImpl(columnDataType, tm, col, rowIndexStart, rowIndexEnd, ascending);
        if (rowIndexStart < center - 1) {
            this.newQuickSort(columnDataType, tm, col, rowIndexStart, center - 1, ascending);
        }
        if (++center < rowIndexEnd) {
            this.newQuickSort(columnDataType, tm, col, center, rowIndexEnd, ascending);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int quickSortOneTimeImpl(Class columnDataType, DefaultTableModel tm, int col, int startRowIndex, int endRowIndex, SortOrder sortOrder) {
        while (true) {
            boolean render = this.sortedTable.getColumnModel().getColumn(col).getCellRenderer() instanceof ERender;
            while (startRowIndex < endRowIndex && this.isLower(columnDataType, sortOrder, render ? this.sortedTable.getShowValueAt(startRowIndex, col) : tm.getValueAt(startRowIndex, col), render ? this.sortedTable.getShowValueAt(endRowIndex, col) : tm.getValueAt(endRowIndex, col))) {
                --endRowIndex;
            }
            if (startRowIndex >= endRowIndex) {
                return startRowIndex;
            }
            SwingUtils.swapTableRow(tm, startRowIndex++, endRowIndex);
            while (startRowIndex < endRowIndex && this.isLower(columnDataType, sortOrder, render ? this.sortedTable.getShowValueAt(startRowIndex, col) : tm.getValueAt(startRowIndex, col), render ? this.sortedTable.getShowValueAt(endRowIndex, col) : tm.getValueAt(endRowIndex, col))) {
                ++startRowIndex;
            }
            if (startRowIndex >= endRowIndex) {
                return endRowIndex;
            }
            SwingUtils.swapTableRow(tm, startRowIndex, endRowIndex--);
        }
    }

    public int compare(Class columnClass, Object a, Object b) {
        if (columnClass == Number.class || columnClass.getSuperclass() == Number.class) {
            return StringHelper.compareNum((String)a, (String)b);
        }
        return ((Comparable)a).compareTo(b);
    }

    private boolean isLower(Class columnClass, SortOrder sortOrder, Object small, Object big) {
        if (sortOrder != SortOrder.UNSORTED) {
            if (small != null && big != null) {
                int compareResult = small instanceof Boolean ? (small.equals(big) ? 0 : ((Boolean)small != false ? 1 : -1)) : this.compare(columnClass, small, big);
                return compareResult == 0 || !(sortOrder == SortOrder.ASCENDING ? compareResult >= 0 : compareResult <= 0);
            }
            return small == null && big == null ? true : (sortOrder == SortOrder.ASCENDING ? small == null : big == null);
        }
        return true;
    }

    public int getCurrentSorttedColumn() {
        return this.currentSorttedColumn;
    }

    public void setCurrentSorttedColumn(int currentSorttedColumn) {
        this.currentSorttedColumn = currentSorttedColumn;
    }

    public boolean isAutoDetectColumnClass() {
        return this.autoDetectColumnClass;
    }

    public void setAutoDetectColumnClass(boolean autoDetectColumnClass) {
        this.autoDetectColumnClass = autoDetectColumnClass;
    }

    public ETable getSortedTable() {
        return this.sortedTable;
    }

    public void setSortedTable(ETable sortedTable) {
        this.sortedTable = sortedTable;
    }

    public SortOrder getCurrentSortOrder() {
        return this.currentSortOrder;
    }

    public void setCurrentSortOrder(SortOrder currentSortOrder) {
        this.currentSortOrder = currentSortOrder;
    }
}

