/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.dto.IdName;
import com.eva.epc.common.util.SimpleLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeSelectBindPane
extends JPanel {
    public TreeSelectBindPane(JComponent centerContentCom, String treeDataSqlStr) {
        this.initGUI(this.createLeftTree(treeDataSqlStr), centerContentCom);
    }

    protected void initGUI(JTree leftTree, JComponent centerContentCom) {
        centerContentCom.setBorder(null);
        final JSplitPane sp = new JSplitPane(1, new JScrollPane(leftTree), centerContentCom);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
        sp.setBorder(BorderFactory.createEmptyBorder(2, 2, 20, 2));
        sp.setDividerLocation(100);
        leftTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.reDiviceDividerLocation();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.reDiviceDividerLocation();
            }

            private void reDiviceDividerLocation() {
                if (sp != null) {
                    sp.setDividerLocation(sp.getLeftComponent().getPreferredSize().width);
                }
            }
        });
    }

    protected JTree createLeftTree(String treeDataSqlStr) {
        SimpleLogger.d("treeDataSqlStr=" + treeDataSqlStr);
        Vector vec = this.getTreeModelData(treeDataSqlStr);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("\u76ee\u5f55\u6811");
        DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
        int i = 0;
        while (i < vec.size()) {
            Vector row = (Vector)vec.get(i);
            DefaultMutableTreeNode child = root;
            int j = 0;
            while (j < row.size()) {
                Object node = row.get(j);
                String name = (String)row.get(++j);
                SimpleLogger.d("node=" + node + " name=" + name);
                if (name.toString().length() > 0) {
                    child = this.addTreeNode(child, node, name.toString());
                }
                ++j;
            }
            ++i;
        }
        JTree tree = new JTree(root);
        tree.addTreeSelectionListener(new TreeSelectionListenerImpl());
        tree.setCellRenderer(treeRenderer);
        tree.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        return tree;
    }

    private DefaultMutableTreeNode addTreeNode(DefaultMutableTreeNode treeNode, Object node, String name) {
        DefaultMutableTreeNode returnNode = null;
        Enumeration<TreeNode> e = treeNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
            if (!((IdName)n.getUserObject()).toString().equals(name)) continue;
            returnNode = n;
            break;
        }
        if (returnNode == null) {
            returnNode = new DefaultMutableTreeNode(new IdName(node, name));
            treeNode.add(returnNode);
        }
        return returnNode;
    }

    protected abstract Vector getTreeModelData(String var1);

    protected abstract void fireTreeNodeSelected(IdName var1);

    private class TreeSelectionListenerImpl
    implements TreeSelectionListener {
        private TreeSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode newNode;
            Object nodeInfo;
            TreePath newTP = e.getNewLeadSelectionPath();
            if (newTP != null && (nodeInfo = (newNode = (DefaultMutableTreeNode)newTP.getLastPathComponent()).getUserObject()) instanceof IdName) {
                IdName nodeUData = (IdName)nodeInfo;
                TreeSelectBindPane.this.fireTreeNodeSelected(nodeUData);
            }
        }
    }
}

