/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ETextPane
extends JTextPane {
    public static final int TEXT_TYPE_TO_HEAD = 1;
    public static final int TEXT_TYPE_TO_BODY = 2;
    public static final int TEXT_TYPE_FROM_HEAD = 3;
    public static final int TEXT_TYPE_FROM_BODY = 4;
    public static final int TEXT_TYPE_DEFUALT = 5;
    protected RichTextPaneDoc doc = new RichTextPaneDoc(new StyleContext());
    protected ImageIcon bgImg = null;

    public ETextPane() {
        this.init();
    }

    private void init() {
        this.setDocument(this.doc);
        this.setOpaque(false);
        this.setEditable(false);
        this.setSelectionColor(new Color(49, 106, 197));
        this.setSelectedTextColor(new Color(255, 255, 255));
    }

    public void insertDefault(String str, boolean newLine) {
        this.insertString(str, 5, newLine);
    }

    public void insertDefault(String str, Color c, boolean newLine) {
        Style sa = this.doc.getDefaultStyle();
        StyleConstants.setForeground(sa, c);
        this.insertString(this.doc.getLength(), str, sa, newLine);
    }

    @Override
    public void insertComponent(Component c) {
        this.setCaretPosition(this.doc.getLength());
        super.insertComponent(c);
        this.setCaretPosition(this.getDocument().getLength());
        this.insertDefault("", true);
    }

    @Override
    public void insertIcon(Icon i) {
        this.setCaretPosition(this.doc.getLength());
        super.insertIcon(i);
    }

    public void insertString(int len, String str, Style s, boolean newLineAfter) {
        this.doc.insertString(len, str, s, newLineAfter);
        this.setCaretPosition(this.doc.getLength());
    }

    public void insertString(String str, int type, boolean newLineAfter) {
        this.doc.insertString(str, type, newLineAfter);
        this.setCaretPosition(this.doc.getLength());
    }

    @Override
    public void paintComponent(Graphics g) {
        ImageIcon bgi = this.getBgImg();
        if (bgi != null) {
            Image image = bgi.getImage();
            g.drawImage(image, 0, 0, this.getSize().width, this.getSize().height, null);
        }
        super.paintComponent(g);
    }

    public ImageIcon getBgImg() {
        return this.bgImg;
    }

    public void setBgImg(ImageIcon bgImg) {
        this.bgImg = bgImg;
    }

    public static class RichTextPaneDoc
    extends DefaultStyledDocument {
        Hashtable runStyles;
        StyleContext sc;

        public RichTextPaneDoc(StyleContext styleContext) {
            this.sc = styleContext;
            this.runStyles = new Hashtable();
            this.initStyle();
        }

        private void initStyle() {
            Style s = this.sc.addStyle(null, null);
            s = RichTextPaneDoc.setCharStyle(s, "\u5b8b\u4f53", 12, new Color(0, 128, 64), false, 2, 2);
            this.runStyles.put(1, s);
            s = this.sc.addStyle(null, null);
            RichTextPaneDoc.setCharStyle(s, "\u5b8b\u4f53", 13, new Color(128, 0, 0), false, 14, 2);
            this.runStyles.put(2, s);
            s = this.sc.addStyle(null, null);
            RichTextPaneDoc.setCharStyle(s, "\u5b8b\u4f53", 12, new Color(0, 0, 255), false, 2, 2);
            this.runStyles.put(3, s);
            s = this.sc.addStyle(null, null);
            RichTextPaneDoc.setCharStyle(s, "\u5b8b\u4f53", 13, new Color(0, 0, 0), false, 14, 2);
            this.runStyles.put(4, s);
            s = this.sc.addStyle(null, null);
            RichTextPaneDoc.setCharStyle(s, "\u5b8b\u4f53", 12, new Color(73, 113, 196), false, 2, 2);
            this.runStyles.put(5, s);
        }

        public Style getToHeadStyle() {
            return (Style)this.runStyles.get(1);
        }

        public Style getToBodyStyle() {
            return (Style)this.runStyles.get(2);
        }

        public Style getFromHeadStyle() {
            return (Style)this.runStyles.get(3);
        }

        public Style getFromBodyStyle() {
            return (Style)this.runStyles.get(4);
        }

        public Style getDefaultStyle() {
            return (Style)this.runStyles.get(5);
        }

        public Style getStyle(int type) {
            Style s = this.sc.addStyle(null, null);
            switch (type) {
                case 1: {
                    s = this.getToHeadStyle();
                    break;
                }
                case 2: {
                    s = this.getToBodyStyle();
                    break;
                }
                case 3: {
                    s = this.getFromHeadStyle();
                    break;
                }
                case 4: {
                    s = this.getFromBodyStyle();
                    break;
                }
                case 5: {
                    s = this.getDefaultStyle();
                }
            }
            return s;
        }

        public void insertString(String str, int type, boolean newLineAfter) {
            this.insertString(this.getLength(), str, this.getStyle(type), newLineAfter);
        }

        public void insertString(int offs, String str, boolean newLineAfter) {
            this.insertString(offs, str, this.getDefaultStyle(), newLineAfter);
        }

        public void insertString(int offs, String str, Style s, boolean newLineAfter) {
            try {
                super.insertString(offs, String.valueOf(str) + (newLineAfter ? "\r\n" : ""), s);
                if (this.getLength() <= 0 || s == null) {
                    return;
                }
                this.setParagraphAttributes(this.getLength() - 1 - str.length(), this.getLength() - 1, s, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static Style setCharStyle(Style s, String fontName, int fontSize, Color fontColor, boolean isBold, int leftIdent, int lineSpace) {
            if (!(s instanceof MutableAttributeSet)) {
                return null;
            }
            if (fontName != null) {
                StyleConstants.setFontFamily(s, fontName);
            }
            if (fontSize > 0) {
                StyleConstants.setFontSize(s, fontSize);
            }
            if (fontColor instanceof Color) {
                StyleConstants.setForeground(s, fontColor);
            }
            if (isBold) {
                StyleConstants.setBold(s, isBold);
            }
            if (leftIdent > 0) {
                StyleConstants.setLeftIndent(s, leftIdent);
            }
            if (lineSpace > 0) {
                StyleConstants.setSpaceAbove(s, lineSpace);
            }
            return s;
        }
    }
}

