/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.util.SimpleLogger;
import com.eva.epc.widget.table.ColumnTotalObserver;
import com.eva.epc.widget.table.ColumnTotalWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;

public class ETableModel
extends DefaultTableModel {
    private boolean cellEditableGlobal = false;
    private HashMap<Integer, Class> columnClasses;
    private HashMap<Integer, Boolean> columnEditable = null;
    private ColumnTotalObserver columnTotalSuport;
    protected DataAddType dataAddType = DataAddType.addToBottom;

    public ETableModel() {
    }

    public ETableModel(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public ETableModel(Vector columnNames, int numRows) {
        super(columnNames, numRows);
    }

    public ETableModel(Object[] columnNames, int numRows) {
        super(columnNames, numRows);
    }

    public ETableModel(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    public ETableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public boolean isCellEditable(int column) {
        return this.isCellEditable(-1, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.columnEditable != null) {
            Boolean b = this.columnEditable.get(column);
            return b != null && b != false;
        }
        return this.cellEditableGlobal;
    }

    public void setCellEditable(boolean editable) {
        this.cellEditableGlobal = editable;
        this.columnEditable = null;
    }

    public void setCellEditable(int columnIndx, boolean editable) {
        if (columnIndx >= 0 && columnIndx < this.getColumnCount()) {
            if (this.columnEditable == null) {
                this.columnEditable = new HashMap();
            }
            this.columnEditable.put(columnIndx, editable);
        }
    }

    public Class getColumnClass(int columnIndx) {
        if (this.columnClasses == null || this.columnClasses.get(columnIndx) == null) {
            return super.getColumnClass(columnIndx);
        }
        return this.columnClasses.get(columnIndx);
    }

    public void setColumnClass(int columnIndx, Class c) {
        if (columnIndx >= 0 && columnIndx < this.getColumnCount()) {
            if (this.columnClasses == null) {
                this.columnClasses = new HashMap();
            }
            this.columnClasses.put(columnIndx, c);
        } else {
            SimpleLogger.w("\u5fc5\u987b\u662f0<=columnIndx && columnIndx<this.getColumnCount()\uff0ccolumnIndx=" + columnIndx);
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        if (this.columnTotalSuport != null) {
            ArrayList<ColumnTotalWrapper> columnWrappers = this.columnTotalSuport.getColumnTotalWrappers();
            for (ColumnTotalWrapper columnWrapper : columnWrappers) {
                columnWrapper.setColumnTotal(new BigDecimal(0));
            }
            for (ColumnTotalWrapper dateRow : this.dataVector) {
                Vector vecRow = (Vector)((Object)dateRow);
                for (ColumnTotalWrapper columnWrapper : columnWrappers) {
                    if (columnWrapper.getColumn() == -1) {
                        columnWrapper.setColumnTotal(columnWrapper.getValue().add(new BigDecimal(1)));
                        continue;
                    }
                    try {
                        String columnCellValue = (String)vecRow.get(columnWrapper.getColumn());
                        columnWrapper.setColumnTotal(columnWrapper.getValue().add(new BigDecimal(columnCellValue)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.columnTotalSuport.update(columnWrappers);
        }
    }

    public void setDataVector(Object[][] newData) {
        this.setDataVector(ETableModel.convertToVector(newData));
    }

    public void setDataVector(Vector newVector) {
        if (this.getRowCount() > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
        }
        this.dataVector = ETableModel.nonNullVector(newVector);
        this.newRowsAdded(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
    }

    public void addRow(Vector rowData) {
        switch (this.dataAddType) {
            case addToTop: {
                this.insertRow(0, rowData);
                break;
            }
            case addToBottom: {
                super.addRow(rowData);
            }
        }
    }

    public void addRowsOneByOne(Vector rows) {
        if (rows == null || rows.size() < 1) {
            return;
        }
        int oldRowCnt = this.getRowCount();
        for (Object row : rows) {
            this.addRow((Vector)row);
        }
        this.newRowsAdded(new TableModelEvent(this, oldRowCnt, this.getRowCount() - 1, -1, 1));
    }

    public void addRows(Vector rows) {
        if (rows == null || rows.size() < 1) {
            return;
        }
        int oldRowCnt = this.getRowCount();
        this.dataVector.addAll(rows);
        this.newRowsAdded(new TableModelEvent(this, oldRowCnt, this.getRowCount() - 1, -1, 1));
    }

    public void setRow(int row, Vector newRow) {
        newRow = ETableModel.nonNullVector(newRow);
        newRow.setSize(this.getColumnCount());
        this.dataVector.set(row, newRow);
        this.fireTableChanged(new TableModelEvent(this, row, row, -1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(int[] willDeleteIndixes) {
        if (willDeleteIndixes == null || willDeleteIndixes.length < 1) {
            return;
        }
        Arrays.sort(willDeleteIndixes);
        Vector vector = this.dataVector;
        synchronized (vector) {
            int willDeleteCnt = willDeleteIndixes.length;
            int originalRowCnt = this.dataVector.size();
            Vector nw = new Vector(originalRowCnt - willDeleteCnt);
            if (willDeleteCnt == originalRowCnt) {
                this.setDataVector(new Vector());
            } else {
                int beginIndex = -1;
                int endIndex = 0;
                int i = 0;
                while (i < willDeleteCnt) {
                    endIndex = willDeleteIndixes[i];
                    if (endIndex - beginIndex > 1) {
                        nw.addAll(this.dataVector.subList(beginIndex + 1, endIndex));
                    }
                    beginIndex = endIndex;
                    ++i;
                }
                if (++endIndex < originalRowCnt) {
                    nw.addAll(this.dataVector.subList(endIndex, originalRowCnt));
                }
                this.setDataVector(nw);
            }
        }
    }

    public Vector rowAt(int rowIndex) {
        return (Vector)this.dataVector.get(rowIndex);
    }

    public ColumnTotalObserver getColumnTotalSuport() {
        return this.columnTotalSuport;
    }

    public void setColumnTotalObserver(ColumnTotalObserver ColumnTotalSuport) {
        this.columnTotalSuport = ColumnTotalSuport;
    }

    public DataAddType getDataAddType() {
        return this.dataAddType;
    }

    public void setDataAddType(DataAddType dataAddType) {
        this.dataAddType = dataAddType;
    }

    private static Vector nonNullVector(Vector v) {
        return v != null ? v : new Vector();
    }

    public static enum DataAddType {
        addToTop,
        addToBottom;

    }
}

