/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.swingx.BaseTable;
import com.eva.epc.widget.ETableModel;
import com.eva.epc.widget.table.SortManager;
import com.eva.epc.widget.util.RenderFactory;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ETable
extends BaseTable {
    private boolean sortable = true;
    private SortManager sortManager = null;
    private boolean sorting = false;

    public ETable() {
        this(null, null, null);
    }

    public ETable(TableModel tm, TableColumnModel cm) {
        this(tm, cm, null);
    }

    public ETable(TableModel tm) {
        this(tm, null, null);
    }

    public ETable(TableModel tm, TableColumnModel cm, ListSelectionModel sm) {
        super(tm, cm, sm);
        this.baseSetup();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.sortManager != null && !this.sorting) {
            this.sortManager.setCurrentSorttedColumn(-1);
            this.sortManager.setCurrentSortOrder(SortOrder.UNSORTED);
        } else {
            this.sorting = false;
        }
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof ETableModel)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u662fRWTableModel\u53ca\u5176\u5b50\u7c7b\uff0c" + dataModel.getClass());
        }
        super.setModel(dataModel);
    }

    @Override
    public ETableModel getModel() {
        return (ETableModel)super.getModel();
    }

    protected void baseSetup() {
        this.setSortable(this.sortable);
        this.initDefaultRender();
    }

    protected void initDefaultRender() {
        this.setDefaultRenderer(RenderFactory.CLASS_OBJECT, new RenderFactory.GenericRenderer());
        this.setDefaultRenderer(RenderFactory.CLASS_NUMERIC, new RenderFactory.NumberRenderer());
        this.setDefaultRenderer(RenderFactory.CLASS_DOUBLE, new RenderFactory.DoubleRenderer());
        this.setDefaultRenderer(RenderFactory.CLASS_DATE, new RenderFactory.DateRenderer());
        this.setDefaultRenderer(RenderFactory.CLASS_ICON, new RenderFactory.IconRenderer());
        this.setDefaultRenderer(RenderFactory.CLASS_BOOLEAN, new RenderFactory.BooleanRenderer());
    }

    public synchronized void setSortable(boolean sortable) {
        this.sortable = sortable;
        if (this.sortManager == null) {
            this.sortManager = new SortManager(this);
        }
        if (this.sortable) {
            this.getTableHeader().addMouseListener(this.sortManager);
        } else {
            this.getTableHeader().removeMouseListener(this.sortManager);
        }
    }

    public boolean supportSort() {
        return this.sortable;
    }

    public void addRow(Vector newRow) {
        this.getModel().addRow(newRow);
        if (this.getModel().getDataAddType() == ETableModel.DataAddType.addToBottom) {
            this.changeSelection(this.getRowCount() - 1, this.getSelectedColumn(), false, false);
        } else {
            this.changeSelection(0, this.getSelectedColumn(), false, false);
        }
    }

    public void deleteSelectedRow() {
        int row = this.getSelectedRow();
        if (row > -1) {
            this.getModel().removeRow(row);
        }
        if (row >= this.getRowCount()) {
            --row;
        }
        if (row > -1) {
            this.changeSelection(row, this.getSelectedColumn(), false, false);
        }
    }

    public SortManager getSortManager() {
        return this.sortManager;
    }

    public void setSortManager(SortManager sortManager) {
        this.sortManager = sortManager;
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public void setSorting(boolean sorting) {
        this.sorting = sorting;
    }
}

