/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.widget;

import com.eva.epc.common.util.FirstPinyinHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.ComboPopup;

public abstract class ESearchableField
extends JTextField {
    private int manulSearchShortKey = 39;
    private int maximumRowCount = 10;
    private ResultPopupMenu searcheResultPopupMenu2 = new ResultPopupMenu(this);
    private FocusHandler fieldFocusListener;
    private KeyListener resultListScrollListener;
    private KeyListener mapToResultListListener;
    private MathLang searchMatchLang;

    public ESearchableField() {
        this(null, 0);
    }

    public ESearchableField(int columns) {
        this(null, columns);
    }

    public ESearchableField(String txt) {
        this(txt, 0);
    }

    public ESearchableField(String txt, int columns) {
        super(txt, columns);
        this.addListeners();
    }

    public abstract ArrayList getSearchSourceItems();

    public void setMaximumRowCount(int cnt) {
        this.maximumRowCount = cnt;
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public int getMmanulSearchShortKey() {
        return this.manulSearchShortKey;
    }

    public void setManulSearchShortKey(int manulSearchShortKey) {
        this.manulSearchShortKey = manulSearchShortKey;
    }

    protected void addListeners() {
        if (this.fieldFocusListener == null) {
            this.fieldFocusListener = new FocusHandler();
        }
        this.addFocusListener(this.fieldFocusListener);
        if (this.resultListScrollListener == null) {
            this.resultListScrollListener = new ResultListScrollListenerImpl();
        }
        this.addKeyListener(this.resultListScrollListener);
        if (this.mapToResultListListener == null) {
            this.mapToResultListListener = new MapToResultListListenerImpl(33, 34);
        }
        this.addKeyListener(this.mapToResultListListener);
    }

    protected void removeListeners() {
        this.removeFocusListener(this.fieldFocusListener);
        this.removeKeyListener(this.resultListScrollListener);
        this.removeKeyListener(this.mapToResultListListener);
    }

    protected ArrayList getCommonCharSearchValue(String searchText) {
        ArrayList all = this.getSearchSourceItems();
        ArrayList<String> retValue = new ArrayList<String>();
        Vector<String> allKeys = new Vector<String>();
        Vector<String> keysAdd = new Vector<String>();
        Vector<String> keysSub = new Vector<String>();
        String key = searchText.toLowerCase();
        int pos = -1;
        while ((pos = key.indexOf(" ")) != -1) {
            allKeys.add(key.substring(0, pos).trim());
            key = key.substring(pos).trim();
        }
        allKeys.add(key);
        int i = 0;
        while (i < allKeys.size()) {
            key = (String)allKeys.get(i);
            if (key.startsWith("+")) {
                if (key.substring(1).trim().length() > 0) {
                    keysAdd.add(key.substring(1).trim());
                }
            } else if (key.startsWith("-")) {
                if (key.substring(1).trim().length() > 0) {
                    keysSub.add(key.substring(1).trim());
                }
            } else {
                keysAdd.add(key.substring(0).trim());
            }
            ++i;
        }
        String text = "";
        int i2 = 0;
        while (i2 < all.size()) {
            int j;
            text = all.get(i2).toString().toLowerCase();
            boolean toAdd = true;
            for (j = 0; j < keysAdd.size(); ++j) {
                if (text.indexOf(keysAdd.get(j).toString()) != -1) continue;
                toAdd = false;
                break;
            }
            if (toAdd) {
                for (j = 0; j < keysSub.size(); ++j) {
                    if (text.indexOf(keysSub.get(j).toString()) == -1) continue;
                    toAdd = false;
                    break;
                }
                if (toAdd) {
                    retValue.add(all.get(i2).toString());
                }
            }
            ++i2;
        }
        return retValue;
    }

    protected ArrayList getPingYingSearchValue(String searchText) {
        String key = "";
        if (searchText.length() > 0) {
            if (searchText.substring(0, 1).getBytes().length == 2) {
                return this.getCommonCharSearchValue(searchText);
            }
            int pos = searchText.indexOf(" ");
            key = searchText.substring(0, pos != -1 ? pos : searchText.length());
        }
        ArrayList all = this.getSearchSourceItems();
        ArrayList retValue = new ArrayList();
        FirstPinyinHelper transfer = new FirstPinyinHelper();
        key = key.toUpperCase();
        int i = 0;
        while (i < all.size()) {
            String trans = FirstPinyinHelper.string2Alpha(all.get(i).toString().trim());
            if (trans.contains(key)) {
                retValue.add(all.get(i));
            }
            ++i;
        }
        return retValue;
    }

    protected ArrayList getSearchResultMixed(String searchText) {
        if (searchText.length() < 1) {
            return this.getCommonCharSearchValue(searchText);
        }
        if (!(searchText.charAt(0) >= 'A' && searchText.charAt(0) <= 'Z' || searchText.charAt(0) >= 'a' && searchText.charAt(0) <= 'z')) {
            return this.getCommonCharSearchValue(searchText);
        }
        ArrayList retValue = new ArrayList();
        ArrayList engValue = this.getCommonCharSearchValue(searchText);
        ArrayList chinValue = this.getPingYingSearchValue(searchText);
        int i = 0;
        while (i < engValue.size()) {
            retValue.add(engValue.get(i));
            ++i;
        }
        i = 0;
        while (i < chinValue.size()) {
            if (!retValue.contains(chinValue.get(i))) {
                retValue.add(chinValue.get(i));
            }
            ++i;
        }
        return retValue;
    }

    public ArrayList getSearchResult(String searchText) {
        switch (this.searchMatchLang) {
            case en: {
                return this.getCommonCharSearchValue(searchText);
            }
            case cn: {
                return this.getPingYingSearchValue(searchText);
            }
            case mixed: {
                return this.getSearchResultMixed(searchText);
            }
        }
        return new ArrayList();
    }

    public MathLang getSearchMatchLang() {
        return this.searchMatchLang;
    }

    public void setSearchMatchLang(MathLang searchMatchLang) {
        this.searchMatchLang = searchMatchLang;
    }

    public ResultPopupMenu getSearcheResultPopupMenu() {
        return this.searcheResultPopupMenu2;
    }

    public void setSearcheResultPopupMenu(ResultPopupMenu searcheResultPopupMenu) {
        this.searcheResultPopupMenu2 = searcheResultPopupMenu;
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                ESearchableField.this.searcheResultPopupMenu2.hide();
            }
        }
    }

    private class MapToResultListListenerImpl
    extends KeyAdapter {
        private ArrayList<Integer> keyCodes = new ArrayList();

        public MapToResultListListenerImpl(int ... keyCodes) {
            int[] nArray = keyCodes;
            int n = keyCodes.length;
            int n2 = 0;
            while (n2 < n) {
                int keyCode = nArray[n2];
                this.keyCodes.add(keyCode);
                ++n2;
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getModifiers() != 0) {
                return;
            }
            int keyCode = e.getKeyCode();
            if (keyCode == 10) {
                String selectedRusult = (String)ESearchableField.this.searcheResultPopupMenu2.getList().getSelectedValue();
                if (ESearchableField.this.searcheResultPopupMenu2.isVisible() && selectedRusult != null && selectedRusult.length() > 0) {
                    ESearchableField.this.setText(selectedRusult);
                }
            } else if (this.keyCodes.size() > 0 && this.keyCodes.contains(keyCode) && ESearchableField.this.searcheResultPopupMenu2.isVisible()) {
                ESearchableField.this.searcheResultPopupMenu2.getList().dispatchEvent(new KeyEvent(ESearchableField.this.searcheResultPopupMenu2.getList(), 401, 0L, 0, keyCode, '\uffff'));
            }
        }
    }

    public static enum MathLang {
        en,
        cn,
        mixed;

    }

    private class ResultListScrollListenerImpl
    extends KeyAdapter {
        private KeyStroke upStroke = KeyStroke.getKeyStroke(38, 0);
        private KeyStroke downStroke = KeyStroke.getKeyStroke(40, 0);

        private ResultListScrollListenerImpl() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            KeyStroke thisStorke = KeyStroke.getKeyStrokeForEvent(e);
            if (ESearchableField.this.isEnabled()) {
                if (!thisStorke.equals(this.upStroke) && !thisStorke.equals(this.downStroke)) {
                    return;
                }
                if (ESearchableField.this.searcheResultPopupMenu2.isVisible()) {
                    if (thisStorke.equals(this.upStroke)) {
                        ESearchableField.this.searcheResultPopupMenu2.selectPreviousItem();
                    } else if (thisStorke.equals(this.downStroke)) {
                        ESearchableField.this.searcheResultPopupMenu2.selectNextItem();
                    }
                }
            }
        }
    }

    public static class ResultPopupMenu
    extends JPopupMenu
    implements ComboPopup {
        protected ESearchableField txtInput;
        protected JList list;
        protected JScrollPane scroller;
        protected KeyListener keyListener;
        protected MouseListener mouseListener;
        protected MouseInputListener listMouseListener;

        public ResultPopupMenu(ESearchableField txtInput) {
            this.txtInput = txtInput;
            this.keyListener = new KeyListenerImpl();
            this.mouseListener = new MouseListenerImpl();
            this.listMouseListener = new MouseMotionListenerImpl();
            this.list = new JList();
            this.list.setBorder(null);
            this.list.setRequestFocusEnabled(false);
            this.list.setSelectionMode(0);
            this.list.addMouseMotionListener(this.listMouseListener);
            this.list.addMouseListener(this.listMouseListener);
            this.scroller = new JScrollPane(this.list, 20, 31);
            this.scroller.setRequestFocusEnabled(false);
            this.scroller.getVerticalScrollBar().setRequestFocusEnabled(false);
            this.scroller.setBorder(null);
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setRequestFocusEnabled(false);
            txtInput.addKeyListener(this.keyListener);
            txtInput.addMouseListener(this.mouseListener);
        }

        public void selectNextItem() {
            if (this.list.getSelectedIndex() < this.list.getModel().getSize() - 1) {
                this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
            } else if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(0);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        public void selectPreviousItem() {
            if (this.list.getSelectedIndex() > 0) {
                this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
            } else if (this.list.getModel().getSize() > 0) {
                this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
            }
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }

        @Override
        public void show() {
            this.refreshListData();
            this.validateUI();
        }

        public boolean needValidateUI() {
            return this.txtInput.getMaximumRowCount() > 0;
        }

        public void refreshListData() {
            this.list.setListData(this.txtInput.getSearchResult(this.txtInput.getText()).toArray());
        }

        public void validateUI() {
            Dimension popupSize = this.txtInput.getSize();
            popupSize.setSize(popupSize.width - 1, this.computePopupHeight(this.txtInput.getMaximumRowCount()));
            Rectangle popupBounds = this.computePopupBounds(0, this.txtInput.getBounds().height, popupSize.width, popupSize.height);
            this.scroller.setMaximumSize(popupBounds.getSize());
            this.scroller.setPreferredSize(popupBounds.getSize());
            this.scroller.setMinimumSize(popupBounds.getSize());
            this.list.invalidate();
            this.hide();
            this.show(this.txtInput, popupBounds.x, popupBounds.y);
        }

        @Override
        public void hide() {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selection = manager.getSelectedPath();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != this) continue;
                manager.clearSelectedPath();
                break;
            }
        }

        public JList getList() {
            return this.list;
        }

        @Override
        public MouseListener getMouseListener() {
            return this.mouseListener;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return null;
        }

        @Override
        public KeyListener getKeyListener() {
            return this.keyListener;
        }

        @Override
        public void uninstallingUI() {
            this.txtInput.removeMouseListener(this.mouseListener);
            this.txtInput.removeKeyListener(this.keyListener);
            this.uninstallListListeners();
            this.hide();
        }

        protected void uninstallListListeners() {
            this.list.removeMouseMotionListener(this.listMouseListener);
            this.list.removeMouseListener(this.listMouseListener);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        protected int computePopupHeight(int maxRowCount) {
            int currentElementCount = this.list.getModel().getSize();
            int rowCount = Math.min(maxRowCount, currentElementCount);
            int height = 0;
            ListCellRenderer<Object> renderer = this.list.getCellRenderer();
            Object value = null;
            int i = 0;
            while (i < rowCount) {
                value = this.list.getModel().getElementAt(i);
                Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
                height += c.getPreferredSize().height;
                ++i;
            }
            return height != 0 ? height : 100;
        }

        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Rectangle absBounds = new Rectangle();
            Rectangle r = new Rectangle(px, py, pw, ph);
            Point p = new Point(0, 0);
            SwingUtilities.convertPointFromScreen(p, this.txtInput);
            absBounds.x = p.x;
            absBounds.y = p.y;
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            absBounds.width = scrSize.width;
            absBounds.height = scrSize.height;
            if (SwingUtilities.isRectangleContainingRectangle(absBounds, r)) {
                return r;
            }
            return new Rectangle(0, -r.height, r.width, r.height);
        }

        private class KeyListenerImpl
        extends KeyAdapter {
            private KeyListenerImpl() {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10 || code == 27) {
                    if (ResultPopupMenu.this.isVisible()) {
                        if (code == 10 && ResultPopupMenu.this.list.getSelectedIndex() >= 0) {
                            ResultPopupMenu.this.txtInput.setText(String.valueOf(ResultPopupMenu.this.list.getSelectedValue()));
                        }
                        ResultPopupMenu.this.hide();
                        e.consume();
                    }
                } else if (code == ResultPopupMenu.this.txtInput.getMmanulSearchShortKey() && e.getModifiers() == 0) {
                    if (ResultPopupMenu.this.isVisible()) {
                        ResultPopupMenu.this.hide();
                    }
                    ResultPopupMenu.this.show();
                } else if (!e.isActionKey()) {
                    if (!ResultPopupMenu.this.isVisible()) {
                        ResultPopupMenu.this.show();
                    } else {
                        ResultPopupMenu.this.refreshListData();
                        if (ResultPopupMenu.this.needValidateUI()) {
                            ResultPopupMenu.this.validateUI();
                        }
                    }
                    ResultPopupMenu.this.list.setSelectedIndex(0);
                }
            }
        }

        private class MouseListenerImpl
        extends MouseAdapter {
            private MouseListenerImpl() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 2 && ResultPopupMenu.this.txtInput.isEnabled()) {
                    if (!ResultPopupMenu.this.txtInput.hasFocus()) {
                        ResultPopupMenu.this.txtInput.grabFocus();
                    }
                    ResultPopupMenu.this.show();
                }
            }
        }

        private class MouseMotionListenerImpl
        extends MouseInputAdapter {
            private MouseMotionListenerImpl() {
            }

            @Override
            public void mouseReleased(MouseEvent anEvent) {
                ResultPopupMenu.this.txtInput.setText(String.valueOf(ResultPopupMenu.this.list.getSelectedValue()));
                ResultPopupMenu.this.hide();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.updateListSelection(e, false);
            }

            protected void updateListSelection(MouseEvent anEvent, boolean shouldScroll) {
                if (ResultPopupMenu.this.list == null) {
                    return;
                }
                Point location = anEvent.getPoint();
                int index = ResultPopupMenu.this.list.locationToIndex(location);
                if (index == -1) {
                    index = location.y < 0 ? 0 : ResultPopupMenu.this.list.getModel().getSize() - 1;
                }
                if (ResultPopupMenu.this.list.getSelectedIndex() != index) {
                    ResultPopupMenu.this.list.setSelectedIndex(index);
                    if (shouldScroll) {
                        ResultPopupMenu.this.list.ensureIndexIsVisible(index);
                    }
                }
            }
        }
    }
}

