/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.swingx;

import com.eva.epc.swingx.ColumnControlButton2;
import com.eva.epc.swingx.TableSearchableUtil;
import com.eva.epc.swingx.table.DefaultTableColumnModelExt;
import com.eva.epc.swingx.table.TableColumnExt;
import com.eva.epc.swingx.table.TableColumnModelExt;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTable
extends JTable {
    private ColumnFactory columnFactory;
    private ColumnControlButton2 columnControlButton;
    private Vector columnHeaderToolTips = new Vector();
    private int preferredRowForVisible = 6;
    private double prefereWidthScale = 0.7;
    private boolean adaptingColumnOnChange = true;

    public BaseTable() {
        this.otherSetup();
    }

    public BaseTable(TableModel dm) {
        super(dm);
        this.otherSetup();
    }

    public BaseTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.otherSetup();
    }

    public BaseTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.otherSetup();
    }

    public BaseTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.otherSetup();
    }

    public BaseTable(Vector<?> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.otherSetup();
    }

    public BaseTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.otherSetup();
    }

    protected void otherSetup() {
        this.applySearchable();
        this.setColumnControlVisible(true);
        this.setRowHeight(25);
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 1));
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return (String)BaseTable.this.columnHeaderToolTips.get(realIndex);
            }
        };
    }

    public Vector getColumnHeaderToolTips() {
        return this.columnHeaderToolTips;
    }

    public void setColumnHeaderToolTips(Vector columnHeaderToolTips) {
        this.columnHeaderToolTips = columnHeaderToolTips;
    }

    protected void applySearchable() {
        TableSearchableUtil.applySearchable(this);
    }

    public TableColumnExt getColumnExt(int viewColumnIndex) {
        TableColumn column = this.getColumn(viewColumnIndex);
        if (column instanceof TableColumnExt) {
            return (TableColumnExt)column;
        }
        return null;
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    @Override
    public final void createDefaultColumnsFromModel() {
        if (this.getModel() == null) {
            return;
        }
        this.removeColumns();
        this.createAndAddColumns();
    }

    private void createAndAddColumns() {
        int i = 0;
        while (i < this.getModel().getColumnCount()) {
            TableColumnExt tableColumn = this.getColumnFactory().createAndConfigureTableColumn(this.getModel(), i);
            if (tableColumn != null) {
                this.getColumnModel().addColumn(tableColumn);
            }
            ++i;
        }
    }

    private void removeColumns() {
        List<TableColumn> columns = this.getColumns(true);
        Iterator<TableColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            this.getColumnModel().removeColumn(iter.next());
        }
    }

    public ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            this.columnFactory = ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public List<TableColumn> getColumns(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(includeHidden);
        }
        return this.getColumns();
    }

    public List<TableColumn> getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public void scrollRowToVisible(int row) {
        Rectangle cellRect = this.getCellRect(row, 0, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollColumnToVisible(int column) {
        Rectangle cellRect = this.getCellRect(0, column, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.y = visibleRect.y;
        cellRect.height = visibleRect.height;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollCellToVisible(int row, int column) {
        Rectangle cellRect = this.getCellRect(row, column, false);
        this.scrollRectToVisible(cellRect);
    }

    public boolean isColumnControlExists() {
        return this.getColumnControl(false) != null;
    }

    public boolean isXlsExportControlExists() {
        return this.getColumnControl(false) != null;
    }

    public boolean isColumnControlVisible() {
        return this.isColumnControlExists() && this.getColumnControl(false).isColumnControlVisible();
    }

    public void setColumnControlVisible(boolean visible) {
        if (!visible && !this.isColumnControlExists()) {
            return;
        }
        this.getColumnControl(true).setColumnControlVisible(visible);
    }

    public ColumnControlButton2 getColumnControl(boolean createIfUnexists) {
        if (createIfUnexists && this.columnControlButton == null) {
            this.columnControlButton = this.createDefaultColumnControl();
        }
        return this.columnControlButton;
    }

    public void setColumnControl(ColumnControlButton2 columnControl) {
        ColumnControlButton2 old = this.columnControlButton;
        this.columnControlButton = columnControl;
        this.getColumnControl(false).configureColumnControl();
        this.firePropertyChange("columnControl", old, this.getColumnControl(false));
    }

    protected ColumnControlButton2 createDefaultColumnControl() {
        return new ColumnControlButton2(this);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        super.setComponentOrientation(o);
        if (this.isColumnControlExists()) {
            this.getColumnControl(false).configureColumnControl();
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        if (this.isColumnControlExists()) {
            this.getColumnControl(false).configureColumnControl();
        }
    }

    public void setValueAtSelected(String fieldName, Object value) {
        this.setValueAt(value, this.getSelectedRow(), fieldName);
    }

    public void setValueAt(Object value, int row, String fieldName) {
        this.setValueAt(value, row, this.columnIndex(fieldName));
    }

    public String getStringValueAtSelected(String fieldName) {
        return (String)this.getValueAtSelected(fieldName);
    }

    public String getStringValueAt(int row, String fieldName) {
        return (String)this.getValueAt(row, fieldName);
    }

    public Object getValueAtSelected(String fieldName) {
        return this.getValueAt(this.getSelectedRow(), fieldName);
    }

    public Object getValueAtSelected(int columnIndex) {
        return this.getValueAt(this.getSelectedRow(), columnIndex);
    }

    public Object getValueAt(int row, String fieldName) {
        return this.getValueAt(row, this.columnIndex(fieldName));
    }

    public boolean isHideColumn(int columnIndex) {
        return this.getColumnModel().getColumn(columnIndex).getMaxWidth() == 0;
    }

    public void setColumnVisible(String fieldName, boolean visible) {
        SwingUtils.setColumnVisible((JTable)this, fieldName, visible);
    }

    public void hideColumn(String fieldName) {
        this.setColumnVisible(fieldName, false);
    }

    public void hideColumn(int index) {
        SwingUtils.setColumnVisible((JTable)this, index, false);
    }

    public String getShowValueAtSelected(String fieldName) {
        if (this.getSelectedRow() == -1) {
            throw new RuntimeException("getShowValueAtSelected\u51fa\u9519\uff0c\u6ca1\u6709\u9009\u4e2d\u4efb\u4f55\u884c.");
        }
        return this.getShowValueAt(this.getSelectedRow(), fieldName);
    }

    public String getShowValueAt(int row, int columnIndex) {
        Component renderer;
        String value = (String)this.getValueAt(row, columnIndex);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(columnIndex);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer != null && (renderer = tableCellRenderer.getTableCellRendererComponent(this, value, false, false, row, columnIndex)) instanceof JLabel) {
            return ((JLabel)renderer).getText();
        }
        return value;
    }

    public String getShowValueAt(int row, String fieldName) {
        return this.getShowValueAt(row, this.columnIndex(fieldName));
    }

    public int columnIndex(String columnFieldName) {
        return SwingUtils.columnIndex(this, columnFieldName);
    }

    public void selfAdaptingColumnWidth() {
        SwingUtils.selfAdaptingColumnWidth(this);
    }

    public void setColumnWidth(int col, int w) {
        SwingUtils.setColumnWidth(this, col, w);
    }

    public void selfAdaptingColumnWidth(int col) {
        SwingUtils.selfAdaptingColumnWidth(this, col, 0, this.getRowCount());
    }

    protected void selfAdaptingColumnWidth(int col, int from, int to) {
        SwingUtils.selfAdaptingColumnWidth(this, col, from, to);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.prefereWidthScale == -1.0 ? super.getPreferredScrollableViewportSize() : new Dimension(Math.min(this.getTableHeader().getPreferredSize().width, (int)((double)this.getToolkit().getScreenSize().width * this.getPrefereWidthScale())), this.getRowHeight() * this.getPreferredRowForVisible());
    }

    public int getPreferredRowForVisible() {
        return this.preferredRowForVisible;
    }

    public void setPreferredRowForVisible(int preferredRowForVisible) {
        if (preferredRowForVisible > 0 && this.preferredRowForVisible != preferredRowForVisible) {
            this.preferredRowForVisible = preferredRowForVisible;
        }
    }

    public double getPrefereWidthScale() {
        return this.prefereWidthScale;
    }

    public void setPrefereWidthScale(double prefereWidthScale) {
        if (prefereWidthScale <= 1.0 && prefereWidthScale > 0.0 && this.prefereWidthScale != prefereWidthScale) {
            this.prefereWidthScale = prefereWidthScale;
        }
    }

    public boolean isAdaptingColumnOnChange() {
        return this.adaptingColumnOnChange;
    }

    public void setAdaptingColumnOnChange(boolean adaptingColumnOnChange) {
        this.adaptingColumnOnChange = adaptingColumnOnChange;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (this.isAdaptingColumnOnChange() && e.getType() == 1 && this.getAutoResizeMode() == 0) {
            this.selfAdaptingColumnWidth();
        }
    }

    public static class ColumnFactory {
        private static ColumnFactory columnFactory;

        public static synchronized ColumnFactory getInstance() {
            if (columnFactory == null) {
                columnFactory = new ColumnFactory();
            }
            return columnFactory;
        }

        public static synchronized void setInstance(ColumnFactory factory) {
            columnFactory = factory;
        }

        public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
            TableColumnExt column = this.createTableColumn(modelIndex);
            if (column != null) {
                this.configureTableColumn(model, column);
            }
            return column;
        }

        public TableColumnExt createTableColumn(int modelIndex) {
            return new TableColumnExt(modelIndex);
        }

        public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
            if (columnExt.getModelIndex() < 0 || columnExt.getModelIndex() >= model.getColumnCount()) {
                throw new IllegalStateException("column must have valid modelIndex");
            }
            columnExt.setHeaderValue(model.getColumnName(columnExt.getModelIndex()));
        }
    }
}

