/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLLabelUI;
import com.eva.epc.widget.util.GraphicHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WLPanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;
    private Color backgroundColor;
    private boolean useTextureFill = false;

    public WLPanelUI() {
        this(UIManager.getColor("Panel.background"));
    }

    public WLPanelUI(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public WLPanelUI(boolean useTextureFill) {
        this(null, useTextureFill);
    }

    public WLPanelUI(Color backgroundColor, boolean useTextureFill) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
        this.useTextureFill = useTextureFill;
    }

    public static ComponentUI createUI(JComponent c, Color backgroundColor, boolean useTextureFill) {
        return new WLLabelUI(backgroundColor, useTextureFill);
    }

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new WLPanelUI();
        }
        return panelUI;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (c == null || g == null) {
            return;
        }
        Rectangle thumbBounds = c.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        if (this.useTextureFill) {
            GraphicHandler.fillTextureRoundRec(g2, this.backgroundColor, 0, 0, w, h, 0);
        } else {
            GraphicHandler.fillCrystalRoundRec(g2, this.backgroundColor, 0, 0, w, h, 0);
        }
    }

    protected Color getColor(int r, int g, int b) {
        return GraphicHandler.getColor(this.backgroundColor, r, g, b);
    }
}

