/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.lnf.winlike.WLMenuItemUIAccessor;
import com.eva.epc.lnf.winlike.WLTMSchema;
import com.eva.epc.lnf.winlike.WLUtils;
import com.eva.epc.lnf.winlike.WLXPStyle;
import com.eva.epc.widget.util.GraphicHandler;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class WLMenuItemUI
extends WindowsMenuItemUI {
    private static boolean enforceTransparent = true;
    final WLMenuItemUIAccessor accessor = new WLMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return WLMenuItemUI.this.menuItem;
        }

        @Override
        public WLTMSchema.State getState(JMenuItem menuItem) {
            return WLMenuItemUI.getState(this, menuItem);
        }

        @Override
        public WLTMSchema.Part getPart(JMenuItem menuItem) {
            return WLMenuItemUI.getPart(this, menuItem);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new WLMenuItemUI();
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (WLMenuItemUI.isVistaPainting()) {
            WLMenuItemUI.paintBackground(this.accessor, g, menuItem, bgColor);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
            GraphicHandler.fillTextureRoundRec(g2, bgColor, 0, 0, menuWidth, menuHeight, 5);
        } else if (!enforceTransparent) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
        }
        g.setColor(oldColor);
    }

    static void paintBackground(WLMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Color bgColor) {
        assert (WLMenuItemUI.isVistaPainting());
        if (WLMenuItemUI.isVistaPainting()) {
            int menuWidth = menuItem.getWidth();
            int menuHeight = menuItem.getHeight();
            if (menuItem.isOpaque()) {
                Color oldColor = g.getColor();
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                g.setColor(oldColor);
            }
            WLXPStyle xp = WLXPStyle.getXP();
            WLTMSchema.Part part = menuItemUI.getPart(menuItem);
            WLXPStyle.Skin skin = xp.getSkin(menuItem, part);
            skin.paintSkin(g, 0, 0, menuWidth, menuHeight, menuItemUI.getState(menuItem));
        }
    }

    static void paintText(WLMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        assert (WLMenuItemUI.isVistaPainting());
        if (WLMenuItemUI.isVistaPainting()) {
            WLTMSchema.State state = menuItemUI.getState(menuItem);
            FontMetrics fm = WLUtils.getFontMetrics(menuItem, g);
            int mnemIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemIndex = -1;
            }
            WLXPStyle xp = WLXPStyle.getXP();
            Color textColor = menuItem.getForeground();
            if (textColor instanceof UIResource) {
                WLTMSchema.Part part = menuItemUI.getPart(menuItem);
                textColor = xp.getColor(menuItem, part, state, WLTMSchema.Prop.TEXTCOLOR, textColor);
            }
            g.setColor(textColor);
            WLUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    static WLTMSchema.State getState(WLMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        ButtonModel model = menuItem.getModel();
        WLTMSchema.State state = model.isArmed() ? (model.isEnabled() ? WLTMSchema.State.HOT : WLTMSchema.State.DISABLEDHOT) : (model.isEnabled() ? WLTMSchema.State.NORMAL : WLTMSchema.State.DISABLED);
        return state;
    }

    static WLTMSchema.Part getPart(WLMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        return WLTMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting() {
        WLXPStyle xp = WLXPStyle.getXP();
        return xp != null && xp.isSkinDefined(null, WLTMSchema.Part.MP_POPUPITEM);
    }

    public static boolean isEnforceTransparent() {
        return enforceTransparent;
    }

    public static void setEnforceTransparent(boolean enforceTransparent) {
        WLMenuItemUI.enforceTransparent = enforceTransparent;
    }
}

