/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.winlike;

import com.eva.epc.widget.util.GraphicHandler;
import com.sun.java.swing.plaf.windows.WindowsLabelUI;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class WLLabelUI
extends WindowsLabelUI {
    private static final WLLabelUI zcLabelUI = new WLLabelUI();
    private Color backgroundColor = UIManager.getColor("Label.background");
    private boolean useTextureFill = false;

    public WLLabelUI() {
    }

    public WLLabelUI(boolean useTextureFill) {
        this(null, useTextureFill);
    }

    public WLLabelUI(Color backgroundColor, boolean useTextureFill) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
        this.useTextureFill = useTextureFill;
    }

    public static ComponentUI createUI(JComponent c, Color backgroundColor, boolean useTextureFill) {
        return new WLLabelUI(backgroundColor, useTextureFill);
    }

    public static ComponentUI createUI(JComponent c) {
        return zcLabelUI;
    }

    public void paint(Graphics g, JComponent c) {
        if (c == null || g == null) {
            return;
        }
        Rectangle thumbBounds = c.getBounds();
        Graphics2D g2 = (Graphics2D)g;
        Paint oldp = g2.getPaint();
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        if (this.useTextureFill) {
            GraphicHandler.fillTextureRoundRec(g2, this.backgroundColor, 0, 0, w, h, 0);
        } else {
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getColor(10, 10, 10), 0.0f, h / 2, this.backgroundColor);
            g2.setPaint(gp);
            g2.fillRect(0, 0, w, h / 2);
            g2.setPaint(oldp);
            g2.setColor(this.getColor(-10, -10, -10));
            g2.fillRect(0, h / 2, w, h);
        }
        super.paint(g, c);
    }

    protected Color getColor(int r, int g, int b) {
        return GraphicHandler.getColor(this.backgroundColor, r, g, b);
    }

    public boolean isUseTextureFill() {
        return this.useTextureFill;
    }
}

