/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.eva.epc.lnf.nimbuslike.NLIconFactory;
import com.eva.epc.lnf.nimbuslike.NLLookAndFeel;
import com.eva.epc.lnf.nimbuslike.NLRootPaneUI;
import com.eva.epc.lnf.nimbuslike.NLUtils;
import com.eva.epc.widget.util.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

class NLTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private Action feedbackAction;
    private Action setupAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private JButton feedbackButton;
    private JButton setupButton;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private NLRootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;

    public NLTitlePane(JRootPane root, NLRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        try {
            super.addNotify();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1 || decorationStyle == 2) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.closeButton);
            this.add(this.feedbackButton);
            this.add(this.setupButton);
            if (decorationStyle != 2) {
                this.add(this.iconifyButton);
                this.add(this.toggleButton);
                this.menuBar.setEnabled(false);
            }
        } else if (decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setOpaque(false);
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
            this.feedbackAction = new AbstractAction("\u53cd\u9988\u610f\u89c1  "){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(NLTitlePane.this.rootPane, "\u529f\u80fd\u6682\u672a\u5b9e\u73b0\uff01");
                }
            };
            this.setupAction = new AbstractAction("\u8bbe\u7f6e  "){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(NLTitlePane.this.rootPane, "\u529f\u80fd\u6682\u672a\u5b9e\u73b0\uff01");
                }
            };
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        menu.setRolloverEnabled(false);
        if (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        int mnemonic;
        JMenuItem mi;
        Locale locale = this.getRootPane().getLocale();
        menu.setToolTipText("\u7a97\u53e3\u76f8\u5173\u64cd\u4f5c.");
        if (this.getWindowDecorationStyle() == 1) {
            mi = menu.add(this.restoreAction);
            mnemonic = NLLookAndFeel.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            mi = menu.add(this.iconifyAction);
            mnemonic = NLLookAndFeel.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                mi = menu.add(this.maximizeAction);
                mnemonic = NLLookAndFeel.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (mnemonic != -1) {
                    mi.setMnemonic(mnemonic);
                }
            }
            menu.add(new JSeparator());
        }
        mi = menu.add(this.closeAction);
        mnemonic = NLLookAndFeel.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        return button;
    }

    private void createButtons() {
        this.feedbackButton = this.createTitleButton();
        this.feedbackButton.setAction(this.feedbackAction);
        this.feedbackButton.setBorder(handyEmptyBorder);
        this.feedbackButton.setIcon(UIManager.getIcon("Frame.feedbackIcon"));
        this.feedbackButton.setContentAreaFilled(false);
        this.setupButton = this.createTitleButton();
        this.setupButton.setAction(this.setupAction);
        this.setupButton.setBorder(handyEmptyBorder);
        this.setupButton.setIcon(UIManager.getIcon("Frame.setupIcon"));
        this.setupButton.setContentAreaFilled(false);
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("Frame.closeIcon"));
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setToolTipText("\u5173\u95ed");
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = UIManager.getIcon("Frame.maximizeIcon");
            this.minimizeIcon = UIManager.getIcon("Frame.minimizeIcon");
            this.iconifyButton = this.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(handyEmptyBorder);
            this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
            this.iconifyButton.setIcon(UIManager.getIcon("Frame.iconifyIcon"));
            this.iconifyButton.setContentAreaFilled(false);
            this.iconifyButton.setToolTipText("\u6700\u5c0f\u5316");
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(handyEmptyBorder);
            this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
            this.toggleButton.setIcon(this.maximizeIcon);
            this.toggleButton.setContentAreaFilled(false);
            this.toggleButton.setToolTipText("\u6700\u5927\u5316");
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", activeB);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        String theTitle;
        int xOffset;
        Color darkShadow;
        Color foreground;
        Color background;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            background = this.activeBackground;
            foreground = this.activeForeground;
            darkShadow = this.activeShadow;
        } else {
            background = this.inactiveBackground;
            foreground = this.inactiveForeground;
            darkShadow = this.inactiveShadow;
        }
        NLTitlePane.paintTitlePane(g, 0, 0, width, height, isSelected, background, darkShadow);
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1 || this.getWindowDecorationStyle() == 2) {
            xOffset += leftToRight ? 21 : -21;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = NLUtils.getFontMetrics(rootPane, g);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = NLUtils.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = NLUtils.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
                xOffset -= NLUtils.stringWidth(rootPane, fm, theTitle);
            }
            int titleLength = NLUtils.stringWidth(rootPane, fm, theTitle);
            if (NLLookAndFeel.windowTitleAntialising) {
                NLLookAndFeel.setAntiAliasing((Graphics2D)g, true);
            }
            g.setColor(foreground);
            NLUtils.drawString(rootPane, g, theTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
            if (NLLookAndFeel.windowTitleAntialising) {
                NLLookAndFeel.setAntiAliasing((Graphics2D)g, false);
            }
        }
    }

    public static void paintTitlePane(Graphics g, int x, int y, int width, int height, boolean actived, Color activeBackground, Color activeShadow) {
        Graphics2D g2 = (Graphics2D)g;
        Paint oldpaint = g2.getPaint();
        g2.setPaint(SwingUtils.createTexturePaint(actived ? NLIconFactory.getInstance().getFrameTitleHeadBg_active().getImage() : NLIconFactory.getInstance().getFrameTitleHeadBg_inactive().getImage()));
        g2.fillRect(x, y, width, height);
        g2.setPaint(oldpaint);
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("\u5173\u95ed(C)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NLTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super("\u6700\u5c0f\u5316(N)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NLTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("\u6700\u5927\u5316(X)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NLTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = NLTitlePane.this.getFrame();
                if (frame != null) {
                    NLTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    NLTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                NLTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                NLTitlePane.this.revalidate();
                NLTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("\u8fd8\u539f(R)");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NLTitlePane.this.restore();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g) {
            Image image;
            Frame frame = NLTitlePane.this.getFrame();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("Frame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = NLTitlePane.this.rootPane.getFontMetrics(NLTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (NLTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = NLTitlePane.this.window == null ? NLTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : NLTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = NLTitlePane.this.getWidth();
            int y = 3;
            if (NLTitlePane.this.closeButton != null && NLTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = NLTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = NLTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (NLTitlePane.this.menuBar != null) {
                NLTitlePane.this.menuBar.setBounds(x, y, 16, 16);
            }
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (NLTitlePane.this.closeButton != null) {
                NLTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (NLTitlePane.this.getWindowDecorationStyle() == 1) {
                int stringWidth;
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && NLTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 2;
                    NLTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (NLTitlePane.this.iconifyButton != null && NLTitlePane.this.iconifyButton.getParent() != null) {
                    spacing = 2;
                    NLTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (NLTitlePane.this.setupButton != null) {
                    spacing = 2;
                    stringWidth = SwingUtils.getStrPixWidth(NLTitlePane.this.setupButton.getFont(), NLTitlePane.this.setupButton.getText());
                    NLTitlePane.this.setupButton.setBounds(x += leftToRight ? -spacing - buttonWidth - stringWidth : spacing, y, buttonWidth + stringWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (NLTitlePane.this.feedbackButton != null) {
                    spacing = 2;
                    stringWidth = SwingUtils.getStrPixWidth(NLTitlePane.this.feedbackButton.getFont(), NLTitlePane.this.feedbackButton.getText());
                    NLTitlePane.this.feedbackButton.setBounds(x += leftToRight ? -spacing - buttonWidth - stringWidth : spacing, y, buttonWidth + stringWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            NLTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            NLTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            NLTitlePane.this.setActive(false);
        }
    }
}

