/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.lnf.nimbuslike;

import com.android.ninepatch.NinePatch;
import com.eva.epc.lnf.nimbuslike.NL9IconFactory;
import com.eva.epc.lnf.nimbuslike.NLTMSchema;
import com.eva.epc.lnf.nimbuslike.NLXPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class NLScrollBarUI
extends BasicScrollBarUI {
    int arc = 6;
    private Color color = new Color(178, 205, 244);

    public static ComponentUI createUI(JComponent c) {
        return new NLScrollBarUI();
    }

    protected Color getFirstTopColor() {
        return this.getColor(this.color, -1, 3, 7);
    }

    protected Color getFirstButtomColor() {
        return this.getColor(this.color, -28, -27, -18);
    }

    protected Color getSecondTopColor() {
        return this.getColor(this.color, 54, 36, 18);
    }

    protected Color getSecondButtomColor() {
        return this.getColor(this.color, 19, 13, 8);
    }

    protected Color getColor1() {
        return this.getColor(this.color, 40, 28, 17);
    }

    protected Color getColor2() {
        return this.getColor(this.color, 35, 25, 15);
    }

    protected Color getColor3() {
        return this.getColor(this.color, 10, 10, 8);
    }

    protected Color getColor4() {
        return this.getColor(this.color, -1, -1, 0);
    }

    protected Color getColor5() {
        return this.getColor(this.color, -9, -6, 2);
    }

    protected Color getColor(Color color, int r, int g, int b) {
        return new Color(this.getColorInt(color.getRed() + r), this.getColorInt(color.getGreen() + g), this.getColorInt(color.getBlue() + b));
    }

    protected int getColorInt(int rgb) {
        return rgb < 0 ? 0 : (rgb > 255 ? 255 : rgb);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new WindowsArrowButton(orientation, UIManager.getColor("ScrollBar.thumb"), UIManager.getColor("ScrollBar.thumbShadow"), UIManager.getColor("ScrollBar.thumbDarkShadow"), UIManager.getColor("ScrollBar.thumbHighlight"));
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (c == null || g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint oldp = g2.getPaint();
        int w = trackBounds.width;
        int h = trackBounds.height;
        int x = trackBounds.x;
        int y = trackBounds.y;
        if (this.scrollbar.getOrientation() == 1) {
            int hhhWidth = 5;
            int px = (w - hhhWidth) / 2;
            int delta = 50;
            g2.setColor(new Color(150 + delta, 151 + delta, 146 + delta));
            g2.drawLine(px + 0, y + 10, px + 0, y + h - 10);
            g2.setColor(new Color(160 + delta, 160 + delta, 162 + delta));
            g2.drawLine(px + 1, y + 10, px + 1, y + h - 10);
            g2.setColor(new Color(163 + delta, 162 + delta, 167 + delta));
            g2.drawLine(px + 2, y + 10, px + 2, y + h - 10);
            g2.setColor(new Color(162 + delta, 162 + delta, 162 + delta));
            g2.drawLine(px + 3, y + 10, px + 3, y + h - 10);
            g2.setColor(new Color(150 + delta, 150 + delta, 150 + delta));
            g2.drawLine(px + 4, y + 10, px + 4, y + h - 10);
        } else {
            int hhhWidth = 5;
            int py = (h - hhhWidth) / 2;
            int delta = 50;
            g2.setColor(new Color(150 + delta, 151 + delta, 146 + delta));
            g2.drawLine(x + 10, py + 0, x + w - 10, py + 0);
            g2.setColor(new Color(160 + delta, 160 + delta, 162 + delta));
            g2.drawLine(x + 10, py + 1, x + w - 10, py + 1);
            g2.setColor(new Color(163 + delta, 162 + delta, 167 + delta));
            g2.drawLine(x + 10, py + 2, x + w - 10, py + 2);
            g2.setColor(new Color(162 + delta, 162 + delta, 162 + delta));
            g2.drawLine(x + 10, py + 3, x + w - 10, py + 3);
            g2.setColor(new Color(150 + delta, 150 + delta, 150 + delta));
            g2.drawLine(x + 10, py + 4, x + w - 10, py + 4);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        int w = thumbBounds.width - 4;
        int h = thumbBounds.height - 4;
        g2.translate(thumbBounds.x + 2, thumbBounds.y + 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.scrollbar.getOrientation() == 1) {
            NinePatch np = NL9IconFactory.getInstance().getScrollBar_v();
            if (h < np.getHeight()) {
                np.draw(g2, 0, 0, w, np.getHeight());
            } else {
                np.draw(g2, 0, 0, w, h);
            }
        } else {
            NinePatch np = NL9IconFactory.getInstance().getScrollBar_h();
            if (w < np.getWidth()) {
                np.draw(g2, 0, 0, np.getWidth(), h);
            } else {
                np.draw(g2, 0, 0, w, h);
            }
        }
        g2.translate(-thumbBounds.x, -thumbBounds.y);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private class WindowsArrowButton
    extends BasicArrowButton {
        public WindowsArrowButton(int direction, Color background, Color shadow, Color darkShadow, Color highlight) {
            super(direction, background, shadow, darkShadow, highlight);
        }

        public WindowsArrowButton(int direction) {
            super(direction);
        }

        @Override
        public void paint(Graphics g) {
            NLXPStyle xp = NLXPStyle.getXP();
            if (xp != null) {
                ButtonModel model = this.getModel();
                NLXPStyle.Skin skin = xp.getSkin(NLScrollBarUI.this.scrollbar, NLTMSchema.Part.SBP_ARROWBTN);
                NLTMSchema.State state = null;
                if (model.isArmed() && model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = NLTMSchema.State.UPPRESSED;
                            break;
                        }
                        case 5: {
                            state = NLTMSchema.State.DOWNPRESSED;
                            break;
                        }
                        case 7: {
                            state = NLTMSchema.State.LEFTPRESSED;
                            break;
                        }
                        case 3: {
                            state = NLTMSchema.State.RIGHTPRESSED;
                        }
                    }
                } else if (!model.isEnabled()) {
                    switch (this.direction) {
                        case 1: {
                            state = NLTMSchema.State.UPDISABLED;
                            break;
                        }
                        case 5: {
                            state = NLTMSchema.State.DOWNDISABLED;
                            break;
                        }
                        case 7: {
                            state = NLTMSchema.State.LEFTDISABLED;
                            break;
                        }
                        case 3: {
                            state = NLTMSchema.State.RIGHTDISABLED;
                        }
                    }
                } else if (model.isRollover() || model.isPressed()) {
                    switch (this.direction) {
                        case 1: {
                            state = NLTMSchema.State.UPHOT;
                            break;
                        }
                        case 5: {
                            state = NLTMSchema.State.DOWNHOT;
                            break;
                        }
                        case 7: {
                            state = NLTMSchema.State.LEFTHOT;
                            break;
                        }
                        case 3: {
                            state = NLTMSchema.State.RIGHTHOT;
                        }
                    }
                } else {
                    switch (this.direction) {
                        case 1: {
                            state = NLTMSchema.State.UPNORMAL;
                            break;
                        }
                        case 5: {
                            state = NLTMSchema.State.DOWNNORMAL;
                            break;
                        }
                        case 7: {
                            state = NLTMSchema.State.LEFTNORMAL;
                            break;
                        }
                        case 3: {
                            state = NLTMSchema.State.RIGHTNORMAL;
                        }
                    }
                }
                Graphics2D g2 = (Graphics2D)g;
                switch (this.direction) {
                    case 1: {
                        NL9IconFactory.getInstance().getScrollBarArrow_toTop().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    case 5: {
                        NL9IconFactory.getInstance().getScrollBarArrow_toBottom().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    case 7: {
                        NL9IconFactory.getInstance().getScrollBarArrow_toLeft().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                        break;
                    }
                    case 3: {
                        NL9IconFactory.getInstance().getScrollBarArrow_toRight().draw(g2, 0, 0, this.getWidth(), this.getHeight());
                    }
                }
            } else {
                super.paint(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            int size = 16;
            if (NLScrollBarUI.this.scrollbar != null) {
                switch (NLScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        size = NLScrollBarUI.this.scrollbar.getWidth();
                        break;
                    }
                    case 0: {
                        size = NLScrollBarUI.this.scrollbar.getHeight();
                    }
                }
                size = Math.max(size, 5);
            }
            return new Dimension(size, size);
        }
    }
}

