/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class PropertyMan {
    private Properties property = null;
    private String filePath = "c:/null.properties";
    private File propertyFile = null;

    public PropertyMan(String propertyFilePath) {
        this.filePath = propertyFilePath;
    }

    public double getDouble(String key) {
        return Double.valueOf(this.getProperty(key));
    }

    public double getDouble(String key, double defaultValue) {
        return Double.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public int getInt(String key) {
        return Integer.valueOf(this.getProperty(key));
    }

    public int getBoolean(String key, int defaultValue) {
        return Integer.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public Boolean getBoolean(String key) {
        return Boolean.valueOf(this.getProperty(key));
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getProperty(key, String.valueOf(defaultValue)));
    }

    public String getProperty(String key) {
        return this.getPropertyInstance().getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyInstance().getProperty(key, defaultValue);
    }

    public void saveProperty(String key, String value) {
        this.saveProperty(key, value, null, true);
    }

    public void saveProperty(String key, String value, String comments) {
        this.saveProperty(key, value, comments, true);
    }

    public void saveProperty(String key, String value, String comments, boolean createIfNotExist) {
        this.getPropertyInstance(createIfNotExist).setProperty(key, value);
        try {
            FileOutputStream fos = new FileOutputStream(this.propertyFile);
            this.getPropertyInstance(createIfNotExist).store(fos, comments);
            fos.close();
        }
        catch (Exception e) {
            System.out.println("\u4fdd\u5b58\u5c5e\u6027\u65f6\uff1a" + this.filePath + "\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    protected Properties getPropertyInstance() {
        return this.getPropertyInstance(true);
    }

    protected Properties getPropertyInstance(boolean createIfNotExist) {
        if (this.propertyFile == null) {
            this.propertyFile = new File(this.filePath);
            if (!this.propertyFile.exists() && createIfNotExist) {
                new File(this.propertyFile.getParent()).mkdirs();
                try {
                    this.propertyFile.createNewFile();
                }
                catch (Exception e) {
                    System.out.println("\u521b\u5efa\u5c5e\u6027\u6587\u4ef6\uff1a" + this.filePath + "\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
                }
                this.propertyFile = new File(this.filePath);
            }
            try {
                if (this.property == null) {
                    this.property = new Properties();
                }
                FileInputStream fis = new FileInputStream(this.propertyFile);
                this.property.load(fis);
                fis.close();
            }
            catch (Exception e) {
                System.out.println("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6\uff1a" + this.filePath + "\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        return this.property;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

