/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.util;

import java.util.Calendar;
import java.util.Date;

public class CalendarHelper {
    public static Calendar calendar(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static Date tomorrow(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date dateAdd(Date d, int i) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.add(5, i);
        return cal.getTime();
    }

    public static Date yearAfter(Date d, int i) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.add(1, i);
        return cal.getTime();
    }

    public static Date monthAfter(Date d, int i) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.add(2, i);
        return cal.getTime();
    }

    public static Date today() {
        return new Date();
    }

    public static Date yesterday(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date toDayStart(Date d) {
        return CalendarHelper.toDayStart(CalendarHelper.calendar(d));
    }

    public static Date toDayMiddle(Date d) {
        return CalendarHelper.toDayMiddle(CalendarHelper.calendar(d));
    }

    public static Date toDayEnd(Date d) {
        return CalendarHelper.toDayEnd(CalendarHelper.calendar(d));
    }

    public static Date toDayStart(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date toDayMiddle(Calendar cal) {
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date toDayEnd(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static int weekOfMonth(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        return cal.get(4);
    }

    public static int weekOfYear(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        return cal.get(3);
    }

    public static Date absMonthEndDate(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        return CalendarHelper.toDayEnd(cal);
    }

    public static Date yearStartDate(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        cal.set(6, 1);
        return CalendarHelper.toDayStart(cal);
    }

    public static Date yearEndDate(Date d) {
        Calendar cal = CalendarHelper.calendar(d);
        int last = cal.getActualMaximum(6);
        cal.set(6, last);
        return CalendarHelper.toDayEnd(cal);
    }

    public static boolean isSameYear(Date d1, Date d2) {
        Calendar cal1 = CalendarHelper.calendar(d1);
        Calendar cal2 = CalendarHelper.calendar(d2);
        return cal1.get(1) == cal2.get(1);
    }

    public static boolean isSameMonth(Date d1, Date d2) {
        Calendar cal1 = CalendarHelper.calendar(d1);
        Calendar cal2 = CalendarHelper.calendar(d2);
        return cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameWeek(Date d1, Date d2) {
        Calendar cal1 = CalendarHelper.calendar(d1);
        Calendar cal2 = CalendarHelper.calendar(d2);
        return cal1.get(1) == cal2.get(1) && cal1.get(3) == cal2.get(3);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        Calendar cal1 = CalendarHelper.calendar(d1);
        Calendar cal2 = CalendarHelper.calendar(d2);
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }
}

