/*
 * Decompiled with CFR 0.152.
 */
package com.eva.epc.common.file;

import com.eva.epc.common.util.CommonUtils;
import com.eva.epc.common.util.SimpleLogger;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileHelper {
    public static Object readObjectFromFile(String filePath) throws Exception {
        if (CommonUtils.isStringEmpty(filePath, true)) {
            throw new Exception("\u8981\u8bfb\u53d6\u7684\u6587\u4ef6\u8def\u5f84\u662f\u65e0\u6548\u53c2\u6570.");
        }
        Object obj = null;
        try {
            FileInputStream fis = new FileInputStream(filePath);
            ObjectInputStream ois = new ObjectInputStream(fis);
            obj = ois.readObject();
        }
        catch (FileNotFoundException e) {
            throw new Exception("\u8981\u8bfb\u53d6\u7684\u6587\u4ef6\u662f\u4e2a\u76ee\u5f55\u6216\u4e0d\u5b58\u6216\u5176\u5b83\u539f\u56e0," + e.getMessage());
        }
        catch (Exception ee) {
            throw ee;
        }
        return obj;
    }

    public static Object readObjectFromFile(File file) throws Exception {
        if (file == null || file.isDirectory() || !file.exists()) {
            return null;
        }
        return FileHelper.readObjectFromFile(file.getAbsolutePath());
    }

    public static boolean writeObjectToFile(String filePath, Object obj) throws Exception {
        boolean isSuccess = false;
        if (obj == null || CommonUtils.isStringEmpty(filePath, true)) {
            throw new Exception("\u8981\u5b58\u653e\u7684\u6587\u4ef6\u8def\u5f84\u6216\u8981\u5199\u5165\u7684\u5bf9\u8c61\u662f\u65e0\u6548\u53c2\u6570.");
        }
        if (!(obj instanceof Serializable)) {
            throw new RuntimeException("\u8981\u5199\u5165\u7684\u5bf9\u8c61\u6ca1\u6709\u5e8f\u5217\u5316\uff01");
        }
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
            fos.flush();
            oos.close();
            fos.close();
            isSuccess = true;
        }
        catch (FileNotFoundException e) {
            throw new Exception("\u4e0d\u80fd\u6253\u5f00\u8981\u5199\u5165\u7684\u8bed\u8a00\u4ef6\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\u8be5\u8def\u5f84\u6307\u660e\u7684\u662f\u4e00\u4e2a\u76ee\u5f55\u6216\u6587\u4ef6\u4e0d\u5b58\u5728\u4e14\u4e0d\u80fd\u5efa\u7acb\uff0c\u6216\u5176\u5b83\u539f\u56e0," + e.getMessage());
        }
        catch (Exception ee) {
            throw ee;
        }
        return isSuccess;
    }

    public static void writeStringToFile(String content, String filePath) throws Exception {
        FileHelper.writeStringToFile(content, filePath, true);
    }

    public static void writeStringToFile(String content, String filePath, boolean overideIfExists) throws Exception {
        if (content == null || filePath == null) {
            throw new Exception("\u65e0\u6548\u53c2\u6570\u5f02\u5e38,content=" + content + ",filePath=" + filePath);
        }
        File file = new File(filePath);
        if (file.exists() && !overideIfExists) {
            throw new Exception("\u8981\u4fdd\u5b58\u7684\u6587\u4ef6\u540d\uff1a" + file.getAbsolutePath() + "\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff0c\u5199\u5165\u5931\u8d25\uff01");
        }
        file.createNewFile();
        FileWriter fw = new FileWriter(file.getAbsolutePath(), false);
        fw.write(content);
        fw.close();
    }

    public static boolean isFileExist(String filePath) {
        File f = null;
        try {
            f = new File(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f.exists();
    }

    public static void saveFile(Component parent, FileFilter ffilter, String source) {
        int rVal;
        JFileChooser c = new JFileChooser();
        if (ffilter != null) {
            c.setFileFilter(ffilter);
        }
        if ((rVal = c.showSaveDialog(parent)) == 0) {
            String filename = c.getSelectedFile().getAbsolutePath();
            try {
                File file;
                if (filename.lastIndexOf(46) < 0) {
                    filename = String.valueOf(filename) + ".xls";
                }
                if (!(file = new File(filename)).exists()) {
                    file.createNewFile();
                }
                FileOutputStream fo = new FileOutputStream(file);
                fo.write(source.getBytes());
                fo.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static byte[] readFileWithBytes(File f) throws Exception {
        try {
            return FileHelper.readFileWithBytes(new FileInputStream(f));
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static byte[] readFileWithBytes(InputStream is) {
        try {
            byte[] data = new byte[is.available()];
            is.read(data);
            is.close();
            return data;
        }
        catch (IOException ex) {
            SimpleLogger.w("\u6570\u636e\u8bfb\u53d6\u5931\u8d25\uff01");
            return null;
        }
    }

    public static void writeFileWithBytes(byte[] bytes, String saveToPath, boolean renameIfExist) {
        try {
            File f = new File(saveToPath);
            if (f.exists() && renameIfExist) {
                String fileNameWithoutExt = FileHelper.getFileNameWithoutExt(saveToPath);
                String fileName = FileHelper.getFileName(saveToPath);
                int index = saveToPath.lastIndexOf(fileName);
                String dir = saveToPath.substring(0, index);
                f = new File(String.valueOf(dir) + fileNameWithoutExt + "(" + CommonUtils.getDateWithStr() + "+" + CommonUtils.getTimeWithStr("-") + ")." + FileHelper.getFileExName(fileName));
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bytes);
            fos.close();
        }
        catch (IOException e) {
            SimpleLogger.w("--\u51fa\u9519\u4e86," + e.getMessage());
        }
    }

    public static String getFileName(String filePath) {
        return filePath.substring(filePath.lastIndexOf("\\") + 1, filePath.length());
    }

    public static String getFileNameWithoutExt(String filePath) {
        String ext;
        String fileName = FileHelper.getFileName(filePath);
        int index = fileName.lastIndexOf(ext = FileHelper.getFileExName(fileName));
        if (index != -1) {
            return fileName.substring(0, index - 1);
        }
        return fileName;
    }

    public static String getFileExName(File f) {
        return FileHelper.getFileExName(f.getName());
    }

    public static String getFileExName(String fileName) {
        String exName = "";
        int pos = fileName.lastIndexOf(".");
        if (pos == -1) {
            SimpleLogger.w("\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d:" + fileName);
        } else {
            exName = fileName.substring(pos + 1, fileName.length());
        }
        return exName;
    }

    public static boolean deleteFile(String filePath) {
        boolean isSucess = true;
        try {
            File f = new File(filePath);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            isSucess = false;
        }
        return isSucess;
    }
}

