/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.ServerLauncher;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.GatewayUDP;
import net.x52im.mobileimsdk.server.network.MBObserver;
import net.x52im.mobileimsdk.server.processor.OnlineProcessor;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.qos.QoS4SendDaemonS2C;
import net.x52im.mobileimsdk.server.utils.ServerToolKits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSendHelper {
    private static Logger logger = LoggerFactory.getLogger(ServerCoreHandler.class);

    public static void sendData(String to_user_id, String dataContent, MBObserver resultObserver) throws Exception {
        LocalSendHelper.sendData(to_user_id, dataContent, true, null, -1, resultObserver);
    }

    public static void sendData(String to_user_id, String dataContent, int typeu, MBObserver resultObserver) throws Exception {
        LocalSendHelper.sendData(to_user_id, dataContent, true, null, typeu, resultObserver);
    }

    public static void sendData(String to_user_id, String dataContent, boolean QoS, int typeu, MBObserver resultObserver) throws Exception {
        LocalSendHelper.sendData(to_user_id, dataContent, QoS, null, typeu, resultObserver);
    }

    public static void sendData(String to_user_id, String dataContent, boolean QoS, String fingerPrint, MBObserver resultObserver) throws Exception {
        LocalSendHelper.sendData(to_user_id, dataContent, QoS, fingerPrint, -1, resultObserver);
    }

    public static void sendData(String to_user_id, String dataContent, boolean QoS, String fingerPrint, int typeu, MBObserver resultObserver) throws Exception {
        LocalSendHelper.sendData(ProtocalFactory.createCommonData(dataContent, "0", to_user_id, QoS, fingerPrint, typeu), resultObserver);
    }

    public static void sendData(Protocal p, MBObserver resultObserver) throws Exception {
        if (p != null) {
            if (!"0".equals(p.getTo())) {
                LocalSendHelper.sendData(OnlineProcessor.getInstance().getOnlineSession(p.getTo()), p, resultObserver);
            } else {
                logger.warn("[IMCORE]\u3010\u6ce8\u610f\u3011\u6b64Protocal\u5bf9\u8c61\u4e2d\u7684\u63a5\u6536\u65b9\u662f\u670d\u52a1\u5668(user_id==0)\uff08\u800c\u6b64\u65b9\u6cd5\u672c\u6765\u5c31\u662f\u7531Server\u8c03\u7528\uff0c\u81ea\u5df2\u53d1\u81ea\u5df2\u4e0d\u53ef\u80fd\uff01\uff09\uff0c\u6570\u636e\u53d1\u9001\u6ca1\u6709\u7ee7\u7eed\uff01" + p.toGsonString());
                if (resultObserver != null) {
                    resultObserver.update(false, null);
                }
            }
        } else if (resultObserver != null) {
            resultObserver.update(false, null);
        }
    }

    public static void sendData(final Channel session, final Protocal p, final MBObserver resultObserver) throws Exception {
        if (session == null) {
            logger.info("[IMCORE-{}]toSession==null >> id={}\u7684\u7528\u6237\u5c1d\u8bd5\u53d1\u7ed9\u5ba2\u6237\u7aef{}\u7684\u6d88\u606f\uff1astr={}\u56e0\u63a5\u6536\u65b9\u7684id\u5df2\u4e0d\u5728\u7ebf\uff0c\u6b64\u6b21\u5b9e\u65f6\u53d1\u9001\u6ca1\u6709\u7ee7\u7eed(\u6b64\u6d88\u606f\u5e94\u8003\u8651\u4f5c\u79bb\u7ebf\u5904\u7406\u54e6).", new Object[]{Gateway.$(session), p.getFrom(), p.getTo(), p.getDataContent()});
        } else if (session.isActive()) {
            if (p != null) {
                Object res;
                if (ServerLauncher.serverTimestamp) {
                    p.setSm(Protocal.genServerTimestamp());
                }
                ByteBuf to = null;
                if (Gateway.isWebSocketChannel(session)) {
                    res = p.toGsonString();
                    to = new TextWebSocketFrame((String)res);
                } else {
                    res = p.toBytes();
                    to = Unpooled.copiedBuffer((byte[])res);
                }
                ChannelFuture cf = session.writeAndFlush((Object)to);
                cf.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            if (p.isQoS() && !QoS4SendDaemonS2C.getInstance().exist(p.getFp())) {
                                QoS4SendDaemonS2C.getInstance().put(p);
                            }
                        } else {
                            logger.warn("[IMCORE-{}]\u7ed9\u5ba2\u6237\u7aef\uff1a{}\u7684\u6570\u636e->{},\u53d1\u9001\u5931\u8d25\uff01(\u6b64\u6d88\u606f\u5e94\u8003\u8651\u4f5c\u79bb\u7ebf\u5904\u7406\u54e6).", new Object[]{Gateway.$(session), ServerToolKits.clientInfoToString(session), p.toGsonString()});
                        }
                        if (resultObserver != null) {
                            resultObserver.update(future.isSuccess(), null);
                        }
                    }
                });
                return;
            }
            logger.warn("[IMCORE-{}]\u5ba2\u6237\u7aefid={}\u8981\u53d1\u7ed9\u5ba2\u6237\u7aef{}\u7684\u5b9e\u65f6\u6d88\u606f\uff1astr={}\u6ca1\u6709\u7ee7\u7eed(\u6b64\u6d88\u606f\u5e94\u8003\u8651\u4f5c\u79bb\u7ebf\u5904\u7406\u54e6).", new Object[]{Gateway.$(session), p.getFrom(), p.getTo(), p.getDataContent()});
        }
        if (resultObserver != null) {
            resultObserver.update(false, null);
        }
    }

    public static void replyDataForUnlogined(final Channel session, Protocal p, MBObserver resultObserver) throws Exception {
        logger.warn("[IMCORE-{}]>> \u5ba2\u6237\u7aef{}\u5c1a\u672a\u767b\u9646\uff0c{}\u5904\u7406\u672a\u7ee7\u7eed.", new Object[]{Gateway.$(session), ServerToolKits.clientInfoToString(session), p.getDataContent()});
        if (resultObserver == null) {
            resultObserver = new MBObserver(){

                @Override
                public void update(boolean sendOK, Object extraObj) {
                    logger.warn("[IMCORE-{}]>> \u5ba2\u6237\u7aef{}\u672a\u767b\u9646\uff0c\u670d\u52a1\u7aef\u53cd\u9988\u53d1\u9001\u6210\u529f\uff1f{}\uff08\u4f1a\u8bdd\u5373\u5c06\u5173\u95ed\uff09", new Object[]{Gateway.$(session), ServerToolKits.clientInfoToString(session), sendOK});
                    if (!GatewayUDP.isUDPChannel(session)) {
                        session.close();
                    }
                }
            };
        }
        Protocal perror = ProtocalFactory.createPErrorResponse(301, p.toGsonString(), "-1");
        LocalSendHelper.sendData(session, perror, resultObserver);
    }

    public static void replyRecievedBack(Channel session, Protocal pFromClient, MBObserver resultObserver) throws Exception {
        if (pFromClient.isQoS() && pFromClient.getFp() != null) {
            Protocal receivedBackP = ProtocalFactory.createRecivedBack(pFromClient.getTo(), pFromClient.getFrom(), pFromClient.getFp());
            LocalSendHelper.sendData(session, receivedBackP, resultObserver);
        } else {
            logger.warn("[IMCORE-{}]\u6536\u5230{}\u53d1\u8fc7\u6765\u9700\u8981QoS\u7684\u5305\uff0c\u4f46\u5b83\u7684\u6307\u7eb9\u7801\u5374\u4e3anull\uff01\u65e0\u6cd5\u53d1\u4f2a\u5e94\u7b54\u5305\u54e6\uff01", (Object)Gateway.$(session), (Object)pFromClient.getFrom());
            if (resultObserver != null) {
                resultObserver.update(false, null);
            }
        }
    }

    public static void sendKickout(final Channel sessionBeKick, String to_user_id, final int code, String reason) throws Exception {
        MBObserver sendResultObserver = new MBObserver(){

            @Override
            public void update(boolean sendOK, Object extraObj) {
                logger.warn("[IMCORE-{}]>> \u5ba2\u6237\u7aef{}\u7684\u88ab\u8e22\u6307\u4ee4\u53d1\u9001\u6210\u529f\uff1f{}\uff08\u4f1a\u8bdd\u5373\u5c06\u5173\u95ed\uff09", new Object[]{Gateway.$(sessionBeKick), ServerToolKits.clientInfoToString(sessionBeKick), sendOK});
                if (!GatewayUDP.isUDPChannel(sessionBeKick)) {
                    OnlineProcessor.setBeKickoutCodeForChannel(sessionBeKick, code);
                    sessionBeKick.close();
                }
            }
        };
        LocalSendHelper.sendData(sessionBeKick, ProtocalFactory.createPKickout(to_user_id, code, reason), sendResultObserver);
    }
}

