/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.processor;

import net.x52im.mobileimsdk.server.bridge.MQProvider;
import net.x52im.mobileimsdk.server.network.MBObserver;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;
import net.x52im.mobileimsdk.server.utils.LocalSendHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BridgeProcessor
extends MQProvider {
    private static Logger logger = LoggerFactory.getLogger(BridgeProcessor.class);
    public static final String IMMQ_DECODE_CHARSET = "UTF-8";
    public static String IMMQ_URI = "amqp://js:19844713@192.168.1.190";
    public static String IMMQ_QUEUE_WEB2APP = "q_web2app";
    public static String IMMQ_QUEUE_APP2WEB = "q_app2web";

    public BridgeProcessor() {
        super(IMMQ_URI, IMMQ_QUEUE_APP2WEB, IMMQ_QUEUE_WEB2APP, "IMMQ", false);
    }

    @Override
    protected boolean work(byte[] contentBody) {
        try {
            String msg = new String(contentBody, IMMQ_DECODE_CHARSET);
            logger.info("[IMCORE-\u6865\u63a5\u2193] - [startWorker()\u4e2d] \u6536\u5230\u5f02\u6784\u670d\u52a1\u5668\u7684\u539f\u59cb msg\uff1a" + msg + ", \u5373\u65f6\u8fdb\u884c\u89e3\u6790\u5e76\u6865\u63a5\u8f6c\u53d1\uff08\u7ed9\u63a5\u6536\u8005\uff09...");
            final Protocal p = ProtocalFactory.parse(msg, Protocal.class);
            p.setQoS(true);
            p.setBridge(true);
            MBObserver sendResultObserver = new MBObserver(){

                @Override
                public void update(boolean sendOK, Object extraObj) {
                    if (sendOK) {
                        BridgeProcessor.this.realtimeC2CSuccessCallback(p);
                        logger.info("[IMCORE-\u6865\u63a5\u2193] - " + p.getFrom() + "\u53d1\u7ed9" + p.getTo() + "\u7684\u6307\u7eb9\u4e3a" + p.getFp() + "\u7684\u6d88\u606f\u8f6c\u53d1\u6210\u529f\uff01\u3010\u7b2c\u4e00\u9636\u6bb5APP+WEB\u8de8\u673a\u901a\u4fe1\u7b97\u6cd5\u3011");
                    } else {
                        logger.info("[IMCORE-\u6865\u63a5\u2193]>> \u5ba2\u6237\u7aef" + p.getFrom() + "\u53d1\u9001\u7ed9" + p.getTo() + "\u7684\u6865\u63a5\u6570\u636e\u5c1d\u8bd5\u5b9e\u65f6\u53d1\u9001\u6ca1\u6709\u6210\u529f(" + p.getTo() + "\u4e0d\u5728\u7ebf)\uff0c\u5c06\u4ea4\u7ed9\u5e94\u7528\u5c42\u8fdb\u884c\u79bb\u7ebf\u5b58\u50a8\u54e6... \u3010\u7b2c\u4e00\u9636\u6bb5APP+WEB\u8de8\u673a\u901a\u4fe1\u7b97\u6cd5\u3011");
                        boolean offlineProcessedOK = BridgeProcessor.this.offlineC2CProcessCallback(p);
                        if (offlineProcessedOK) {
                            logger.debug("[IMCORE-\u6865\u63a5\u2193]>> \u5411" + p.getFrom() + "\u53d1\u9001" + p.getFp() + "\u7684\u6d88\u606f\u3010\u79bb\u7ebf\u5904\u7406\u3011\u6210\u529f,from=" + p.getTo() + ". \u3010\u7b2c\u4e00\u9636\u6bb5APP+WEB\u8de8\u673a\u901a\u4fe1\u7b97\u6cd5\u3011");
                        } else {
                            logger.warn("[IMCORE-\u6865\u63a5\u2193]>> \u5ba2\u6237\u7aef" + p.getFrom() + "\u53d1\u9001\u7ed9" + p.getTo() + "\u7684\u6865\u63a5\u6570\u636e\u4f20\u8f93\u6d88\u606f\u5c1d\u8bd5\u5b9e\u65f6\u53d1\u9001\u6ca1\u6709\u6210\u529f\uff0c\u4f46\u4e0a\u5c42\u5e94\u7528\u5c42\u6ca1\u6709\u6210\u529f(\u6216\u8005\u5b8c\u5168\u6ca1\u6709)\u8fdb\u884c\u79bb\u7ebf\u5b58\u50a8\uff0c\u6b64\u6d88\u606f\u5c06\u88ab\u670d\u52a1\u7aef\u4e22\u5f03\uff01 \u3010\u7b2c\u4e00\u9636\u6bb5APP+WEB\u8de8\u673a\u901a\u4fe1\u7b97\u6cd5\u3011");
                        }
                    }
                }
            };
            LocalSendHelper.sendData(p, sendResultObserver);
            return true;
        }
        catch (Exception e) {
            logger.warn("[IMCORE-\u6865\u63a5\u2193] - [startWorker()\u4e2d] work()\u65b9\u6cd5\u51fa\u9519\uff0c\u672c\u6761\u9519\u8bef\u6d88\u606f\u88ab\u8bb0\u5f55\uff1a" + e.getMessage(), (Throwable)e);
            return true;
        }
    }

    protected abstract void realtimeC2CSuccessCallback(Protocal var1);

    protected abstract boolean offlineC2CProcessCallback(Protocal var1);
}

