/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.tcp.MBTCPClientInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayTCP
extends Gateway {
    private static Logger logger = LoggerFactory.getLogger(GatewayTCP.class);
    public static int PORT = 8901;
    public static int SESION_RECYCLER_EXPIRE = 20;
    public static int TCP_FRAME_FIXED_HEADER_LENGTH = 4;
    public static int TCP_FRAME_MAX_BODY_LENGTH = 6144;
    public static SslContext sslContext = null;
    protected final EventLoopGroup __bossGroup4Netty = new NioEventLoopGroup(1);
    protected final EventLoopGroup __workerGroup4Netty = new NioEventLoopGroup();
    protected Channel __serverChannel4Netty = null;
    protected ServerBootstrap bootstrap = null;

    @Override
    public void init(ServerCoreHandler serverCoreHandler) {
        this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.__bossGroup4Netty, this.__workerGroup4Netty).channel(NioServerSocketChannel.class)).childHandler(this.initChildChannelHandler(serverCoreHandler));
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)4096);
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
    }

    @Override
    public void bind() throws Exception {
        ChannelFuture cf = this.bootstrap.bind(PORT).sync();
        if (cf.isSuccess()) {
            logger.info("[IMCORE-tcp] \u57fa\u4e8eMobileIMSDK\u7684TCP\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u6210\u529f \u221a " + (GatewayTCP.isSsl() ? "(\u5df2\u5f00\u542fSSL/TLS\u52a0\u5bc6\u4f20\u8f93)" : ""));
        } else {
            logger.info("[IMCORE-tcp] \u57fa\u4e8eMobileIMSDK\u7684TCP\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u5931\u8d25 \u00d7");
        }
        this.__serverChannel4Netty = cf.channel();
        this.__serverChannel4Netty.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                GatewayTCP.this.__bossGroup4Netty.shutdownGracefully();
                GatewayTCP.this.__workerGroup4Netty.shutdownGracefully();
            }
        });
        logger.info("[IMCORE-tcp] .... continue ...");
        logger.info("[IMCORE-tcp] \u57fa\u4e8eMobileIMSDK\u7684TCP\u670d\u52a1\u6b63\u5728\u7aef\u53e3" + PORT + "\u4e0a\u76d1\u542c\u4e2d...");
    }

    @Override
    public void shutdown() {
        if (this.__serverChannel4Netty != null) {
            this.__serverChannel4Netty.close();
        }
    }

    protected ChannelHandler initChildChannelHandler(final ServerCoreHandler serverCoreHandler) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (sslContext != null) {
                    pipeline.addFirst(new ChannelHandler[]{sslContext.newHandler(channel.alloc())});
                }
                pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(TCP_FRAME_FIXED_HEADER_LENGTH + TCP_FRAME_MAX_BODY_LENGTH, 0, TCP_FRAME_FIXED_HEADER_LENGTH, 0, TCP_FRAME_FIXED_HEADER_LENGTH));
                pipeline.addLast("frameEncoder", (ChannelHandler)new LengthFieldPrepender(TCP_FRAME_FIXED_HEADER_LENGTH));
                pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(SESION_RECYCLER_EXPIRE)});
                pipeline.addLast(new ChannelHandler[]{new MBTCPClientInboundHandler(serverCoreHandler)});
            }
        };
    }

    public static boolean isSsl() {
        return sslContext != null;
    }
}

