/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.android.utils;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MBThreadPoolExecutor {
    private static final String TAG = MBThreadPoolExecutor.class.getSimpleName();
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 30L;
    private static final int WAIT_COUNT = 128;
    private static ThreadPoolExecutor pool = MBThreadPoolExecutor.createThreadPoolExecutor();
    private static ExecutorService jobsForUI = Executors.newFixedThreadPool(CORE_POOL_SIZE, new CThreadFactory("MBJobsForUI", 4));
    private static Thread mainThread;
    private static Handler mainHandler;
    private static HashMap<Runnable, Runnable> mapToMainHandler;

    private static ThreadPoolExecutor createThreadPoolExecutor() {
        if (pool == null) {
            pool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new CThreadFactory("MBThreadPool", 3), new CHandlerException());
        }
        return pool;
    }

    public static void runInBackground(Runnable runnable) {
        if (pool == null) {
            MBThreadPoolExecutor.createThreadPoolExecutor();
        }
        pool.execute(runnable);
    }

    public static boolean isOnMainThread() {
        return mainThread == Thread.currentThread();
    }

    public static void runOnMainThread(Runnable r) {
        if (MBThreadPoolExecutor.isOnMainThread()) {
            r.run();
        } else {
            mainHandler.post(r);
        }
    }

    public static void runOnMainThread(Runnable r, long delayMillis) {
        if (delayMillis <= 0L) {
            MBThreadPoolExecutor.runOnMainThread(r);
        } else {
            mainHandler.postDelayed(r, delayMillis);
        }
    }

    public static void runInBackground(Runnable runnable, long delayMillis) {
        if (delayMillis <= 0L) {
            MBThreadPoolExecutor.runInBackground(runnable);
        } else {
            Runnable mainRunnable = () -> {
                mapToMainHandler.remove(runnable);
                pool.execute(runnable);
            };
            if (mapToMainHandler.containsKey(runnable)) {
                Log.d((String)TAG, (String)("\u8be5runnable\uff08" + runnable + "\uff09\u4ecd\u5728mapToMainHandler\u4e2d\uff0c\u8868\u793a\u5b83\u5e76\u672a\u88ab\u6267\u884c\uff0c\u5c06\u5148\u4ecemainHandler\u4e2d\u79fb\u9664\uff0c\u5426\u5219\u5b58\u5728\u4e0a\u6b21\u5ef6\u8fdf\u6267\u884c\u5e76\u672a\u5b8c\u6210\uff0c\u672c\u6b21\u53c8\u518d\u6b21\u63d0\u4ea4\u5ef6\u8fdf\u6267\u884c\u4efb\u52a1\uff0c\u5931\u53bb\u4e86\u5ef6\u8fdf\u6267\u884c\u7684\u610f\u4e49\uff01"));
                MBThreadPoolExecutor.removeCallbackInBackground(runnable);
            }
            mapToMainHandler.put(runnable, mainRunnable);
            mainHandler.postDelayed(mainRunnable, delayMillis);
        }
    }

    public static void removeCallbackOnMainThread(Runnable r) {
        mainHandler.removeCallbacks(r);
    }

    public static void removeCallbackInBackground(Runnable runnable) {
        Runnable mainRunnable = mapToMainHandler.get(runnable);
        if (mainRunnable != null) {
            mainHandler.removeCallbacks(mainRunnable);
            pool.remove(mainRunnable);
        } else {
            pool.remove(runnable);
        }
    }

    public static void logStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("getActiveCount=");
        sb.append(pool.getActiveCount());
        sb.append("\ngetTaskCount=");
        sb.append(pool.getTaskCount());
        sb.append("\ngetCompletedTaskCount=");
        sb.append(pool.getCompletedTaskCount());
        Log.d((String)TAG, (String)sb.toString());
    }

    public static StringBuilder logAllThreadStackTrace() {
        StringBuilder builder = new StringBuilder();
        Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
        for (Thread key : liveThreads.keySet()) {
            builder.append("Thread ").append(key.getName()).append("\n");
            StackTraceElement[] trace = liveThreads.get(key);
            for (int j = 0; j < trace.length; ++j) {
                builder.append("\tat ").append(trace[j]).append("\n");
            }
        }
        return builder;
    }

    static {
        Looper mainLooper = Looper.getMainLooper();
        mainThread = mainLooper.getThread();
        mainHandler = new Handler(mainLooper);
        mapToMainHandler = new HashMap();
    }

    public static class CThreadFactory
    implements ThreadFactory {
        private AtomicInteger counter = new AtomicInteger(1);
        private String prefix = "";
        private int priority = 5;

        public CThreadFactory(String prefix, int priority) {
            this.prefix = prefix;
            this.priority = priority;
        }

        public CThreadFactory(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread executor = new Thread(r, this.prefix + " #" + this.counter.getAndIncrement());
            executor.setDaemon(true);
            executor.setPriority(this.priority);
            return executor;
        }
    }

    private static class CHandlerException
    extends ThreadPoolExecutor.AbortPolicy {
        private CHandlerException() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            Log.d((String)TAG, (String)("rejectedExecution:" + r));
            Log.e((String)TAG, (String)MBThreadPoolExecutor.logAllThreadStackTrace().toString());
            if (!pool.isShutdown()) {
                pool.shutdown();
                pool = null;
            }
            pool = MBThreadPoolExecutor.createThreadPoolExecutor();
        }
    }
}

