/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.utils;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import net.x52im.mobileimsdk.server.network.GatewayTCP;
import net.x52im.mobileimsdk.server.network.GatewayUDP;
import net.x52im.mobileimsdk.server.network.GatewayWebsocket;
import net.x52im.mobileimsdk.server.processor.OnlineProcessor;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.protocal.ProtocalFactory;

public class ServerToolKits {
    public static void setSenseModeTCP(SenseModeTCP mode) {
        int expire = 0;
        switch (mode) {
            case MODE_3S: {
                expire = 7;
                break;
            }
            case MODE_5S: {
                expire = 11;
                break;
            }
            case MODE_10S: {
                expire = 15;
                break;
            }
            case MODE_15S: {
                expire = 20;
                break;
            }
            case MODE_30S: {
                expire = 35;
                break;
            }
            case MODE_60S: {
                expire = 65;
                break;
            }
            case MODE_120S: {
                expire = 125;
            }
        }
        if (expire > 0) {
            GatewayTCP.SESION_RECYCLER_EXPIRE = expire;
        }
    }

    public static void setSenseModeUDP(SenseModeUDP mode) {
        int expire = 0;
        switch (mode) {
            case MODE_3S: {
                expire = 10;
                break;
            }
            case MODE_10S: {
                expire = 21;
                break;
            }
            case MODE_30S: {
                expire = 62;
                break;
            }
            case MODE_60S: {
                expire = 122;
                break;
            }
            case MODE_120S: {
                expire = 242;
            }
        }
        if (expire > 0) {
            GatewayUDP.SESION_RECYCLER_EXPIRE = expire;
        }
    }

    public static void setSenseModeWebsocket(SenseModeWebsocket mode) {
        int expire = 0;
        switch (mode) {
            case MODE_3S: {
                expire = 7;
                break;
            }
            case MODE_5S: {
                expire = 11;
                break;
            }
            case MODE_10S: {
                expire = 15;
                break;
            }
            case MODE_15S: {
                expire = 20;
                break;
            }
            case MODE_30S: {
                expire = 35;
                break;
            }
            case MODE_60S: {
                expire = 65;
                break;
            }
            case MODE_120S: {
                expire = 125;
            }
        }
        if (expire > 0) {
            GatewayWebsocket.SESION_RECYCLER_EXPIRE = expire;
        }
    }

    public static String clientInfoToString(Channel session) {
        SocketAddress remoteAddress = session.remoteAddress();
        String s1 = remoteAddress.toString();
        StringBuilder sb = new StringBuilder().append("{uid:").append(OnlineProcessor.getUserIdFromChannel(session)).append("}").append(s1);
        return sb.toString();
    }

    public static String fromIOBuffer_JSON(ByteBuf buffer) throws Exception {
        byte[] req = new byte[buffer.readableBytes()];
        buffer.readBytes(req);
        String jsonStr = new String(req, "UTF-8");
        return jsonStr;
    }

    public static Protocal fromIOBuffer(ByteBuf buffer) throws Exception {
        return ServerToolKits.toProtocal(ServerToolKits.fromIOBuffer_JSON(buffer));
    }

    public static Protocal toProtocal(String protocalJSONStr) throws Exception {
        return ProtocalFactory.parse(protocalJSONStr, Protocal.class);
    }

    public static enum SenseModeWebsocket {
        MODE_3S,
        MODE_5S,
        MODE_10S,
        MODE_15S,
        MODE_30S,
        MODE_60S,
        MODE_120S;

    }

    public static enum SenseModeUDP {
        MODE_3S,
        MODE_10S,
        MODE_30S,
        MODE_60S,
        MODE_120S;

    }

    public static enum SenseModeTCP {
        MODE_3S,
        MODE_5S,
        MODE_10S,
        MODE_15S,
        MODE_30S,
        MODE_60S,
        MODE_120S;

    }
}

