/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.network;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.udp.MBUDPClientInboundHandler;
import net.x52im.mobileimsdk.server.network.udp.MBUDPServerChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayUDP
extends Gateway {
    private static Logger logger = LoggerFactory.getLogger(GatewayUDP.class);
    public static int PORT = 7901;
    public static int SESION_RECYCLER_EXPIRE = 10;
    protected final EventLoopGroup __bossGroup4Netty = new NioEventLoopGroup();
    protected final EventLoopGroup __workerGroup4Netty = new DefaultEventLoopGroup();
    protected Channel __serverChannel4Netty = null;
    protected ServerBootstrap bootstrap = null;

    @Override
    public void init(ServerCoreHandler serverCoreHandler) {
        this.bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.__bossGroup4Netty, this.__workerGroup4Netty).channel(MBUDPServerChannel.class)).childHandler(this.initChildChannelHandler(serverCoreHandler));
    }

    @Override
    public void bind() throws Exception {
        ChannelFuture cf = this.bootstrap.bind("0.0.0.0", PORT).syncUninterruptibly();
        if (cf.isSuccess()) {
            logger.info("[IMCORE-udp] \u57fa\u4e8eMobileIMSDK\u7684UDP\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u6210\u529f \u221a");
        } else {
            logger.info("[IMCORE-udp] \u57fa\u4e8eMobileIMSDK\u7684UDP\u670d\u52a1\u7ed1\u5b9a\u7aef\u53e3" + PORT + "\u5931\u8d25 \u00d7");
        }
        this.__serverChannel4Netty = cf.channel();
        this.__serverChannel4Netty.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                GatewayUDP.this.__bossGroup4Netty.shutdownGracefully();
                GatewayUDP.this.__workerGroup4Netty.shutdownGracefully();
            }
        });
        logger.info("[IMCORE-udp] .... continue ...");
        logger.info("[IMCORE-udp] \u57fa\u4e8eMobileIMSDK\u7684UDP\u670d\u52a1\u6b63\u5728\u7aef\u53e3" + PORT + "\u4e0a\u76d1\u542c\u4e2d...");
    }

    @Override
    public void shutdown() {
        if (this.__serverChannel4Netty != null) {
            this.__serverChannel4Netty.close();
        }
    }

    protected ChannelHandler initChildChannelHandler(final ServerCoreHandler serverCoreHandler) {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(SESION_RECYCLER_EXPIRE)}).addLast(new ChannelHandler[]{new MBUDPClientInboundHandler(serverCoreHandler)});
            }
        };
    }
}

