/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server.bridge;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQProvider {
    private static Logger logger = LoggerFactory.getLogger(MQProvider.class);
    public static final String DEFAULT_ENCODE_CHARSET = "UTF-8";
    public static final String DEFAULT_DECODE_CHARSET = "UTF-8";
    protected ConnectionFactory _factory = null;
    protected Connection _connection = null;
    protected Channel _pubChannel = null;
    protected Channel _workerChannel = null;
    protected final Timer timerForStartAgain = new Timer();
    protected boolean startRunning = false;
    protected final Timer timerForRetryWorker = new Timer();
    protected boolean retryWorkerRunning = false;
    protected ConcurrentLinkedQueue<String[]> publishTrayAgainCache = new ConcurrentLinkedQueue();
    protected boolean publishTrayAgainEnable = false;
    protected Observer consumerObserver = null;
    protected String encodeCharset = null;
    protected String decodeCharset = null;
    protected String mqURI = null;
    protected String publishToQueue = null;
    protected String consumFromQueue = null;
    protected String TAG = null;

    public MQProvider(String mqURI, String publishToQueue, String consumFromQueue, String TAG, boolean publishTrayAgainEnable) {
        this(mqURI, publishToQueue, consumFromQueue, null, null, TAG, publishTrayAgainEnable);
    }

    public MQProvider(String mqURI, String publishToQueue, String consumFromQueue, String encodeCharset, String decodeCharset, String TAG, boolean publishTrayAgainEnable) {
        this.mqURI = mqURI;
        this.publishToQueue = publishToQueue;
        this.consumFromQueue = consumFromQueue;
        this.encodeCharset = encodeCharset;
        this.decodeCharset = decodeCharset;
        this.TAG = TAG;
        if (this.mqURI == null) {
            throw new IllegalArgumentException("[" + TAG + "]\u65e0\u6548\u7684\u53c2\u6570mqURI \uff01");
        }
        if (this.publishToQueue == null && this.consumFromQueue == null) {
            throw new IllegalArgumentException("[" + TAG + "]\u65e0\u6548\u7684\u53c2\u6570\uff0cpublishToQueue(\u751f\u4ea7\u8005\u961f\u5217\u540d)\u548cconsumFromQueue(\u6d88\u8d39\u8005\u961f\u5217\u540d)\u81f3\u5c11\u5e94\u8bbe\u7f6e\u5176\u4e00\uff01");
        }
        if (this.encodeCharset == null || this.encodeCharset.trim().length() == 0) {
            this.encodeCharset = "UTF-8";
        }
        if (this.decodeCharset == null || this.decodeCharset.trim().length() == 0) {
            this.decodeCharset = "UTF-8";
        }
        this.init();
    }

    protected boolean init() {
        String uri = this.mqURI;
        this._factory = new ConnectionFactory();
        try {
            this._factory.setUri(uri);
        }
        catch (Exception e) {
            logger.error("[" + this.TAG + "] - \u3010\u4e25\u91cd\u3011factory.setUri()\u65f6\u51fa\u9519\uff0cUri\u683c\u5f0f\u4e0d\u5bf9\u54e6\uff0curi=" + uri, (Throwable)e);
            return false;
        }
        this._factory.setAutomaticRecoveryEnabled(true);
        this._factory.setTopologyRecoveryEnabled(false);
        this._factory.setNetworkRecoveryInterval(5000);
        this._factory.setRequestedHeartbeat(30);
        this._factory.setConnectionTimeout(30000);
        return true;
    }

    protected Connection tryGetConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._factory.newConnection();
                this._connection.addShutdownListener(new ShutdownListener(){

                    public void shutdownCompleted(ShutdownSignalException cause) {
                        logger.warn("[" + MQProvider.this.TAG + "] - \u8fde\u63a5\u5df2\u7ecf\u5173\u95ed\u4e86(\u539f\u56e0\uff1a" + (cause.isHardError() ? "connection\u5f02\u5e38" : "channel\u5f02\u5e38") + ")\u3002\u3002\u3002\u3002\u3010NO\u3011");
                    }
                });
                ((Recoverable)this._connection).addRecoveryListener(new RecoveryListener(){

                    public void handleRecovery(Recoverable recoverable) {
                        logger.info("[" + MQProvider.this.TAG + "] - \u8fde\u63a5\u5df2\u6210\u529f\u81ea\u52a8\u6062\u590d\u4e86\uff01\u3010OK\u3011");
                        MQProvider.this.start();
                    }

                    public void handleRecoveryStarted(Recoverable recoverable) {
                        logger.info("[" + MQProvider.this.TAG + "] - \u8fde\u63a5\u9a6c\u4e0a\u5f00\u59cb\u81ea\u52a8\u6062\u590d\u3002\u3002\u3002" + "(c=" + recoverable.getClass().getSimpleName() + ")");
                    }

                    public void handleTopologyRecoveryStarted(Recoverable recoverable) {
                        logger.info("[" + MQProvider.this.TAG + "] - \u62d3\u6251\u8fde\u63a5\u9a6c\u4e0a\u5f00\u59cb\u81ea\u52a8\u6062\u590d\u3002\u3002\u3002" + "(c=" + recoverable.getClass().getSimpleName() + ")");
                    }
                });
            }
            catch (Exception e) {
                logger.error("[" + this.TAG + "] - \u3010NO\u3011getConnection()\u65f6\u51fa\u9519\u4e86\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage(), (Throwable)e);
                this._connection = null;
                return null;
            }
        }
        return this._connection;
    }

    public void start() {
        if (this.startRunning) {
            return;
        }
        try {
            if (this._factory != null) {
                Connection conn = this.tryGetConnection();
                if (conn != null) {
                    this.whenConnected(conn);
                } else {
                    logger.error("[" + this.TAG + "-\u2191] - [start()\u4e2d]\u3010\u4e25\u91cd\u3011connction\u8fd8\u6ca1\u6709\u51c6\u5907\u597d\uff0cconn.createChannel()\u5931\u8d25\uff0cstart()\u6ca1\u6709\u7ee7\u7eed\uff01(\u539f\u56e0\uff1aconnction==null)\u30105\u79d2\u540e\u91cd\u65b0\u5c1d\u8bd5start\u3011");
                    this.timerForStartAgain.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            MQProvider.this.start();
                        }
                    }, 5000L);
                }
            } else {
                logger.error("[" + this.TAG + "-\u2191] - [start()\u4e2d]\u3010\u4e25\u91cd\u3011factory\u8fd8\u6ca1\u6709\u51c6\u5907\u597d\uff0cstart()\u5931\u8d25\uff01(\u539f\u56e0\uff1afactory==null)");
            }
        }
        finally {
            this.startRunning = false;
        }
    }

    protected void whenConnected(Connection conn) {
        this.startPublisher(conn);
        this.startWorker(conn);
    }

    protected void startPublisher(Connection conn) {
        if (conn != null) {
            if (this._pubChannel != null && this._pubChannel.isOpen()) {
                try {
                    this._pubChannel.close();
                }
                catch (Exception e) {
                    logger.warn("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d]pubChannel.close()\u65f6\u53d1\u751f\u9519\u8bef\u3002", (Throwable)e);
                }
            }
            try {
                this._pubChannel = conn.createChannel();
                logger.info("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d] \u7684channel\u6210\u529f\u521b\u5efa\u4e86\uff0c\u9a6c\u4e0a\u5f00\u59cb\u5faa\u73afpublish\u6d88\u606f\uff0c\u5f53\u524d\u6570\u7ec4\u961f\u5217\u957f\u5ea6\uff1aN/A\uff01\u3010OK\u3011");
                String queue = this.publishToQueue;
                boolean durable = true;
                boolean exclusive = false;
                boolean autoDelete = false;
                AMQP.Queue.DeclareOk qOK = this._pubChannel.queueDeclare(queue, durable, exclusive, autoDelete, null);
                logger.info("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher\u4e2d] Queue[\u5f53\u524d\u961f\u5217\u6d88\u606f\u6570\uff1a" + qOK.getMessageCount() + ",\u6d88\u8d39\u8005\uff1a" + qOK.getConsumerCount() + "]\u5df2\u6210\u529f\u5efa\u7acb\uff0cPublisher(\u751f\u4ea7\u8005)\u521d\u59cb\u5316\u6210\u529f\uff0c\u6d88\u606f\u5c06\u53efpublish\u8fc7\u53bb\u4e14\u4e0d\u6015\u4e22\u5931\u4e86\u3002\u3010OK\u3011(\u5f53\u524d\u6682\u5b58\u6570\u7ec4\u957f\u5ea6:N/A)");
                if (this.publishTrayAgainEnable) {
                    while (this.publishTrayAgainCache.size() > 0) {
                        String[] m = this.publishTrayAgainCache.poll();
                        if (m != null && m.length > 0) {
                            logger.debug("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d] [...]\u5728channel\u6210\u529f\u521b\u5efa\u540e\uff0c\u6b63\u5728publish\u4e4b\u524d\u5931\u8d25\u6682\u5b58\u7684\u6d88\u606f m[0]=" + m[0] + "\u3001m[1]=" + m[1] + ",\u3001m[2]=" + m[2] + "\uff0c[\u5f53\u524d\u6570\u7ec4\u961f\u5217\u957f\u5ea6\uff1a" + this.publishTrayAgainCache.size() + "]\uff01\u3010OK\u3011");
                            this.publish(m[0], m[1], m[2]);
                            continue;
                        }
                        logger.debug("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d] [___]\u5728channel\u6210\u529f\u521b\u5efa\u540e\uff0c\u5f53\u524d\u4e4b\u524d\u5931\u8d25\u6682\u5b58\u7684\u6570\u636e\u961f\u5217\u5df2\u4e3a\u7a7a\uff0cpublish\u6ca1\u6709\u7ee7\u7eed\uff01[\u5f53\u524d\u6570\u7ec4\u961f\u5217\u957f\u5ea6\uff1a" + this.publishTrayAgainCache.size() + "]\uff01\u3010OK\u3011");
                    }
                }
            }
            catch (Exception e) {
                logger.error("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d] conn.createChannel()\u6216pubChannel.queueDeclare()\u51fa\u9519\u4e86\uff0c\u672c\u6b21startPublisher\u6ca1\u6709\u7ee7\u7eed\uff01", (Throwable)e);
            }
        } else {
            logger.error("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005startPublisher()\u4e2d]\u3010\u4e25\u91cd\u3011connction\u8fd8\u6ca1\u6709\u51c6\u5907\u597d\uff0cconn.createChannel()\u5931\u8d25\uff01(\u539f\u56e0\uff1aconnction==null)");
        }
    }

    public boolean publish(String message) {
        return this.publish("", this.publishToQueue, message);
    }

    protected boolean publish(String exchangeName, String routingKey, String message) {
        boolean ok = false;
        try {
            this._pubChannel.basicPublish(exchangeName, routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, message.getBytes(this.encodeCharset));
            logger.info("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005publish()\u4e2d] publish()\u6210\u529f\u4e86 \uff01(\u6570\u636e:" + exchangeName + "," + routingKey + "," + message + ")");
            ok = true;
        }
        catch (Exception e) {
            if (this.publishTrayAgainEnable) {
                this.publishTrayAgainCache.add(new String[]{exchangeName, routingKey, message});
            }
            logger.error("[" + this.TAG + "-\u2191] - [\u751f\u4ea7\u8005publish()\u4e2d] publish()\u65f6Exception\u4e86\uff0c\u539f\u56e0\uff1a" + e.getMessage() + "\u3010\u6570\u636e[" + exchangeName + "," + routingKey + "," + message + "]\u5df2\u91cd\u65b0\u653e\u56de\u6570\u7ec4\u9996\u4f4d\uff0c\u5f53\u524d\u6570\u7ec4\u957f\u5ea6\uff1aN/A\u3011", (Throwable)e);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startWorker(Connection conn) {
        block10: {
            if (this.retryWorkerRunning) {
                return;
            }
            try {
                if (conn != null) {
                    if (this._workerChannel != null && this._workerChannel.isOpen()) {
                        try {
                            this._workerChannel.close();
                        }
                        catch (Exception e) {
                            logger.warn("[" + this.TAG + "-\u2191] - [\u6d88\u8d39\u8005startWorker()\u4e2d]workerChannel.close()\u65f6\u53d1\u751f\u9519\u8bef\u3002", (Throwable)e);
                        }
                    }
                    this._workerChannel = conn.createChannel();
                    String queueName = this.consumFromQueue;
                    DefaultConsumer dc = new DefaultConsumer(this._workerChannel){

                        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                            try {
                                String routingKey = envelope.getRoutingKey();
                                String contentType = properties.getContentType();
                                long deliveryTag = envelope.getDeliveryTag();
                                logger.info("[" + MQProvider.this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2d\u7684handleDelivery] \u6536\u5230\u4e00\u6761\u65b0\u6d88\u606f(routingKey=" + routingKey + ",contentType=" + contentType + ",consumerTag=" + consumerTag + ",deliveryTag=" + deliveryTag + ")\uff0c\u9a6c\u4e0a\u5f00\u59cb\u5904\u7406\u3002\u3002\u3002\u3002");
                                boolean workOK = MQProvider.this.work(body);
                                if (workOK) {
                                    MQProvider.this._workerChannel.basicAck(deliveryTag, false);
                                } else {
                                    MQProvider.this._workerChannel.basicReject(deliveryTag, true);
                                }
                            }
                            catch (Exception ee) {
                                logger.info("[" + MQProvider.this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2dhandleDelivery\u65f6] \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u5c06\u88ab\u8bb0\u5f55\uff1a" + ee.getMessage(), (Throwable)ee);
                            }
                        }
                    };
                    boolean autoAck = false;
                    this._workerChannel.basicConsume(queueName, autoAck, (Consumer)dc);
                    logger.info("[" + this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2d] Worker(\u6d88\u8d39\u8005)\u5df2\u7ecf\u6210\u529f\u5f00\u542f\u5e76\u8fd0\u884c\u4e2d...\u3010OK\u3011");
                    break block10;
                }
                throw new Exception("[" + this.TAG + "-\u2193] - \u3010\u4e25\u91cd\u3011connction\u8fd8\u6ca1\u6709\u51c6\u5907\u597d\uff0cconn.createChannel()\u5931\u8d25\uff01(\u539f\u56e0\uff1aconnction==null)");
            }
            catch (Exception e) {
                logger.error("[" + this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2d] conn.createChannel()\u6216Consumer\u64cd\u4f5c\u65f6\u51fa\u9519\u4e86\uff0c\u672c\u6b21startWorker\u6ca1\u6709\u7ee7\u7eed\u3010\u6682\u505c5\u79d2\u540e\u91cd\u8bd5startWorker()\u3011\uff01", (Throwable)e);
                this.timerForRetryWorker.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MQProvider.this.startWorker(MQProvider.this._connection);
                    }
                }, 5000L);
            }
            finally {
                this.retryWorkerRunning = false;
            }
        }
    }

    protected boolean work(byte[] contentBody) {
        try {
            String msg = new String(contentBody, this.decodeCharset);
            logger.info("[" + this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2dwork\u65f6] Got msg\uff1a" + msg);
            return true;
        }
        catch (Exception e) {
            logger.warn("[" + this.TAG + "-\u2193] - [\u6d88\u8d39\u8005startWorker()\u4e2dwork\u65f6] \u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u5c06\u88ab\u8bb0\u5f55\uff1a" + e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

