/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server;

import java.io.IOException;
import net.x52im.mobileimsdk.server.ServerCoreHandler;
import net.x52im.mobileimsdk.server.event.MessageQoSEventListenerS2C;
import net.x52im.mobileimsdk.server.event.ServerEventListener;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.network.GatewayTCP;
import net.x52im.mobileimsdk.server.network.GatewayUDP;
import net.x52im.mobileimsdk.server.network.GatewayWebsocket;
import net.x52im.mobileimsdk.server.qos.QoS4ReciveDaemonC2S;
import net.x52im.mobileimsdk.server.qos.QoS4SendDaemonS2C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerLauncher {
    private static Logger logger = LoggerFactory.getLogger(ServerLauncher.class);
    public static boolean serverTimestamp = false;
    public static boolean bridgeEnabled = false;
    public static int supportedGateways = 0;
    protected ServerCoreHandler serverCoreHandler = null;
    private boolean running = false;
    private Gateway udp = null;
    private Gateway tcp = null;
    private Gateway ws = null;

    protected ServerCoreHandler initServerCoreHandler() {
        return new ServerCoreHandler();
    }

    protected abstract void initListeners();

    protected void initGateways() {
        if (Gateway.isSupportUDP(supportedGateways)) {
            this.udp = this.createGatewayUDP();
            this.udp.init(this.serverCoreHandler);
        }
        if (Gateway.isSupportTCP(supportedGateways)) {
            this.tcp = this.createGatewayTCP();
            this.tcp.init(this.serverCoreHandler);
        }
        if (Gateway.isSupportWebSocket(supportedGateways)) {
            this.ws = this.createGatewayWebsocket();
            this.ws.init(this.serverCoreHandler);
        }
    }

    protected GatewayUDP createGatewayUDP() {
        return new GatewayUDP();
    }

    protected GatewayTCP createGatewayTCP() {
        return new GatewayTCP();
    }

    protected GatewayWebsocket createGatewayWebsocket() {
        return new GatewayWebsocket();
    }

    public void startup() throws Exception {
        if (!this.running) {
            this.serverCoreHandler = this.initServerCoreHandler();
            this.initListeners();
            this.initGateways();
            QoS4ReciveDaemonC2S.getInstance().startup();
            QoS4SendDaemonS2C.getInstance().startup(true).setServerLauncher(this);
            if (bridgeEnabled) {
                this.serverCoreHandler.lazyStartupBridgeProcessor();
                logger.info("[IMCORE] \u914d\u7f6e\u9879\uff1a\u5df2\u5f00\u542f\u4e0eMobileIMSDK Web\u7684\u4e92\u901a.");
            } else {
                logger.info("[IMCORE] \u914d\u7f6e\u9879\uff1a\u672a\u5f00\u542f\u4e0eMobileIMSDK Web\u7684\u4e92\u901a.");
            }
            this.bind();
            this.running = true;
        } else {
            logger.warn("[IMCORE] \u57fa\u4e8eMobileIMSDK\u7684\u901a\u4fe1\u670d\u52a1\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u672c\u6b21startup()\u5931\u8d25\uff0c\u8bf7\u5148\u8c03\u7528shutdown()\u540e\u518d\u8bd5\uff01");
        }
    }

    protected void bind() throws Exception {
        if (this.udp != null) {
            this.udp.bind();
        }
        if (this.tcp != null) {
            this.tcp.bind();
        }
        if (this.ws != null) {
            this.ws.bind();
        }
    }

    public void shutdown() {
        if (this.udp != null) {
            this.udp.shutdown();
        }
        if (this.tcp != null) {
            this.tcp.shutdown();
        }
        if (this.ws != null) {
            this.ws.shutdown();
        }
        QoS4ReciveDaemonC2S.getInstance().stop();
        QoS4SendDaemonS2C.getInstance().stop();
        this.running = false;
    }

    public ServerEventListener getServerEventListener() {
        return this.serverCoreHandler.getServerEventListener();
    }

    public void setServerEventListener(ServerEventListener serverEventListener) {
        this.serverCoreHandler.setServerEventListener(serverEventListener);
    }

    public MessageQoSEventListenerS2C getServerMessageQoSEventListener() {
        return this.serverCoreHandler.getServerMessageQoSEventListener();
    }

    public void setServerMessageQoSEventListener(MessageQoSEventListenerS2C serverMessageQoSEventListener) {
        this.serverCoreHandler.setServerMessageQoSEventListener(serverMessageQoSEventListener);
    }

    public ServerCoreHandler getServerCoreHandler() {
        return this.serverCoreHandler;
    }

    public boolean isRunning() {
        return this.running;
    }
}

