/*
 * Decompiled with CFR 0.152.
 */
package net.x52im.mobileimsdk.server;

import io.netty.channel.Channel;
import net.x52im.mobileimsdk.server.ServerLauncher;
import net.x52im.mobileimsdk.server.event.MessageQoSEventListenerS2C;
import net.x52im.mobileimsdk.server.event.ServerEventListener;
import net.x52im.mobileimsdk.server.network.Gateway;
import net.x52im.mobileimsdk.server.processor.BridgeProcessor;
import net.x52im.mobileimsdk.server.processor.LogicProcessor;
import net.x52im.mobileimsdk.server.processor.OnlineProcessor;
import net.x52im.mobileimsdk.server.protocal.Protocal;
import net.x52im.mobileimsdk.server.utils.LocalSendHelper;
import net.x52im.mobileimsdk.server.utils.ServerToolKits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCoreHandler {
    private static Logger logger = LoggerFactory.getLogger(ServerCoreHandler.class);
    protected ServerEventListener serverEventListener = null;
    protected MessageQoSEventListenerS2C serverMessageQoSEventListener = null;
    protected LogicProcessor logicProcessor = this.createLogicProcessor();
    protected BridgeProcessor bridgeProcessor = null;

    public ServerCoreHandler() {
        if (ServerLauncher.bridgeEnabled) {
            this.bridgeProcessor = this.createBridgeProcessor();
        }
    }

    protected LogicProcessor createLogicProcessor() {
        return new LogicProcessor(this);
    }

    protected BridgeProcessor createBridgeProcessor() {
        BridgeProcessor bp = new BridgeProcessor(){

            @Override
            protected void realtimeC2CSuccessCallback(Protocal p) {
                ServerCoreHandler.this.serverEventListener.onTransferMessage4C2C(p);
            }

            @Override
            protected boolean offlineC2CProcessCallback(Protocal p) {
                return ServerCoreHandler.this.serverEventListener.onTransferMessage_RealTimeSendFaild(p);
            }
        };
        return bp;
    }

    public void lazyStartupBridgeProcessor() {
        if (ServerLauncher.bridgeEnabled && this.bridgeProcessor != null) {
            this.bridgeProcessor.start();
        }
    }

    public void exceptionCaught(Channel session, Throwable cause) throws Exception {
        logger.debug("[IMCORE-" + Gateway.$(session) + "]\u6b64\u5ba2\u6237\u7aef\u7684Channel\u629b\u51fa\u4e86exceptionCaught\uff0c\u539f\u56e0\u662f\uff1a" + cause.getMessage() + "\uff0c\u53ef\u4ee5\u63d0\u524dclose\u6389\u4e86\u54e6\uff01", cause);
        session.close();
    }

    public void messageReceived(Channel session, Protocal pFromClient) throws Exception {
        String remoteAddress = ServerToolKits.clientInfoToString(session);
        switch (pFromClient.getType()) {
            case 4: {
                logger.info("[IMCORE-{}]<< \u6536\u5230\u5ba2\u6237\u7aef{}\u7684ACK\u5e94\u7b54\u5305\u53d1\u9001\u8bf7\u6c42.", (Object)Gateway.$(session), (Object)remoteAddress);
                if (!OnlineProcessor.isLogined(session)) {
                    LocalSendHelper.replyDataForUnlogined(session, pFromClient, null);
                    return;
                }
                this.logicProcessor.processACK(pFromClient, remoteAddress);
                break;
            }
            case 2: {
                logger.info("[IMCORE-{}]<< \u6536\u5230\u5ba2\u6237\u7aef{}\u7684\u901a\u7528\u6570\u636e\u53d1\u9001\u8bf7\u6c42.", (Object)Gateway.$(session), (Object)remoteAddress);
                if (this.serverEventListener != null) {
                    if (!OnlineProcessor.isLogined(session)) {
                        LocalSendHelper.replyDataForUnlogined(session, pFromClient, null);
                        return;
                    }
                    if ("0".equals(pFromClient.getTo())) {
                        if (!this.serverEventListener.onTransferMessage4C2SBefore(pFromClient, session)) break;
                        this.logicProcessor.processC2SMessage(session, pFromClient, remoteAddress);
                        break;
                    }
                    if (!this.serverEventListener.onTransferMessage4C2CBefore(pFromClient, session)) break;
                    this.logicProcessor.processC2CMessage(this.bridgeProcessor, session, pFromClient, remoteAddress);
                    break;
                }
                logger.warn("[IMCORE-{}]<< \u6536\u5230\u5ba2\u6237\u7aef{}\u7684\u901a\u7528\u6570\u636e\u4f20\u8f93\u6d88\u606f\uff0c\u4f46\u56de\u8c03\u5bf9\u8c61\u662fnull\uff0c\u56de\u8c03\u65e0\u6cd5\u7ee7\u7eed.", (Object)Gateway.$(session), (Object)remoteAddress);
                break;
            }
            case 1: {
                if (!OnlineProcessor.isLogined(session)) {
                    LocalSendHelper.replyDataForUnlogined(session, pFromClient, null);
                    return;
                }
                this.logicProcessor.processKeepAlive(session, pFromClient, remoteAddress);
                break;
            }
            case 0: {
                this.logicProcessor.processLogin(session, pFromClient, remoteAddress);
                break;
            }
            case 3: {
                logger.info("[IMCORE-{}]<< \u6536\u5230\u5ba2\u6237\u7aef{}\u7684\u9000\u51fa\u767b\u9646\u8bf7\u6c42.", (Object)Gateway.$(session), (Object)remoteAddress);
                session.close();
                break;
            }
            case 5: {
                pFromClient.setType(53);
                LocalSendHelper.sendData(session, pFromClient, null);
                break;
            }
            default: {
                logger.warn("[IMCORE-{}]\u3010\u6ce8\u610f\u3011\u6536\u5230\u7684\u5ba2\u6237\u7aef{}\u6d88\u606f\u7c7b\u578b\uff1a{}\uff0c\u4f46\u76ee\u524d\u8be5\u7c7b\u578b\u670d\u52a1\u7aef\u4e0d\u652f\u6301\u89e3\u6790\u548c\u5904\u7406\uff01", new Object[]{Gateway.$(session), remoteAddress, pFromClient.getType()});
            }
        }
    }

    public void sessionClosed(Channel session) throws Exception {
        String user_id = OnlineProcessor.getUserIdFromChannel(session);
        if (user_id != null) {
            Channel sessionInOnlinelist = OnlineProcessor.getInstance().getOnlineSession(user_id);
            logger.info("[IMCORE-{}]{}\u7684\u4f1a\u8bdd\u5df2\u5173\u95ed(user_id={}, firstLoginTime={})\u4e86...", new Object[]{Gateway.$(session), ServerToolKits.clientInfoToString(session), user_id, OnlineProcessor.getFirstLoginTimeFromChannel(session)});
            logger.info(".......... \u30100\u3011[\u5f53\u524d\u6b63\u5728\u88ab\u5173\u95ed\u7684session] session.hashCode={}, session.ip+port={}", (Object)session.hashCode(), (Object)session.remoteAddress());
            if (sessionInOnlinelist != null) {
                logger.info(".......... \u30101\u3011[\u5904\u4e8e\u5728\u7ebf\u5217\u8868\u4e2d\u7684session] session.hashCode={}, session.ip+port=", (Object)sessionInOnlinelist.hashCode(), (Object)sessionInOnlinelist.remoteAddress());
            }
            if (sessionInOnlinelist != null && session != null && session == sessionInOnlinelist) {
                int beKickoutCode = OnlineProcessor.getBeKickoutCodeFromChannel(session);
                OnlineProcessor.removeAttributesForChannel(session);
                OnlineProcessor.getInstance().removeUser(user_id);
                if (this.serverEventListener != null) {
                    this.serverEventListener.onUserLogout(user_id, session, beKickoutCode);
                } else {
                    logger.debug("[IMCORE-{}]>> \u4f1a\u8bdd{}\u88ab\u7cfb\u7edfclose\u4e86\uff0c\u4f46\u56de\u8c03\u5bf9\u8c61\u662fnull\uff0c\u6ca1\u6709\u8fdb\u884c\u56de\u8c03\u901a\u77e5.", (Object)Gateway.$(session), (Object)ServerToolKits.clientInfoToString(session));
                }
            } else {
                logger.warn("[IMCORE-{}]\u30102\u3011\u3010\u6ce8\u610f\u3011\u4f1a\u8bdd{}\u4e0d\u5728\u5728\u7ebf\u5217\u8868\u4e2d\uff0c\u610f\u5473\u7740\u5b83\u662f\u88ab\u5ba2\u6237\u7aef\u5f03\u7528/\u6216\u88ab\u670d\u52a1\u7aef\u5f3a\u8e22\uff0c\u672c\u6b21\u5ffd\u7565\u8fd9\u6761\u5173\u95ed\u4e8b\u4ef6\u5373\u53ef\uff01", (Object)Gateway.$(session), (Object)ServerToolKits.clientInfoToString(session));
            }
        } else {
            logger.warn("[IMCORE-{}]\u3010\u6ce8\u610f\u3011\u4f1a\u8bdd{}\u88ab\u7cfb\u7edfclose\u4e86\uff0c\u4f46\u5b83\u91cc\u9762\u6ca1\u6709\u5b58\u653euser_id\uff0c\u5b83\u5f88\u53ef\u80fd\u662f\u6ca1\u6709\u6210\u529f\u5408\u6cd5\u8ba4\u8bc1\u800c\u88ab\u63d0\u524d\u5173\u95ed\uff0c\u4ece\u800c\u6b63\u5e38\u91ca\u653e\u8d44\u6e90\u3002", (Object)Gateway.$(session), (Object)ServerToolKits.clientInfoToString(session));
        }
    }

    public void sessionCreated(Channel session) throws Exception {
        logger.info("[IMCORE-{}]\u4e0e{}\u7684\u4f1a\u8bdd\u5efa\u7acb(channelActive)\u4e86...", (Object)Gateway.$(session), (Object)ServerToolKits.clientInfoToString(session));
    }

    public ServerEventListener getServerEventListener() {
        return this.serverEventListener;
    }

    void setServerEventListener(ServerEventListener serverEventListener) {
        this.serverEventListener = serverEventListener;
    }

    public MessageQoSEventListenerS2C getServerMessageQoSEventListener() {
        return this.serverMessageQoSEventListener;
    }

    void setServerMessageQoSEventListener(MessageQoSEventListenerS2C serverMessageQoSEventListener) {
        this.serverMessageQoSEventListener = serverMessageQoSEventListener;
    }

    public BridgeProcessor getBridgeProcessor() {
        return this.bridgeProcessor;
    }
}

